/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.analytics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.common.analytics.CommonUsageTracker;
import com.android.tools.idea.common.editor.DesignerEditorPanel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.stats.EditorStatsUtil;
import com.google.wireless.android.sdk.stats.EditorFileType;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020-H\u0004R\u001e\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006."}, d2={"Lcom/android/tools/idea/common/analytics/DesignerAnalyticsManager;", "", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "<init>", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "getSurface", "()Lcom/android/tools/idea/common/surface/DesignSurface;", "setSurface", "surfaceType", "Lcom/google/wireless/android/sdk/stats/LayoutEditorState$Surfaces;", "getSurfaceType", "()Lcom/google/wireless/android/sdk/stats/LayoutEditorState$Surfaces;", "panelState", "Lcom/android/tools/idea/common/editor/DesignerEditorPanel$State;", "value", "Lcom/google/wireless/android/sdk/stats/EditorFileType;", "editorFileType", "getEditorFileType", "()Lcom/google/wireless/android/sdk/stats/EditorFileType;", "editorMode", "Lcom/google/wireless/android/sdk/stats/LayoutEditorState$Mode;", "getEditorMode", "()Lcom/google/wireless/android/sdk/stats/LayoutEditorState$Mode;", "layoutType", "Lcom/google/wireless/android/sdk/stats/LayoutEditorState$Type;", "getLayoutType", "()Lcom/google/wireless/android/sdk/stats/LayoutEditorState$Type;", "trackShowIssuePanel", "", "trackUnknownEvent", "trackZoom", "type", "Lcom/android/tools/adtui/actions/ZoomType;", "setEditorModeWithoutTracking", "setEditorFileTypeWithoutTracking", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "trackSelectEditorMode", "trackIssuePanel", "minimized", "", "track", "Lcom/google/wireless/android/sdk/stats/LayoutEditorEvent$LayoutEditorEventType;", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public class DesignerAnalyticsManager {
    @NotNull
    private DesignSurface<?> surface;
    @NotNull
    private final LayoutEditorState.Surfaces surfaceType;
    @NotNull
    private DesignerEditorPanel.State panelState;
    @NotNull
    private EditorFileType editorFileType;
    @NotNull
    private final LayoutEditorState.Type layoutType;
    public static final int $stable = 8;

    public DesignerAnalyticsManager(@NotNull DesignSurface<?> surface2) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        this.surface = surface2;
        this.surfaceType = LayoutEditorState.Surfaces.UNKNOWN_SURFACES;
        this.panelState = DesignerEditorPanel.State.DEACTIVATED;
        this.editorFileType = EditorFileType.UNKNOWN;
        this.layoutType = LayoutEditorState.Type.UNKNOWN_TYPE;
    }

    @NotNull
    protected final DesignSurface<?> getSurface() {
        return this.surface;
    }

    protected final void setSurface(@NotNull DesignSurface<?> designSurface2) {
        Intrinsics.checkNotNullParameter(designSurface2, (String)"<set-?>");
        this.surface = designSurface2;
    }

    @NotNull
    public LayoutEditorState.Surfaces getSurfaceType() {
        return this.surfaceType;
    }

    @NotNull
    public final EditorFileType getEditorFileType() {
        return this.editorFileType;
    }

    @NotNull
    public final LayoutEditorState.Mode getEditorMode() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.panelState.ordinal()]) {
            case 1 -> LayoutEditorState.Mode.DESIGN_MODE;
            case 2 -> LayoutEditorState.Mode.PREVIEW_MODE;
            case 3 -> LayoutEditorState.Mode.UNKOWN_MODE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public LayoutEditorState.Type getLayoutType() {
        return this.layoutType;
    }

    public final void trackShowIssuePanel() {
        this.track(LayoutEditorEvent.LayoutEditorEventType.SHOW_LINT_MESSAGES);
    }

    public final void trackUnknownEvent() {
        this.track(LayoutEditorEvent.LayoutEditorEventType.UNKNOWN_EVENT_TYPE);
    }

    public void trackZoom(@NotNull ZoomType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.ZOOM_ACTUAL);
                break;
            }
            case 2: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.ZOOM_IN);
                break;
            }
            case 3: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.ZOOM_OUT);
                break;
            }
            case 4: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.ZOOM_FIT);
                break;
            }
        }
    }

    public final void setEditorModeWithoutTracking(@NotNull DesignerEditorPanel.State panelState) {
        Intrinsics.checkNotNullParameter((Object)((Object)panelState), (String)"panelState");
        this.panelState = panelState;
    }

    public final void setEditorFileTypeWithoutTracking(@NotNull VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.editorFileType = (EditorFileType)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super EditorFileType>, Object>(file2, project, null){
            int label;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;
            {
                this.$file = $file;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = EditorStatsUtil.getEditorFileTypeForAnalytics((VirtualFile)this.$file, (Project)this.$project, (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super EditorFileType> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public final void trackSelectEditorMode(@NotNull DesignerEditorPanel.State panelState) {
        Intrinsics.checkNotNullParameter((Object)((Object)panelState), (String)"panelState");
        switch (WhenMappings.$EnumSwitchMapping$0[panelState.ordinal()]) {
            case 1: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.SELECT_VISUAL_MODE);
                break;
            }
            case 2: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.SELECT_SPLIT_MODE);
                break;
            }
            case 3: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.SELECT_TEXT_MODE);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void trackIssuePanel(boolean minimized) {
        if (minimized) {
            this.track(LayoutEditorEvent.LayoutEditorEventType.MINIMIZE_ERROR_PANEL);
        } else {
            this.track(LayoutEditorEvent.LayoutEditorEventType.RESTORE_ERROR_PANEL);
        }
    }

    protected final void track(@NotNull LayoutEditorEvent.LayoutEditorEventType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        CommonUsageTracker.Companion.getInstance(this.surface).logAction(type);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DesignerEditorPanel.State.values().length];
            try {
                nArray[DesignerEditorPanel.State.FULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DesignerEditorPanel.State.SPLIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DesignerEditorPanel.State.DEACTIVATED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ZoomType.values().length];
            try {
                nArray[ZoomType.ACTUAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZoomType.IN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZoomType.OUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ZoomType.FIT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

