/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe.util;

public final class Bytes {
    public static float fixed8_24ToFloat(int fixed) {
        return (float)fixed / 1.6777216E7f;
    }

    public static float fixed16_16ToFloat(int fixed) {
        return (float)fixed / 65536.0f;
    }

    public static byte[] fromHexString(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Unexpected string length: " + hex);
        }
        byte[] data = new byte[hex.length() / 2];
        for (int i = 0; i < data.length; ++i) {
            int d1 = Bytes.hexToDigit(hex.charAt(i * 2)) << 4;
            int d2 = Bytes.hexToDigit(hex.charAt(i * 2 + 1));
            data[i] = (byte)(d1 + d2);
        }
        return data;
    }

    private static int hexToDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return 0;
    }
}

