/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe.decoder.psd;

import com.android.tools.pixelprobe.ColorMode;
import com.android.tools.pixelprobe.util.Strings;
import java.util.List;
import java.util.Map;

final class PsdFile {
    Header header;
    ColorData colorData;
    ImageResources resources;
    LayersInformation layersInfo;
    ImageData imageData;

    PsdFile() {
    }

    static final class FixedString {
        long length;
        String value;

        FixedString() {
        }

        public String toString() {
            return this.value;
        }
    }

    static final class MinimumString {
        long length;
        String value;

        MinimumString() {
        }

        public String toString() {
            return this.value;
        }
    }

    static final class UnicodeString {
        long length;
        String value;

        UnicodeString() {
        }

        public String toString() {
            if (this.value == null) {
                return null;
            }
            if (this.value.isEmpty()) {
                return "";
            }
            int lastChar = this.value.length() - 1;
            if (this.value.charAt(lastChar) == '\u0000') {
                return this.value.substring(0, lastChar);
            }
            return this.value;
        }
    }

    static final class FixedByteArray {
        long length;
        byte[] value;

        FixedByteArray() {
        }

        public String toString() {
            if (this.value == null) {
                return null;
            }
            return new String(this.value);
        }
    }

    static final class UnsignedShortBlock {
        static final int ID_INDEX_TABLE_COUNT = 1046;
        static final int ID_INDEX_TRANSPARENCY = 1047;
        int data;

        UnsignedShortBlock() {
        }
    }

    static final class ThumbnailResourceBlock {
        static final int ID = 1036;
        int format;
        long width;
        long height;
        long rowBytes;
        long size;
        long compressedSize;
        short bpp;
        short planes;
        byte[] thumbnail;

        ThumbnailResourceBlock() {
        }
    }

    static final class ResolutionInfoBlock {
        static final int ID = 1005;
        int horizontalResolution;
        ResolutionUnit horizontalUnit;
        DisplayUnit widthUnit;
        int verticalResolution;
        ResolutionUnit verticalUnit;
        DisplayUnit heightUnit;

        ResolutionInfoBlock() {
        }
    }

    static enum DisplayUnit {
        UNKNOWN,
        INCHES,
        CENTIMETERS,
        POINTS,
        PICAS,
        COLUMNS;

    }

    static enum ResolutionUnit {
        UNKNOWN,
        PIXEL_PER_INCH,
        PIXEL_PER_CM;

    }

    static final class ColorProfileBlock {
        static final int ID = 1039;
        byte[] icc;

        ColorProfileBlock() {
        }
    }

    static final class GuideBlock {
        int location;
        Orientation orientation;

        GuideBlock() {
        }
    }

    static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }

    static final class GuidesResourceBlock {
        static final int ID = 1032;
        int version;
        Void future;
        int guideCount;
        List<GuideBlock> guides;

        GuidesResourceBlock() {
        }
    }

    static final class DescriptorItem {
        MinimumString key;
        Value value;

        DescriptorItem() {
        }

        public String toString() {
            return "<item key=\"" + this.key + "\">" + String.valueOf(this.value) + "</item>";
        }

        static final class Value {
            String type;
            Object data;

            Value() {
            }

            public String toString() {
                if (this.data == null) {
                    return null;
                }
                return this.data.toString();
            }
        }

        static final class ValueList {
            int count;
            List<Value> items;

            ValueList() {
            }

            public String toString() {
                return "<list>" + Strings.join(this.items, ", ") + "</list>";
            }
        }

        static final class Reference {
            int count;
            List<Item> items;

            Reference() {
            }

            static final class Item {
                String type;
                Object data;

                Item() {
                }
            }
        }

        static final class Property {
            ClassType classType;
            MinimumString keyId;

            Property() {
            }
        }

        static final class ClassType {
            UnicodeString name;
            MinimumString classId;

            ClassType() {
            }
        }

        static final class UnitFloat {
            String unit;
            float value;

            UnitFloat() {
            }

            public String toString() {
                return Float.toString(this.value);
            }
        }

        static final class UnitDouble {
            static final String POINTS = "#Pnt";
            static final String MILLIMETERS = "#Mlm";
            static final String CENTIMETERS = "RrCm";
            static final String INCHES = "RrIn";
            static final String ANGLE_DEGREES = "#Ang";
            static final String RESOLUTION = "#Rsl";
            static final String RELATIVE = "#Rlt";
            static final String NONE = "#Nne";
            static final String PERCENT = "#Prc";
            static final String PIXELS = "#Pxl";
            String unit;
            double value;

            UnitDouble() {
            }

            public String toString() {
                String s = Double.toString(this.value);
                switch (this.unit) {
                    case "#Pnt": {
                        s = s + "pt";
                        break;
                    }
                    case "#Mlm": {
                        s = s + "mm";
                        break;
                    }
                    case "RrCm": {
                        s = s + "cm";
                        break;
                    }
                    case "RrIn": {
                        s = s + "in";
                        break;
                    }
                    case "#Ang": {
                        s = s + "\u00b0";
                        break;
                    }
                    case "#Rsl": {
                        s = s + "dpi";
                        break;
                    }
                    case "#Rlt": {
                        s = s + "dpp";
                        break;
                    }
                    case "#Nne": {
                        break;
                    }
                    case "#Prc": {
                        s = s + "%";
                        break;
                    }
                    case "#Pxl": {
                        s = s + "px";
                    }
                }
                return s;
            }
        }

        static final class Enumerated {
            MinimumString type;
            MinimumString value;

            Enumerated() {
            }

            public String toString() {
                return String.valueOf(this.value);
            }
        }
    }

    static final class Descriptor {
        static final String CLASS_ID_COLOR_RGB = "RGBC";
        static final String CLASS_ID_COLOR_HSB = "HSBC";
        static final String CLASS_ID_COLOR_CMYK = "CMYC";
        static final String CLASS_ID_COLOR_LAB = "LbCl";
        static final String CLASS_ID_COLOR_GRAY = "Grsc";
        UnicodeString name;
        MinimumString classId;
        int count;
        Map<String, DescriptorItem> items;

        Descriptor() {
        }

        public String toString() {
            return "<descriptor name=\"" + this.name + "\" classId=\"" + this.classId + "\">" + Strings.join(this.items.values(), "\n") + "</descriptor>";
        }
    }

    static final class ImageData {
        CompressionMethod compression;
        byte[] data;

        ImageData() {
        }
    }

    static enum CompressionMethod {
        RAW,
        RLE,
        ZIP,
        ZIP_NO_PREDICTION;

    }

    static final class ChannelImageData {
        CompressionMethod compression;
        byte[] data;

        ChannelImageData() {
        }
    }

    static final class ChannelsContainer {
        List<ChannelImageData> imageData;

        ChannelsContainer() {
        }
    }

    static final class PathRecord {
        static final int CLOSED_SUBPATH_LENGTH = 0;
        static final int CLOSED_SUBPATH_KNOT_LINKED = 1;
        static final int CLOSED_SUBPATH_KNOT_UNLINKED = 2;
        static final int OPEN_SUBPATH_LENGTH = 3;
        static final int OPEN_SUBPATH_KNOT_LINKED = 4;
        static final int OPEN_SUBPATH_KNOT_UNLINKED = 5;
        static final int PATH_FILL_RULE = 6;
        static final int CLIPBOARD = 7;
        static final int INITIAL_FILL_RULE = 8;
        short selector;
        Object data;

        PathRecord() {
        }

        static final class SubPath {
            static final int NO_OP = 0;
            static final int OP_XOR = 0;
            static final int OP_MERGE = 1;
            static final int OP_SUBTRACT = 2;
            static final int OP_INTERSECT = 3;
            int knotCount;
            int op;
            int tag;

            SubPath() {
            }
        }

        static final class BezierKnot {
            int controlEnterY;
            int controlEnterX;
            int anchorY;
            int anchorX;
            int controlExitY;
            int controlExitX;

            BezierKnot() {
            }
        }
    }

    static final class ShapeStroke {
        long version;
        Descriptor stroke;

        ShapeStroke() {
        }
    }

    static final class ShapeGraphics {
        String key;
        long version;
        Descriptor graphics;

        ShapeGraphics() {
        }
    }

    static final class ShapeMask {
        int version;
        int flags;
        List<PathRecord> pathRecords;

        ShapeMask() {
        }
    }

    static final class TypeToolObject {
        static final String KEY_TEXT = "Txt ";
        static final String KEY_ENGINE_DATA = "EngineData";
        short version;
        double xx;
        double xy;
        double yx;
        double yy;
        double tx;
        double ty;
        short textVersion;
        int testDescriptorVersion;
        Descriptor text;
        short warpVersion;
        int warpDescriptorVersion;
        Descriptor warp;
        int left;
        int top;
        int right;
        int bottom;

        TypeToolObject() {
        }
    }

    static final class SolidColorAdjustment {
        int version;
        Descriptor solidColor;

        SolidColorAdjustment() {
        }
    }

    static final class LayerSection {
        Type type;
        String signature;
        String blendMode;
        int subType;

        LayerSection() {
        }

        static enum Type {
            OTHER,
            GROUP_OPENED,
            GROUP_CLOSED,
            BOUNDING;

        }
    }

    static final class LayerEffects {
        static final String KEY_MASTER_SWITCH = "masterFXSwitch";
        static final String KEY_PRESENT = "present";
        static final String KEY_ENABLED = "enab";
        static final String KEY_INNER_SHADOW = "IrSh";
        static final String KEY_INNER_SHADOW_MULTI = "innerShadowMulti";
        static final String KEY_DROP_SHADOW = "DrSh";
        static final String KEY_DROP_SHADOW_MULTI = "dropShadowMulti";
        static final String KEY_STROKE = "FrFX";
        int version;
        int descriptorVersion;
        Descriptor effects;

        LayerEffects() {
        }
    }

    static final class LayerProperty {
        static final String KEY_EFFECTS = "lfx2";
        static final String KEY_MULTI_EFFECTS = "lmfx";
        static final String KEY_SECTION = "lsct";
        static final String KEY_NAME = "luni";
        static final String KEY_ADJUSTMENT_SOLID_COLOR = "SoCo";
        static final String KEY_FILL_OPACITY = "iOpa";
        static final String KEY_TEXT = "TySh";
        static final String KEY_VECTOR_MASK = "vmsk";
        static final String KEY_SHAPE_MASK = "vsms";
        static final String KEY_SHAPE_GRAPHICS = "vscg";
        static final String KEY_STROKE = "vstk";
        static final String KEY_LAYER_DEPTH_16 = "Lr16";
        static final String KEY_LAYER_DEPTH_32 = "Lr32";
        String signature;
        String key;
        long length;
        Object data;

        LayerProperty() {
        }
    }

    static final class BlendRange {
        short srcBlackIn;
        short srcWhiteIn;
        short srcBlackOut;
        short srcWhiteOut;
        short dstBlackIn;
        short dstWhiteIn;
        short dstBlackOut;
        short dstWhiteOut;

        BlendRange() {
        }
    }

    static final class MaskAdjustment {
        long length;
        long top;
        long left;
        long bottom;
        long right;
        short defaultColor;
        byte flags;
        byte maskParameters;
        short userMaskDensity;
        double userMaskFeather;
        short vectorMaskDensity;
        double vectorMaskFeather;
        short padding;
        byte realFlags;
        short userMaskBackground;
        long realTop;
        long realLeft;
        long realBottom;
        long realRight;

        MaskAdjustment() {
        }
    }

    static final class LayerExtras {
        MaskAdjustment maskAdjustment;
        long blendRangesLength;
        List<BlendRange> layerBlendRanges;
        short nameLength;
        String name;
        Void namePadding;
        Map<String, LayerProperty> properties;

        LayerExtras() {
        }
    }

    static final class ChannelInformation {
        short id;
        long dataLength;

        ChannelInformation() {
        }
    }

    static final class RawLayer {
        static final int INVISIBLE = 2;
        int top;
        int left;
        int bottom;
        int right;
        short channels;
        List<ChannelInformation> channelsInfo;
        String signature;
        String blendMode;
        short opacity;
        byte clipping;
        byte flags;
        Void filler;
        long extraLength;
        LayerExtras extras;

        RawLayer() {
        }
    }

    static final class LayersList {
        short count;
        List<RawLayer> layers;
        List<ChannelsContainer> channels;

        LayersList() {
        }
    }

    static final class LayersInformation {
        long length;
        long listLength;
        LayersList layers;
        long globalMaskInfoLength;
        Void globalMaskInfo;
        Map<String, LayerProperty> extras;

        LayersInformation() {
        }
    }

    static final class ImageResourceBlock {
        String signature;
        int id;
        short nameLength;
        String name;
        Void padding;
        long length;
        Object data;

        ImageResourceBlock() {
        }
    }

    static final class ImageResources {
        long length;
        Map<Integer, ImageResourceBlock> blocks;

        ImageResources() {
        }
    }

    static final class ColorData {
        long length;
        byte[] data;

        ColorData() {
        }
    }

    static final class Header {
        String signature;
        short version;
        Void reserved;
        int channels;
        int height;
        int width;
        short depth;
        ColorMode colorMode;

        Header() {
        }
    }
}

