/*
 * Decompiled with CFR 0.152.
 */
import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.Layer;
import com.android.tools.pixelprobe.PixelProbe;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;

public class ExtractRasterLayers {
    private static Path outputDir;

    public static void main(String[] args) {
        ExtractRasterLayers.checkArguments(args);
        Path inputDir = Paths.get(args[0], new String[0]).toAbsolutePath().normalize();
        if (Files.notExists(inputDir, new LinkOption[0])) {
            ExtractRasterLayers.printHelp();
            System.exit(1);
        }
        if (Files.notExists(outputDir = Paths.get(args[1], new String[0]).toAbsolutePath().normalize(), new LinkOption[0])) {
            try {
                Files.createDirectories(outputDir, new FileAttribute[0]);
            }
            catch (IOException e1) {
                System.err.println("Could not create output directory " + outputDir);
                System.exit(1);
            }
        }
        try {
            PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:**/*.psd");
            Files.list(inputDir).filter(matcher::matches).collect(Collectors.toList()).parallelStream().forEach(ExtractRasterLayers::extractLayers);
        }
        catch (IOException e) {
            System.err.println("An error occurred while reading the input directory.");
        }
    }

    private static void extractLayers(Path path) {
        File file = path.toFile();
        try (FileInputStream in = new FileInputStream(file);){
            Image image = PixelProbe.probe(in);
            image.getLayers().parallelStream().filter(layer -> layer.getType() == Layer.Type.IMAGE).forEach(layer -> ExtractRasterLayers.save(layer, file.getName()));
        }
        catch (IOException e) {
            System.err.println("An error occurred while parsing " + path);
        }
    }

    private static void save(Layer layer, String name) {
        BufferedImage image = layer.getImage();
        if (image == null) {
            return;
        }
        Path path = Paths.get(outputDir.toAbsolutePath().toString(), name);
        try {
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            path = path.resolve(layer.getName() + ".png");
            System.out.println("Writing " + outputDir.relativize(path));
            ImageIO.write((RenderedImage)ExtractRasterLayers.toSRGB(image), "PNG", path.toFile());
        }
        catch (IOException e) {
            System.err.println("An error occurred while writing " + path);
        }
    }

    private static BufferedImage toSRGB(BufferedImage bufferedImage) throws IOException {
        if (bufferedImage.getColorModel().getColorSpace().isCS_sRGB()) {
            return bufferedImage;
        }
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1000), new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
        return op.filter(bufferedImage, null);
    }

    private static void checkArguments(String[] args) {
        if (args.length < 2) {
            ExtractRasterLayers.printHelp();
            System.exit(1);
        }
    }

    private static void printHelp() {
        System.out.println("java ExtractRasterLayers <input dir> <output dir>\n");
        System.out.println("Finds all .psd files in <input dir> and extract the content ");
        System.out.println("of their raster layers in <output dir> as PNG files.");
    }
}

