/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dcl.lang.ide;

import com.android.tools.idea.gradle.dcl.lang.flags.DeclarativeIdeSupport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.project.GradleAutoReloadSettingsCollector;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class GradleDeclarativeScriptCollector
implements GradleAutoReloadSettingsCollector {
    private static final Logger LOG = Logger.getInstance(GradleDeclarativeScriptCollector.class);

    @NotNull
    public List<Path> collectSettingsFiles(@NotNull Project project, @NotNull GradleProjectSettings projectSettings) {
        SmartList files = new SmartList();
        if (!DeclarativeIdeSupport.isEnabled()) {
            return files;
        }
        for (String modulePath : projectSettings.getModules()) {
            ProgressManager.checkCanceled();
            try {
                Files.walkFileTree(Paths.get(modulePath, new String[0]), EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this, (List)files){
                    final /* synthetic */ List val$files;
                    {
                        this.val$files = list;
                    }

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                        File file;
                        String fileName = path.getFileName().toString();
                        if (fileName.endsWith(".gradle.dcl") && (file = path.toFile()).isFile()) {
                            this.val$files.add(path);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException | InvalidPathException e) {
                LOG.debug((Throwable)e);
            }
        }
        return files;
    }
}

