/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea;

import com.intellij.idea.Main;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class MainWrapper {
    private static final String USE_RAMDISK = "blaze.experiment.system.dir.ramdisk";
    private static final String IDEA_SYSTEM_PATH_KEY = "idea.system.path";

    public static void main(String[] args) throws IOException {
        if (Boolean.getBoolean(USE_RAMDISK)) {
            MainWrapper.removeDanglingRamdiskSymlink();
        }
        Main.main((String[])args);
    }

    private static void removeDanglingRamdiskSymlink() throws IOException {
        String path = System.getProperty(IDEA_SYSTEM_PATH_KEY);
        if (path == null) {
            throw new IOException("Please setting vmoptions idea.system.path before setting up ramdisk.");
        }
        Path systemPathConfigured = Path.of(path, new String[0]);
        if (Files.isSymbolicLink(systemPathConfigured) && !Files.exists(systemPathConfigured, new LinkOption[0])) {
            Files.delete(systemPathConfigured);
        }
    }
}

