/*
 * Decompiled with CFR 0.152.
 */
package com.google.targetsdkversionassistant.plan;

import com.google.targetsdkversionassistant.dsl.ElementListBuilder;
import com.google.targetsdkversionassistant.dsl.Ordering;
import com.google.targetsdkversionassistant.dsl.Par;
import com.google.targetsdkversionassistant.dsl.Seq;
import com.google.targetsdkversionassistant.plan.ApiUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/google/targetsdkversionassistant/plan/Api33;", "", "<init>", "()V", "label", "", "getLabel", "()Ljava/lang/String;", "description", "getDescription", "steps", "Lcom/google/targetsdkversionassistant/dsl/Seq;", "getSteps", "()Lcom/google/targetsdkversionassistant/dsl/Seq;", "targetsdkversion-upgrade-assistant"})
public final class Api33 {
    @NotNull
    public static final Api33 INSTANCE = new Api33();
    @NotNull
    private static final String label = ApiUtils.INSTANCE.rarrow$targetsdkversion_upgrade_assistant("Android 12L / API level 32", "Android 13 / API level 33");
    @NotNull
    private static final String description = StringsKt.trimIndent((String)("\n    Here are the major steps required to migrate from\n    Android 12L (API level 32) to Android 13 (API level 33).\n    " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n    For the complete list of changes introduced in Android 13 (API level 33), see the\n    " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("behavior changes page", "https://developer.android.com/about/versions/13/behavior-changes-13") + ".\n  "));
    @NotNull
    private static final Seq steps = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api33::steps$lambda$13));

    private Api33() {
    }

    @NotNull
    public final String getLabel() {
        return label;
    }

    @NotNull
    public final String getDescription() {
        return description;
    }

    @NotNull
    public final Seq getSteps() {
        return steps;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$0(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n            Apps targeting Android 13 (API level 33) and higher require the " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("POST_NOTIFICATIONS"), "https://developer.android.com/reference/android/Manifest.permission#POST_NOTIFICATIONS") + " permission to post most notifications.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            Request the new permission by declaring it in your app's manifest file such as in the following code snippet:\n          ")));
        $this$raw.xml("<manifest ...>\n    <uses-permission android:name=\"android.permission.POST_NOTIFICATIONS\"/>\n    <application ...>\n        ...\n    </application>\n</manifest>");
        $this$raw.text(StringsKt.trimIndent((String)("\n            Apps targeting Android 13 or higher with " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("POST_NOTIFICATIONS") + " in their manifests\n            have complete control over when the permission dialog is displayed.\n            Initially, " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("notifications are off by default") + " so you must request and acquire the notification permission\n            if you want to post notifications. There are several " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("best practices for when and how to do this", "https://developer.android.com/develop/ui/views/notifications/notification-permission#best-practices") + ".\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            When users are presented with the notifications permission dialog they have three options:\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            If the user selects \"Allow\" then your app can send notifications on all " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("notification channels", "https://developer.android.com/develop/ui/views/notifications/channels") + " and post " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("notifications related to foreground services", "https://developer.android.com/develop/ui/views/notifications#foreground-service") + " that appear in the " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("notification drawer", "https://developer.android.com/develop/ui/views/notifications#bar-and-drawer") + ".\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            If the user selects \"Don't allow\" then your app can't send notifications unless it qualifies for an exemption.\n            The user will see notices about foreground services in the " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Task Manager", "https://developer.android.com/guide/components/foreground-services#handle-user-initiated-stop") + ", but not in the " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("notification drawer", "https://developer.android.com/develop/ui/views/notifications#bar-and-drawer") + ".\n            Exemptions include:\n            " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("Notifications related to " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("media sessions", "https://developer.android.com/guide/topics/media-apps/working-with-a-media-session")) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("Notifications that use " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Notification.CallStyle"), "https://developer.android.com/reference/android/app/Notification.CallStyle") + " if your app " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("configures itself to self-manage phone calls", "https://developer.android.com/develop/ui/views/notifications/notification-permission#exemptions-self-manage-phone-calls")) + "\n            "))) + "\n            If the user swipes away the dialog then the state of the permission doesn't change.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            For more information, see " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Notification runtime permission", "https://developer.android.com/develop/ui/views/notifications/notification-permission") + ".\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$1(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          If your app uses Wi-Fi APIs and doesn't derive physical location information from them,\n          request users to grant your app the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("NEARBY_WIFI_DEVICES"), "https://developer.android.com/reference/android/Manifest.permission#NEARBY_WIFI_DEVICES") + " permission instead of the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ACCESS_FINE_LOCATION"), "https://developer.android.com/reference/android/Manifest.permission#ACCESS_FINE_LOCATION") + " permission.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          The runtime permission\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("NEARBY_WIFI_DEVICES"), "https://developer.android.com/reference/android/Manifest.permission#NEARBY_WIFI_DEVICES") + " introduced in Android 13 (API level 33) is in the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("NEARBY_DEVICES"), "https://developer.android.com/reference/android/Manifest.permission_group#NEARBY_DEVICES") + " permission group for apps that manage a device's connections to nearby access points\n          over Wi-Fi. This permission addresses the difficulties a user might have\n          associating location permissions with Wi-Fi functionality,\n          and fulfills several common Wi-Fi use cases.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          When you declare the\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("NEARBY_WIFI_DEVICES") + " permission, strongly assert that your app never derives physical location information\n          from Wi-Fi APIs. To do so, complete the following steps:\n          " + ApiUtils.INSTANCE.olist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              Add the\n              " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("android:usesPermissionFlags") + " attribute to your\n              " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("NEARBY_WIFI_DEVICES") + " permission declaration, and set this attribute\u2019s value to\n              " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("neverForLocation") + ".\n            "))) + "\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              If your location isn\u2019t otherwise needed for your app, remove the\n              " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ACCESS_FINE_LOCATION") + " permission from your app\u2019s manifest.\n            "))) + "\n          "))) + "\n          The following code snippet shows how to update your app's manifest file:\n        ")));
        $this$filtered.xml("<manifest>\n    <!-- Include \"neverForLocation\" only if you can strongly assert that\n         your app never derives physical location from Wi-Fi APIs. -->\n    <uses-permission android:name=\"android.permission.NEARBY_WIFI_DEVICES\"\n                     android:usesPermissionFlags=\"neverForLocation\" />\n\n    <!-- Not needed if you can strongly assert that your app never derives\n         physical location from Wi-Fi APIs and doesn't need location\n         access for any other purpose. -->\n    <uses-permission android:name=\"android.permission.ACCESS_FINE_LOCATION\" />\n    ...\n</manifest>");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          For more information, read about how to\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("request permission to access nearby Wi-Fi devices", "https://developer.android.com/guide/topics/connectivity/wifi-permissions") + " and view the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("list of affected APIs", "https://developer.android.com/guide/topics/connectivity/wifi-permissions#check-for-apis-that-require-permission") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$2(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          If your app needs to access media files that other apps have created,\n          you must request one or more of the following granular media permissions instead of the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_EXTERNAL_STORAGE"), "https://developer.android.com/reference/android/Manifest.permission#READ_EXTERNAL_STORAGE") + " permission:\n          <table>\n            <tr>\n              <th align=\"left\" valign=\"top\">Type of media</th>\n              <th align=\"left\" valign=\"top\">Permission to request</th>\n            </tr>\n            <tr>\n              <td align=\"left\" valign=\"top\">Images and photos</td>\n              <td align=\"left\" valign=\"top\">\n                " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_IMAGES"), "https://developer.android.com/reference/android/Manifest.permission#READ_MEDIA_IMAGES") + "\n              </td>\n            </tr>\n            <tr>\n              <td align=\"left\" valign=\"top\">Videos</td>\n              <td align=\"left\" valign=\"top\">\n                " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_VIDEO"), "https://developer.android.com/reference/android/Manifest.permission#READ_MEDIA_VIDEO") + "\n              </td>\n            </tr>\n            <tr>\n              <td align=\"left\" valign=\"top\">Audio files</td>\n              <td align=\"left\" valign=\"top\">\n                " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_AUDIO"), "https://developer.android.com/reference/android/Manifest.permission#READ_MEDIA_AUDIO") + "\n              </td>\n            </tr>\n          </table>\n          The following code snippet demonstrates how to declare\n          the appropriate storage permissions in the app\u2019s manifest file:\n        ")));
        $this$filtered.xml("<!-- Required only if your app needs to access images or photos\n     that other apps created. -->\n<uses-permission android:name=\"android.permission.READ_MEDIA_IMAGES\" />\n\n<!-- Required only if your app needs to access videos\n     that other apps created. -->\n<uses-permission android:name=\"android.permission.READ_MEDIA_VIDEO\" />\n\n<!-- Required only if your app needs to access audio files\n     that other apps created. -->\n<uses-permission android:name=\"android.permission.READ_MEDIA_AUDIO\" />\n\n<!-- If your app doesn't need to access media files that other apps created,\n     set the \"maxSdkVersion\" attribute to \"28\" instead. -->\n<uses-permission android:name=\"android.permission.READ_EXTERNAL_STORAGE\"\n                 android:maxSdkVersion=\"32\" />\n\n<uses-permission android:name=\"android.permission.WRITE_EXTERNAL_STORAGE\"\n                 android:maxSdkVersion=\"29\" />");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          Before you access another app's media files,\n          verify that the user has granted the appropriate granular media permissions to your app.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          If you request both the\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_IMAGES") + " permission and the\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_VIDEO") + " permission at the same time,\n          the system shows a single runtime permission dialog that mentions both permissions.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          If your app only needs to access images, photos, and videos, consider using the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("photo picker", "https://developer.android.com/about/versions/13/features/photopicker") + " instead of declaring the\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_IMAGES") + " and\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("READ_MEDIA_VIDEO") + " permissions.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          For more information, read about\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("access to other apps' media files", "https://developer.android.com/training/data-storage/shared/media#access-other-apps-files") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$3(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          If your app requires access to body sensor information while running in the background,\n          you must declare the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BODY_SENSORS_BACKGROUND"), "https://developer.android.com/reference/android/Manifest.permission#BODY_SENSORS_BACKGROUND") + " permission in addition to the existing\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BODY_SENSORS"), "https://developer.android.com/reference/android/Manifest.permission#BODY_SENSORS") + " permission.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          The\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BODY_SENSORS_BACKGROUND") + " permission allows your app to access data from sensors that the user uses to measure what\n          is happening inside their body, such as heart rate.\n          The permission is a \"hard-restricted\" permission that cannot be held by an app until\n          the device's installer allowlists the permission for your app.\n          The access model for background body sensor information introduced in\n          Android 13 (API level 33) is similar to the one introduced for\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("location in Android 10 (API level 29)", "https://developer.android.com/about/versions/10/privacy/changes#app-access-device-location") + ".\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          For more information, read about the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BODY_SENSORS_BACKGROUND"), "https://developer.android.com/reference/android/Manifest.permission#BODY_SENSORS_BACKGROUND") + " permission and\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("restricted permissions", "https://android.googlesource.com/platform/frameworks/base/+/master/core/java/android/permission/Permissions.md#restricted-permissions") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$4(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          On the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("battery usage page within system settings", "https://support.google.com/pixelphone/answer/7015477") + ", a user can choose from the following options:\n          " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Unrestricted") + ": Allow all background work,\n              which might consume more battery.\n            "))) + "\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Optimized (default)") + ": Optimize an app's ability to perform background\n              work, based on how the user interacts with the app.\n            "))) + "\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Restricted") + ": Fully prevents an app from running in the background.\n              Apps might not work as expected.\n            "))) + "\n          "))) + "\n          If a user places your app in the \"restricted\" state for background battery usage\n          while your app targets Android 13 (API level 33),\n          the system doesn't deliver the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BOOT_COMPLETED") + " broadcast\n          or the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("LOCKED_BOOT_COMPLETED") + " broadcast until\n          the app is started for other reasons.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          For more information, read about\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("user-initiated restrictions", "https://developer.android.com/topic/performance/background-optimization#bg-restrict") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$5(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          In Android 12L (API level 32) and lower, the system displays up to five actions from the\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("MediaStyle") + " notification in the order in which they were\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("added", "https://developer.android.com/reference/android/app/Notification.Builder#addAction(android.app.Notification.Action)") + ". In compact mode\u2014for example,\n          in the collapsed quick settings\u2014up to three actions specified with\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setShowActionsInCompactView()"), "https://developer.android.com/reference/androidx/media/app/NotificationCompat.MediaStyle#setShowActionsInCompactView(int...)") + " are shown.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          In Android 13 (API level 33), the system derives media controls from\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("PlaybackState"), "https://developer.android.com/reference/android/media/session/PlaybackState") + " actions, and displays up to five action buttons based on the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("PlaybackState") + ".\n          In compact mode, only the first three action slots are displayed.\n          Custom actions are placed in the order in which they were added to the\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("PlaybackState") + ".\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          For which action buttons the system displays based on the\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("PlaybackState") + ", see the table in the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("user experience page", "https://developer.android.com/about/versions/13/behavior-changes-13#playback-controls") + ". For example, the first slot has the following action buttons.\n          <table>\n            <tr>\n              <th align=\"left\" valign=\"top\">Slot</th>\n              <th align=\"left\" valign=\"top\">Action</th>\n              <th align=\"left\" valign=\"top\">Criteria</th>\n            </tr>\n            <tr>\n              <td align=\"left\" rowspan=\"3\" valign=\"top\">1</td>\n              <td align=\"left\" valign=\"top\">Play</td>\n              <td align=\"left\" valign=\"top\">\n                Current\n                " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("state", "https://developer.android.com/reference/android/media/session/PlaybackState#getState()") + " of the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("PlaybackState") + " is one of the following:\n                " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                  " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("STATE_NONE")) + "\n                  " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("STATE_STOPPED")) + "\n                  " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("STATE_PAUSED")) + "\n                  " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("STATE_ERROR")) + "\n                "))) + "\n              </td>\n            </tr>\n            <tr>\n              <td align=\"left\" valign=\"top\">Loading spinner</td>\n              <td align=\"left\" valign=\"top\">\n                Current\n                " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("state", "https://developer.android.com/reference/android/media/session/PlaybackState#getState()") + " of the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("PlaybackState") + " is one of the following:\n                " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                  " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("STATE_CONNECTING")) + "\n                  " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("STATE_BUFFERING")) + "\n                "))) + "\n              </td>\n            </tr>\n            <tr>\n              <td align=\"left\" valign=\"top\">Pause</td>\n              <td align=\"left\" valign=\"top\">\n                Current\n                " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("state", "https://developer.android.com/reference/android/media/session/PlaybackState#getState()") + " of the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("PlaybackState") + " is none of the above.\n              </td>\n            </tr>\n          </table>\n          For more information, read about\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("media controls derived from " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("PlaybackState"), "https://developer.android.com/about/versions/13/behavior-changes-13#playback-controls") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$6(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          You can no longer use the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setForceDark()"), "https://developer.android.com/reference/android/webkit/WebSettings#setForceDark(int)") + " method. Calling the method results in a no-op.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          Instead, WebView sets the media query\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("prefers-color-scheme") + " according to the app's theme attribute,\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("isLightTheme"), "https://developer.android.com/reference/android/R.styleable#Theme_isLightTheme") + ". In other words, if\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("isLightTheme") + " is\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("true") + " or not specified,\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("prefers-color-scheme") + " is\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("light") + "; otherwise, it is\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("dark") + ". This behavior means that the web content's light or dark style is applied\n          automatically to match the app's theme if the content supports it.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          For most apps, the new behavior should apply the appropriate app styles automatically,\n          however you should test your app to check for any cases where you might be manually\n          controlling dark mode settings.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          If you still need to customize your app's color theme behavior, use the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setAlgorithmicDarkeningAllowed()"), "https://developer.android.com/reference/android/webkit/WebSettings#setAlgorithmicDarkeningAllowed(boolean)") + " method instead. For backward compatibility with previous Android versions,\n          we recommend using the equivalent\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setAlgorithmicDarkeningAllowed()"), "https://developer.android.com/reference/androidx/webkit/WebSettingsCompat#setAlgorithmicDarkeningAllowed(android.webkit.WebSettings,%20boolean)") + " method in AndroidX. See the documentation for the methods to learn more about\n          what behavior you can expect in your app depending on your app's\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("targetSdkVersion") + " and theme settings.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          For more information, read about\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("darkening web content in WebView", "https://developer.android.com/develop/ui/views/layout/webapps/dark-theme") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$7(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          If your app uses the Google Play services\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("advertising ID", "https://support.google.com/googleplay/android-developer/answer/6048248") + ", you must declare the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("AD_ID"), "https://developers.google.com/android/reference/com/google/android/gms/ads/identifier/AdvertisingIdClient.Info#public-string-getid") + " normal permission in the app's manifest file, as follows:\n        ")));
        $this$raw.xml("<manifest ...>\n    <!-- Required only if your app targets Android 13 or higher. -->\n    <uses-permission android:name=\"com.google.android.gms.permission.AD_ID\"/>\n\n    <application ...>\n        ...\n    </application>\n</manifest>");
        $this$raw.text(StringsKt.trimIndent((String)("\n          If your app does not declare this permission,\n          the advertising ID is automatically removed and replaced with a string of zeros.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          If your app uses SDKs that declare the\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("AD_ID") + "\n          permission in the library's manifest,\n          then the permission is merged with your app's manifest file by default.\n          In this case, you don't need to declare the permission in your app's manifest file.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          For more information, read about the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("advertising ID", "https://support.google.com/googleplay/android-developer/answer/6048248") + " in the Play Console Help.\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$8(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          Apps are not recommended to use non-SDK interfaces,\n          because some non-SDK interfaces are blocked in Android 13.\n          If you are unsure if your app uses non-SDK interfaces, you can\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("test your app", "https://developer.android.com/guide/app-compatibility/restrictions-non-sdk-interfaces#test-for-non-sdk") + " to find out.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          For more information, read about\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("updates to non-SDK interface restrictions in Android 13", "https://developer.android.com/about/versions/13/changes/non-sdk-13") + ". For a comprehensive list of blocked non-SDK interfaces, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Non-SDK interfaces that are now blocked in Android 13", "https://developer.android.com/about/versions/13/changes/non-sdk-13#new-blocked") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$9(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n            Exact alarms are meant for user-intentioned notifications or actions that need to happen at a precise time.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("SCHEDULE_EXACT_ALARM"), "https://developer.android.com/reference/android/Manifest.permission#SCHEDULE_EXACT_ALARM") + ", the permission introduced in Android 12 for apps to schedule exact alarms,\n            is " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("no longer being pre-granted to most newly installed apps targeting Android 13 and higher") + "\n            (will be set to denied by default).\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            The " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("SCHEDULE_EXACT_ALARM") + " permission is required to initiate exact alarms\n            via the following APIs or a " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("SecurityException") + " will be thrown.\n            " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("setExact()", "https://developer.android.com/reference/android/app/AlarmManager#setExact(int,%20long,%20android.app.PendingIntent)")) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("setExactAndAllowWhileIdle()", "https://developer.android.com/reference/android/app/AlarmManager#setExactAndAllowWhileIdle(int,%20long,%20android.app.PendingIntent)")) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("setAlarmClock()", "https://developer.android.com/reference/android/app/AlarmManager#setAlarmClock(android.app.AlarmManager.AlarmClockInfo,%20android.app.PendingIntent)")) + "\n            "))) + "\n\n\n            " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Affected apps") + "\n            If a device is running Android 14 (API level 34) or higher,\n            this change will affect a newly installed app that has the following characteristics:\n            " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("Targets Android 13 (API level 33) or higher") + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("Declares the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("SCHEDULE_EXACT_ALARM") + " permission in the manifest") + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("Doesn't fall under an exemption or pre-grant scenario") + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("Isn't") + " a calendar or alarm clock app") + "\n            "))) + "\n\n\n            " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Use cases that might not require exact alarms") + "\n            Because the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("SCHEDULE_EXACT_ALARM") + " permission is now denied by default and\n            the permission grant process requires extra steps from users,\n            developers are strongly encouraged to evaluate their use cases and\n            determine if exact alarms still make sense for their use cases.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            The following list shows common workflows that may not require an exact alarm:\n              " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(3, "Scheduling repeated work during the lifetime of your app") + "\n              The " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("set()"), "https://developer.android.com/reference/android/app/AlarmManager#set(int,%20long,%20android.app.PendingIntent)") + " method is useful if the task needs to keep real-time constraints in mind,\n              such as going off at 2:00 PM tomorrow or in 30 minutes.\n              Otherwise, it's recommended to use the " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("postAtTime()"), "https://developer.android.com/reference/android/os/Handler#postAtTime(java.lang.Runnable,%20long)") + " or " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("postDelayed()"), "https://developer.android.com/reference/android/os/Handler#postDelayed(java.lang.Runnable,%20long)") + " methods instead.\n\n              " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(3, "Scheduled background work, such as updating your app and uploading logs") + "\n              " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("WorkManager") + " provides a way to " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("schedule timing-sensitive periodic work", "https://developer.android.com/topic/libraries/architecture/workmanager/how-to/define-work#flexible_run_intervals") + ". You can provide a repeat interval and flexInterval (15 minutes minimum) to define granular runtime for the work.\n\n              " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(3, "Need alarm to go off at an approximate time while system is in idle state") + "\n              Use an inexact alarm. Specifically, call " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setAndAllowWhileIdle()"), "https://developer.android.com/reference/android/app/AlarmManager#setAndAllowWhileIdle(int,%20long,%20android.app.PendingIntent)") + ".\n\n              " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(3, "User-specified action that should happen after a specific time") + "\n              Use an inexact alarm. Specifically, call " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("set()"), "https://developer.android.com/reference/android/app/AlarmManager#set(int,%20long,%20android.app.PendingIntent)") + ".\n\n              " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(3, "User-specified action that can happen within a time window") + "\n              Use an inexact alarm. Specifically, call " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setWindow()"), "https://developer.android.com/reference/android/app/AlarmManager#setWindow(int,%20long,%20long,%20android.app.PendingIntent)") + ". Note that the smallest allowed window length is 10 minutes.\n\n\n            " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Migration steps to continue using exact alarms") + "\n            At a minimum, apps must check to see if they have the permission before scheduling exact alarms.\n            If apps don't have the permission, they must request it from the user by invoking an intent.\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            This is the same as the standard workflow for " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("requesting a special permission", "https://developer.android.com/training/permissions/requesting-special") + ":\n            " + ApiUtils.INSTANCE.olist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                Apps should call " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("AlarmManager.canScheduleExactAlarms()"), "https://developer.android.com/reference/android/app/AlarmManager#canScheduleExactAlarms()") + " to confirm that it has the appropriate permission.\n                "))) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                If the app doesn't have the permission, invoke an intent that includes the " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ACTION_REQUEST_SCHEDULE_EXACT_ALARM"), "https://developer.android.com/reference/android/provider/Settings#ACTION_REQUEST_SCHEDULE_EXACT_ALARM") + ", along with the app's package name, to ask users to grant the permission.\n                " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n                " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Check the user's decision", "https://developer.android.com/reference/android/app/AlarmManager#set(int,%20long,%20android.app.PendingIntent)") + " in the " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("onResume()"), "https://developer.android.com/guide/components/activities/activity-lifecycle#onresume") + " method of your app.\n                 "))) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                Listen for the " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("AlarmManager.ACTION_SCHEDULE_EXACT_ALARM_PERMISSION_STATE_CHANGED"), "https://developer.android.com/reference/android/app/AlarmManager#ACTION_SCHEDULE_EXACT_ALARM_PERMISSION_STATE_CHANGED") + " broadcasts that are sent if the user grants the permission.\n                "))) + "\n              " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                If the user granted the permission to your app, your app can set exact alarms.\n                If the user denied the permission instead, " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("gracefully degrade your app experience", "https://developer.android.com/about/versions/14/changes/schedule-exact-alarms#gracefully-degrade") + " so that it provides functionality to the user without the information that's protected by that permission.\n                "))) + "\n            "))) + "\n            The following code snippet demonstrates how to check for the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("SCHEDULE_EXACT_ALARM") + " permission:\n            ")));
        $this$raw.kotlin("val alarmManager: AlarmManager = context.getSystemService<AlarmManager>()!!\nwhen {\n   // If permission is granted, proceed with scheduling exact alarms.\n   alarmManager.canScheduleExactAlarms() -> {\n       alarmManager.setExact(...)\n   }\n   else -> {\n       // Ask users to go to exact alarm page in system settings.\n       startActivity(Intent(ACTION_REQUEST_SCHEDULE_EXACT_ALARM))\n   }\n}");
        $this$raw.text("Sample code to check the permission and handle the user's decisions in " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("onResume()") + ":");
        $this$raw.kotlin("override fun onResume() {\n    \u2026\n    if (alarmManager.canScheduleExactAlarms()) {\n        // Set exact alarms.\n        alarmManager.setExact(...)\n    }\n    else {\n        // Permission not yet approved. Display user notice and revert to a fallback\n        // approach.\n        alarmManager.setWindow(...)\n    }\n}");
        $this$raw.text(StringsKt.trimIndent((String)("\n            For more information, see " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Schedule exact alarms are denied by default", "https://developer.android.com/about/versions/14/changes/schedule-exact-alarms") + ".\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10(Par $this$par) {
        Intrinsics.checkNotNullParameter((Object)$this$par, (String)"$this$par");
        $this$par.raw("Permission for notifications", (Function1<? super ElementListBuilder, Unit>)((Function1)Api33::steps$lambda$13$lambda$10$lambda$0));
        $this$par.filtered("Permission for nearby Wi-Fi devices", "wifiInsteadOfLocations", (Function1<? super ElementListBuilder, Unit>)((Function1)Api33::steps$lambda$13$lambda$10$lambda$1));
        $this$par.filtered("Granular media permissions", "externalMediaRequest", (Function1<? super ElementListBuilder, Unit>)((Function1)Api33::steps$lambda$13$lambda$10$lambda$2));
        $this$par.filtered("Permission for body sensors in the background", "bodySensorsWithoutBackground", (Function1<? super ElementListBuilder, Unit>)((Function1)Api33::steps$lambda$13$lambda$10$lambda$3));
        $this$par.raw("Battery resource utilization", (Function1<? super ElementListBuilder, Unit>)((Function1)Api33::steps$lambda$13$lambda$10$lambda$4));
        $this$par.filtered("Media controls derived from PlaybackState", "mediaControlFromPlaybackState", (Function1<? super ElementListBuilder, Unit>)((Function1)Api33::steps$lambda$13$lambda$10$lambda$5));
        $this$par.filtered("Automatic WebView content theming", "manualDarkThemeSetting", (Function1<? super ElementListBuilder, Unit>)((Function1)Api33::steps$lambda$13$lambda$10$lambda$6));
        $this$par.raw("Permission for advertising ID", (Function1<? super ElementListBuilder, Unit>)((Function1)Api33::steps$lambda$13$lambda$10$lambda$7));
        $this$par.raw("Non-SDK restrictions", (Function1<? super ElementListBuilder, Unit>)((Function1)Api33::steps$lambda$13$lambda$10$lambda$8));
        $this$par.raw("Schedule exact alarms are denied by default", (Function1<? super ElementListBuilder, Unit>)((Function1)Api33::steps$lambda$13$lambda$10$lambda$9));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$11(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n        Make sure to review the\n        " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("complete set of changes", "https://developer.android.com/about/versions/13/behavior-changes-13") + ".\n      ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$12(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n        Once you've finished migrating your code, update " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("targetSdkVersion") + " to 33.\n      ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.par((Function1<? super Par, Unit>)((Function1)Api33::steps$lambda$13$lambda$10));
        $this$seq.raw("Remember to check for other changes", (Function1<? super ElementListBuilder, Unit>)((Function1)Api33::steps$lambda$13$lambda$11));
        $this$seq.filtered("Update the SDK version", "targetSdkVersion33", (Function1<? super ElementListBuilder, Unit>)((Function1)Api33::steps$lambda$13$lambda$12));
        return Unit.INSTANCE;
    }
}

