/*
 * Decompiled with CFR 0.152.
 */
package com.google.targetsdkversionassistant.plan;

import com.google.targetsdkversionassistant.dsl.ElementListBuilder;
import com.google.targetsdkversionassistant.dsl.Ordering;
import com.google.targetsdkversionassistant.dsl.Par;
import com.google.targetsdkversionassistant.dsl.Seq;
import com.google.targetsdkversionassistant.plan.ApiUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/google/targetsdkversionassistant/plan/Api31;", "", "<init>", "()V", "label", "", "getLabel", "()Ljava/lang/String;", "description", "getDescription", "steps", "Lcom/google/targetsdkversionassistant/dsl/Seq;", "getSteps", "()Lcom/google/targetsdkversionassistant/dsl/Seq;", "targetsdkversion-upgrade-assistant"})
public final class Api31 {
    @NotNull
    public static final Api31 INSTANCE = new Api31();
    @NotNull
    private static final String label = ApiUtils.INSTANCE.rarrow$targetsdkversion_upgrade_assistant("Android 11 / API level 30", "Android 12 / API level 31");
    @NotNull
    private static final String description = StringsKt.trimIndent((String)("\n    Here are the major steps required to migrate from Android 11 (API level 30) to Android 12 (API level 31).\n    " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n    View the complete set of\n    " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("changes that affect apps targeting Android 12 (API level 31)", "https://developer.android.com/about/versions/12/behavior-changes-12") + ".\n  "));
    @NotNull
    private static final Seq steps = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api31::steps$lambda$12));

    private Api31() {
    }

    @NotNull
    public final String getLabel() {
        return label;
    }

    @NotNull
    public final String getDescription() {
        return description;
    }

    @NotNull
    public final Seq getSteps() {
        return steps;
    }

    private static final Unit steps$lambda$12$lambda$9$lambda$0(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          You must replace declarations for the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BLUETOOTH"), "https://developer.android.com/reference/android/Manifest.permission#BLUETOOTH") + " and\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BLUETOOTH_ADMIN"), "https://developer.android.com/reference/android/Manifest.permission#BLUETOOTH_ADMIN") + " permissions with\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BLUETOOTH_SCAN"), "https://developer.android.com/reference/android/Manifest.permission#BLUETOOTH_SCAN") + ",\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BLUETOOTH_ADVERTISE"), "https://developer.android.com/reference/android/Manifest.permission#BLUETOOTH_ADVERTISE") + ", or\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BLUETOOTH_CONNECT"), "https://developer.android.com/reference/android/Manifest.permission#BLUETOOTH_CONNECT") + " permissions. You no longer need to make " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("LOCATION") + " runtime permission requests for Bluetooth operations.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          Declare the permissions needed in your app's manifest file (" + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("AndroidManifest.xml") + ") as follows:\n        ")));
        $this$filtered.text(ApiUtils.INSTANCE.olist$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("If your app looks for Bluetooth devices, declare the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BLUETOOTH_SCAN") + " permission as shown in the code snippet below.")));
        $this$filtered.xml("<manifest>\n...\n<uses-permission android:name=\"android.permission.BLUETOOTH_SCAN\"/>\n...\n</manifest>");
        $this$filtered.text(ApiUtils.INSTANCE.olist$targetsdkversion_upgrade_assistant(2, ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("If your app makes the current device discoverable to other Bluetooth devices, declare the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BLUETOOTH_ADVERTISE") + " permission.")));
        $this$filtered.text(ApiUtils.INSTANCE.olist$targetsdkversion_upgrade_assistant(3, ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("If your app communicates with already-paired Bluetooth devices, declare the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BLUETOOTH_CONNECT") + " permission.")));
        $this$filtered.text(ApiUtils.INSTANCE.olist$targetsdkversion_upgrade_assistant(4, ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n          For your legacy Bluetooth-related permission declarations,\n          set " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("android:maxSdkVersion") + " to 30 as shown in the code snippet below.\n          This app compatibility step helps the system grant your app only the Bluetooth permissions\n          that it needs when installed on devices that run Android 12 or higher.\n          ")))));
        $this$filtered.xml("<manifest>\n...\n<uses-permission android:name=\"android.permission.BLUETOOTH\"\n            android:maxSdkVersion=\"30\"/>\n...\n</manifest>");
        $this$filtered.text(ApiUtils.INSTANCE.olist$targetsdkversion_upgrade_assistant(5, ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n          If your app uses Bluetooth scan results to derive physical location, declare the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ACCESS_FINE_LOCATION"), "https://developer.android.com/reference/android/Manifest.permission#ACCESS_FINE_LOCATION") + " permission. Otherwise, you can\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("strongly assert that your app doesn't derive physical location", "https://developer.android.com/guide/topics/connectivity/bluetooth/permissions#assert-never-for-location") + ".\n          ")))));
        $this$filtered.text(StringsKt.trimIndent((String)("\n          For more information, read about\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Bluetooth permissions for Android 12 or higher", "https://developer.android.com/guide/topics/connectivity/bluetooth/permissions#declare-android12-or-higher") + ".\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$12$lambda$9$lambda$1(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n         Users can request that your app retrieve only approximate location information.\n         In your app\u2019s manifest file, you must request the\n         " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("ACCESS_COARSE_LOCATION", "https://developer.android.com/reference/android/Manifest.permission#ACCESS_COARSE_LOCATION") + " permission any time you request\n         " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("ACCESS_FINE_LOCATION", "https://developer.android.com/reference/android/Manifest.permission#ACCESS_FINE_LOCATION") + ", as shown in the code snippet below.\n         ")));
        $this$filtered.xml("<manifest>\n...\n<uses-permission android:name=\"android.permission.ACCESS_FINE_LOCATION\" />\n<uses-permission android:name=\"android.permission.ACCESS_COARSE_LOCATION\" />\n...\n</manifest>");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          For more information, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("User can grant only approximate location", "https://developer.android.com/training/location/permissions#approximate-request") + ".\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$12$lambda$9$lambda$2(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          If your app contains activities, services, or broadcast receivers that use intent filters, you must explicitly declare the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("android:exported"), "https://developer.android.com/guide/topics/manifest/activity-element#exported") + " attribute for these components in your app\u2019s manifest file. If you set it to " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("true") + ", the activity is accessible\n          and launchable by other apps.\n          If you set it to " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("false") + ", the activity is accessible and launchable only by your own app.\n          Here\u2019s an example from the manifest file of a social-sharing app:\n        ")));
        $this$filtered.xml("<activity android:name=\"MainActivity\" android:exported=\"true\">\n    <!-- This activity is the main entry, should appear in app launcher -->\n    <intent-filter>\n        <action android:name=\"android.intent.action.MAIN\" />\n        <category android:name=\"android.intent.category.LAUNCHER\" />\n    </intent-filter>\n</activity>\n\n<activity android:name=\"ShareActivity\" android:exported=\"false\">\n    <!-- This activity handles \"SEND\" actions with text data -->\n    <intent-filter>\n        <action android:name=\"android.intent.action.SEND\"/>\n        <category android:name=\"android.intent.category.DEFAULT\"/>\n        <data android:mimeType=\"text/plain\"/>\n    </intent-filter>\n</activity>");
        $this$filtered.text(StringsKt.trimIndent((String)("\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            For more information, see\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Receiving an implicit intent", "https://developer.android.com/guide/components/intents-filters#Receiving") + ".\n            ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$12$lambda$9$lambda$3(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n         Apps may be put into hibernation mode if they are not used over a period of time.\n         In hibernation mode your app's runtime permissions and cache are reset, and you can't run jobs or alerts.\n         You can check your\n         " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("app\u2019s hibernation status", "https://developer.android.com/topic/performance/app-hibernation") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$12$lambda$9$lambda$4(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n         If your app creates a " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("PendingIntent") + " object, you must declare that it is mutable or immutable by using\n         the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("PendingIntent.FLAG_MUTABLE") + " or " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("PendingIntent.FLAG_IMMUTABLE") + " flag, respectively.\n         In most cases, your app should create immutable " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("PendingIntent") + " objects, as shown in the following code snippet:\n         " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n        ")));
        $this$filtered.kotlin("val pendingIntent = PendingIntent.getActivity(applicationContext,\n     <REQUEST_CODE>, intent,\n     /* flags */ PendingIntent.FLAG_IMMUTABLE)");
        $this$filtered.text(StringsKt.trimIndent((String)("\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            For more information, see\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Specify mutability", "https://developer.android.com/guide/components/intents-filters#DeclareMutabilityPendingIntent") + ".\n            ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$12$lambda$9$lambda$5(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          Notifications with custom content views will no longer use the full notification area; instead, the system applies a standard template.\n          This template ensures that custom notifications have the same decoration as other notifications in all states.\n          This behavior is nearly identical to the behavior of " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("Notification.DecoratedCustomViewStyle") + ".\n          For more information, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Custom notifications", "https://developer.android.com/about/versions/12/behavior-changes-12#custom-notifications") + ".\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          You should verify that your notifications render correctly with " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("targetSdkVersion") + " 31 and if not, make adjustments as necessary.\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$12$lambda$9$lambda$6(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          If you rely on Android App Link verification to open web links in your app,\n          make sure that your intent filters include the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("BROWSABLE") + " category and\n          support the " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("https") + " scheme. Your intent filters should match the following format:\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n        ")));
        $this$filtered.xml("<!-- Make sure you explicitly set android:autoVerify to \"true\". -->\n<intent-filter android:autoVerify=\"true\">\n    <action android:name=\"android.intent.action.VIEW\" />\n    <category android:name=\"android.intent.category.DEFAULT\" />\n    <category android:name=\"android.intent.category.BROWSABLE\" />\n\n    <!-- If a user clicks on a shared link that uses the \"http\" scheme, your\n         app should be able to delegate that traffic to \"https\". -->\n    <data android:scheme=\"http\" />\n    <data android:scheme=\"https\" />\n\n    <!-- Include one or more domains that should be verified. -->\n    <data android:host=\"...\" />\n</intent-filter>");
        $this$filtered.text(StringsKt.trimIndent((String)("\n            " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n            For more information, see\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Add intent filters for app links verification", "https://developer.android.com/training/app-links/verify-android-applinks") + ".\n            ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$12$lambda$9$lambda$7(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          Apps that target Android 12 (API level 31) or higher can't start foreground services while running in the background,\n          except for\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("a few special cases", "https://developer.android.com/guide/components/foreground-services#background-start-restriction-exemptions") + ". To check whether your app performs background starts, you can enable notifications that appear each time this behavior occurs.\n          To do so, execute the following adb command on the development machine connected to your test device emulator:\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n        ")));
        $this$raw.shell("adb shell device_config put activity_manager \\\n  default_fgs_starts_restriction_notification_enabled true");
        $this$raw.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          If you discover that your app starts foreground services while running from the background,\n          update your app's logic to use\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("WorkManager", "https://developer.android.com/topic/libraries/architecture/workmanager") + ". To view an example of how to update your app, look through the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("WorkManagerSample", "https://github.com/android/architecture-components-samples/tree/android-s/WorkManagerSample") + " on GitHub.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          For more information, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Restrictions on background starts", "https://developer.android.com/guide/components/foreground-services#background-start-restrictions") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$12$lambda$9$lambda$8(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          Your app can't start activities from\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("services", "https://developer.android.com/guide/components/services") + " or\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("broadcast receivers", "https://developer.android.com/guide/components/broadcasts") + " that are used as\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("notification trampolines", "https://developer.android.com/about/versions/12/behavior-changes-12#notification-trampolines") + ". In other words, after the user taps on a notification, or an action button within the notification,\n          your app cannot call " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("startActivity()") + " inside of a service or broadcast receiver.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          To identify which service or broadcast receiver acts as a notification trampoline in your app,\n          look at the output of the following terminal command:\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n        ")));
        $this$raw.shell("adb shell dumpsys activity service \\\n  com.android.systemui/.dump.SystemUIAuxiliaryDumpService");
        $this$raw.text(StringsKt.trimIndent((String)("\n         " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n         A section of the output includes the text \"NotifInteractionLog\".\n         This section contains the information that's necessary to identify the component that starts as the result of a notification tap.\n         " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n         If your app starts an activity from a service or broadcast receiver that acts as a notification trampoline,\n         complete the following migration steps:\n        ")));
        $this$raw.text(ApiUtils.INSTANCE.olist$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n            Create a\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("PendingIntent", "https://developer.android.com/reference/android/app/PendingIntent") + " object that is associated with the activity that users see after they tap on the notification.\n            "))) + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n            Use the PendingIntent object that you created in the previous step as part of\n            " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("building your notification", "https://developer.android.com/reference/android/app/Notification.Builder#setContentIntent(android.app.PendingIntent)") + ".\n            ")))));
        $this$raw.text(StringsKt.trimIndent((String)("\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          To identify the origin of the activity, in order to perform logging for example,use extras when posting the notification.\n          For centralized logging, use\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("ActivityLifecycleCallbacks", "https://developer.android.com/reference/android/app/Application.ActivityLifecycleCallbacks") + " or\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Jetpack lifecycle observers", "https://developer.android.com/topic/libraries/architecture/lifecycle") + ".\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          For more information, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Notification trampoline restrictions", "https://developer.android.com/about/versions/12/behavior-changes-12#notification-trampolines") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$12$lambda$9(Par $this$par) {
        Intrinsics.checkNotNullParameter((Object)$this$par, (String)"$this$par");
        $this$par.filtered("Bluetooth", "legacyBluetooth", (Function1<? super ElementListBuilder, Unit>)((Function1)Api31::steps$lambda$12$lambda$9$lambda$0));
        $this$par.filtered("Location", "fineLocationWithoutCoarse", (Function1<? super ElementListBuilder, Unit>)((Function1)Api31::steps$lambda$12$lambda$9$lambda$1));
        $this$par.filtered("Intent filters", "intentFilterMissing", (Function1<? super ElementListBuilder, Unit>)((Function1)Api31::steps$lambda$12$lambda$9$lambda$2));
        $this$par.raw("Hibernation", (Function1<? super ElementListBuilder, Unit>)((Function1)Api31::steps$lambda$12$lambda$9$lambda$3));
        $this$par.filtered("Pending intent mutability", "pendingIntentMutability", (Function1<? super ElementListBuilder, Unit>)((Function1)Api31::steps$lambda$12$lambda$9$lambda$4));
        $this$par.filtered("Custom notifications", "customNotifications", (Function1<? super ElementListBuilder, Unit>)((Function1)Api31::steps$lambda$12$lambda$9$lambda$5));
        $this$par.filtered("Android App Links verification changes", "appLinkVerification", (Function1<? super ElementListBuilder, Unit>)((Function1)Api31::steps$lambda$12$lambda$9$lambda$6));
        $this$par.raw("Foreground service launch restrictions", (Function1<? super ElementListBuilder, Unit>)((Function1)Api31::steps$lambda$12$lambda$9$lambda$7));
        $this$par.raw("Notification trampoline restrictions", (Function1<? super ElementListBuilder, Unit>)((Function1)Api31::steps$lambda$12$lambda$9$lambda$8));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$12$lambda$10(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          Make sure to review the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("complete set of changes", "https://developer.android.com/about/versions/12/behavior-changes-12") + ".\n          ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$12$lambda$11(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n        Once you've finished migrating your code, update " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("targetSdkVersion") + " to 31.\n      ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$12(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.par((Function1<? super Par, Unit>)((Function1)Api31::steps$lambda$12$lambda$9));
        $this$seq.raw("Remember to check for other changes", (Function1<? super ElementListBuilder, Unit>)((Function1)Api31::steps$lambda$12$lambda$10));
        $this$seq.filtered("Update the SDK version", "targetSdkVersion31", (Function1<? super ElementListBuilder, Unit>)((Function1)Api31::steps$lambda$12$lambda$11));
        return Unit.INSTANCE;
    }
}

