/*
 * Decompiled with CFR 0.152.
 */
package com.google.targetsdkversionassistant.plan;

import com.google.targetsdkversionassistant.dsl.ElementListBuilder;
import com.google.targetsdkversionassistant.dsl.Ordering;
import com.google.targetsdkversionassistant.dsl.Par;
import com.google.targetsdkversionassistant.dsl.Seq;
import com.google.targetsdkversionassistant.plan.Api29Kt;
import com.google.targetsdkversionassistant.plan.ApiUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/google/targetsdkversionassistant/plan/Api29;", "", "<init>", "()V", "label", "", "getLabel", "()Ljava/lang/String;", "description", "getDescription", "steps", "Lcom/google/targetsdkversionassistant/dsl/Seq;", "getSteps", "()Lcom/google/targetsdkversionassistant/dsl/Seq;", "targetsdkversion-upgrade-assistant"})
public final class Api29 {
    @NotNull
    public static final Api29 INSTANCE = new Api29();
    @NotNull
    private static final String label = ApiUtils.INSTANCE.rarrow$targetsdkversion_upgrade_assistant("Android 9 / API level 28", "Android 10 / API level 29");
    @NotNull
    private static final String description = StringsKt.trimIndent((String)("\n    Here are the major steps required to migrate from Android 9 (API level 28) to Android 10 (API level 29).\n    " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n    View the complete set of\n    " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("changes that affect apps targeting Android 10 (API level 29)", "https://developer.android.com/about/versions/10/behavior-changes-10") + ".\n  "));
    @NotNull
    private static final Seq steps = Ordering.Companion.seq((Function1<? super Seq, Unit>)((Function1)Api29::steps$lambda$13));

    private Api29() {
    }

    @NotNull
    public final String getLabel() {
        return label;
    }

    @NotNull
    public final String getDescription() {
        return description;
    }

    @NotNull
    public final Seq getSteps() {
        return steps;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$0(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n         If your app displays a notification with a full-screen intent,\n         for example for an incoming phone call or a ringing alarm,\n         you must request the\n         " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("USE_FULL_SCREEN_INTENT", "https://developer.android.com/reference/android/Manifest.permission#USE_FULL_SCREEN_INTENT") + " permission in your app\u2019s manifest file in order for the notification to work.\n         You probably need to request this permission if you use the\n         " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("setFullScreenIntent"), "https://developer.android.com/reference/android/app/Notification.Builder#setFullScreenIntent(android.app.PendingIntent,%20boolean)") + " method in your code.\n         The following code snippet shows how to request the full-screen permission\n         in your app\u2019s manifest file:\n        ")));
        $this$filtered.xml("<manifest>\n...\n<uses-permission android:name=\"android.permission.USE_FULL_SCREEN_INTENT\" />\n...\n</manifest>");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          For more information, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Show an urgent message", "https://developer.android.com/develop/ui/views/notifications/build-notification#urgent-message") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$1(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          When an app runs on Android 10, the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("onResume()"), "https://developer.android.com/reference/android/app/Activity#onResume()") + " and\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("onPause()"), "https://developer.android.com/reference/android/app/Activity#onPause()") + " methods work differently in order to support foldables and large screen devices.\n          When multiple apps appear at the same time in multi-window or multi-display mode,\n          all the focusable top activities in visible stacks are in the resumed state,\n          but only one of them, the \"topmost resumed\" activity, can actually have focus.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          To get notified when your activity acquires or loses the topmost resumed position,\n          subscribe to the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("onTopResumedActivityChanged()"), "https://developer.android.com/reference/android/app/Activity#onTopResumedActivityChanged(boolean)") + " callback. It\u2019s important to know if your activity gains or loses the topmost\n          resumed activity position when it uses a shared singleton resource,\n          such as the microphone or camera.\n          Your app should gracefully handle events and state changes that affect available resources.\n          The following code snippet shows how to use the\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("onTopResumedActivityChanged()") + " callback:\n        ")));
        $this$raw.kotlin("override fun onTopResumedActivityChanged(topResumed: Boolean) {\n    if (topResumed) {\n        // Top resumed activity\n        // Can be a signal to re-acquire exclusive resources\n    } else {\n        // No longer the top resumed activity\n    }\n}");
        $this$raw.text(StringsKt.trimIndent((String)("\n          For more information, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Multi-resume", "https://developer.android.com/guide/topics/large-screens/multi-window-support#multi-resume") + " and\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Exclusive resource access", "https://developer.android.com/guide/topics/large-screens/multi-window-support#exclusive_resource_access") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$2(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          The behavior of the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("resizeableActivity"), "https://developer.android.com/guide/topics/ui/multi-window#resizeableActivity") + " manifest attribute has changed to support foldables and large screen devices.\n          If an app sets " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("resizeableActivity=false") + " in Android 10 (API level 29)\n          or later,\n          it might be put in compatibility mode when the available screen size changes,\n          or if the app moves from one screen to another.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          When " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("resizeableActivity") + " is set to " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("false") + ", apps can use the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("android:minAspectRatio"), "https://developer.android.com/reference/android/R.attr#minAspectRatio") + " attribute to indicate the screen ratios that your app supports.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          For more information, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("resizeableActivity", "https://developer.android.com/guide/topics/manifest/activity-element#resizeableActivity") + " and\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Screen sizes and aspect ratios", "https://developer.android.com/guide/topics/large-screens/support-different-screen-sizes#screen_sizes_and_aspect_ratios") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$3(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          When you target Android 10 (API level 29), scoped storage is enabled by default.\n          With scoped storage, your app cannot access other apps\u2019 app-specific directories\n          within external storage. You must either ensure that your app works with scoped storage,\n          or temporarily opt out of scoped storage in both your tests and your production app.\n          " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Accommodate scoped storage") + "\n          " + Api29Kt.getScopedStorage() + "\n          " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Temporarily opt out of scoped storage in your tests") + "\n          On Android 10 (API level 29) and higher,\n          your app's tests run in a storage sandbox by default.\n          This sandbox prevents your app from accessing files outside of\n          the app-specific directory and publicly-shared directories.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          If a test outputs files for the host\u2014such as screenshots,debugging data, coverage data,\n          or performance metrics\u2014you can write these files to global directories.\n          To do so, add the following flag to the relevant harness that invokes am instrument:\n        ")));
        $this$raw.shell("-e no-isolated-storage 1");
        $this$raw.text(StringsKt.trimIndent((String)("\n          Alternatively, you can write to app-scoped storage that's readable by the shell.\n          You can then pull that app-scoped directory.\n          To determine which directory to pull from, call\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("getExternalMediaDirs()", "https://developer.android.com/reference/android/content/Context#getExternalMediaDirs()") + ".\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          For more information, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Opt out in your tests", "https://developer.android.com/training/data-storage/use-cases#opt-out-in-tests") + ".\n          " + ApiUtils.INSTANCE.heading$targetsdkversion_upgrade_assistant(2, "Temporarily opt out of scoped storage in your production app") + "\n          To temporarily opt out of scoped storage in your production app,\n          set the value of " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("requestLegacyExternalStorage") + " to\n          " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("true") + " in your app's manifest file:\n        ")));
        $this$raw.xml("<manifest ... >\n  <!-- This attribute is \"false\" by default on apps targeting\n       Android 10. -->\n  <application android:requestLegacyExternalStorage=\"true\" ... >\n    ...\n  </application>\n</manifest>");
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$4(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          You must declare the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("ACCESS_BACKGROUND_LOCATION", "https://developer.android.com/reference/android/Manifest.permission#ACCESS_BACKGROUND_LOCATION") + " permission in your app's manifest in order to\n          request background location access at runtime.\n          An app is considered to be accessing location in the\n          background unless one of the following conditions is satisfied:\n          " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("An activity belonging to the app is visible.") + "\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              The app is running a foreground service that has declared a\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("foreground service type", "https://developer.android.com/guide/topics/manifest/service-element#foregroundservicetype") + " of location.\n            "))) + "\n          "))) + "\n          The following code snippet shows how to request background location permission:\n        ")));
        $this$raw.xml("<manifest ... >\n...\n  <uses-permission android:name=\"android.permission.ACCESS_BACKGROUND_LOCATION\" />\n...\n</manifest>");
        $this$raw.text(StringsKt.trimIndent((String)("\n          For more information, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Access to device location in the background requires permission", "https://developer.android.com/about/versions/10/privacy/changes#app-access-device-location") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$5(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          You must have the READ_PRIVILEGED_PHONE_STATE privileged permission in order to access\n          the device's non-resettable identifiers, which include both IMEI and serial number.\n          The READ_PRIVILEGED_PHONE_STATE permission is only granted to apps signed\n          with the platform key and privileged system apps.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          Affected methods include the following:\n          " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              Build\n              " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("getSerial()", "https://developer.android.com/reference/android/os/Build#getSerial()")) + "\n              "))) + "\n            "))) + "\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              TelephonyManager\n              " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("getImei()", "https://developer.android.com/reference/android/telephony/TelephonyManager#getImei(int)")) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("getDeviceId()", "https://developer.android.com/reference/android/telephony/TelephonyManager#getDeviceId(int)")) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("getMeid()", "https://developer.android.com/reference/android/telephony/TelephonyManager#getMeid(int)")) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("getSimSerialNumber()", "https://developer.android.com/reference/android/telephony/TelephonyManager#getSimSerialNumber()")) + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("getSubscriberId()", "https://developer.android.com/reference/android/telephony/TelephonyManager#getSubscriberId()")) + "\n              "))) + "\n            "))) + "\n          "))) + "\n          If your app doesn't have the permission and you try asking for information\n          about non-resettable identifiers anyway, a " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("SecurityException") + " occurs.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          Many use cases don't need non-resettable device identifiers.\n          For example, if your app uses non-resettable device identifiers\n          for ad-tracking or user analytics purposes,\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("use an Android Advertising ID", "https://developer.android.com/training/permissions/usage-notes#d_create_a_unique_identifier_for_advertising_or_user_analytics") + " for those specific use cases instead.\n          To learn more, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("best practices for unique identifiers", "https://developer.android.com/training/articles/user-data-ids") + ".\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          For more information, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Restriction on non-resettable device identifiers", "https://developer.android.com/about/versions/10/privacy/changes#non-resettable-device-ids") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$6(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          Apps that need to detect the user's step count or classify the user's physical activity,\n          such as walking, biking, or moving in a vehicle, must declare the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("android.permission.ACTIVITY_RECOGNITION", "https://developer.android.com/reference/android/Manifest.permission#ACTIVITY_RECOGNITION") + " runtime permission.\n          This is designed to give users visibility of how device sensor data is used in Settings.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          Some libraries within Google Play services, such as the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Activity Recognition API", "https://developers.google.com/location-context/activity-recognition/") + " and the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Google Fit API", "https://developers.google.com/fit/android/authorization#android_permissions") + ", don't provide results unless the user has granted your app this permission.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          The only\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("built-in sensors", "https://developer.android.com/guide/topics/sensors/sensors_overview") + " on the device that require you to declare this permission are the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("step counter", "https://developer.android.com/guide/topics/sensors/sensors_motion#sensors-motion-stepcounter") + " and\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("step detector", "https://developer.android.com/guide/topics/sensors/sensors_motion#sensors-motion-stepdetector") + " sensors.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          The following code snippets shows how to declare\n          the physical activity permission in your app\u2019s manifest file:\n        ")));
        $this$raw.xml("<manifest ... >\n...\n  <uses-permission android:name=\"android.permission.ACTIVITY_RECOGNITION\"/>\n...\n</manifest>");
        $this$raw.text(StringsKt.trimIndent((String)("\n          If you\u2019re migrating from Android 9 (API level 28) or lower,\n          the system auto-grants the android.permission.ACTIVITY_RECOGNITION permission to your app,\n          as needed, if your app satisfies each of the following conditions:\n          " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              The manifest file includes the\n              " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("com.google.android.gms.permission.ACTIVITY_RECOGNITION") + " permission.\n            "))) + "\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              The manifest file " + ApiUtils.INSTANCE.bold$targetsdkversion_upgrade_assistant("doesn't") + " include the\n              " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("android.permission.ACTIVITY_RECOGNITION permission") + ".\n            "))) + "\n          "))) + "\n          If the system-auto grants the android.permission.ACTIVITY_RECOGNITION permission,\n          your app retains the permission after you update your app to target Android 10.\n          However, the user can revoke this permission at any time in system settings.\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$7(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          If your app targets Android 10 or higher, it must have the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("ACCESS_FINE_LOCATION", "https://developer.android.com/reference/android/Manifest.permission#ACCESS_FINE_LOCATION") + " permission in order to use several methods within the Wi-Fi, Wi-Fi Aware,\n          or Bluetooth APIs. The following sections list the affected classes and methods.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          Telephony\n          " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("TelephonyManager", "https://developer.android.com/reference/android/telephony/TelephonyManager") + "\n              " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("getCellLocation()") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("getAllCellInfo()") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("requestNetworkScan()") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("requestCellInfoUpdate()") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("getAvailableNetworks()") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("getServiceState()") + "\n              "))) + "\n            "))) + "\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("TelephonyScanManager", "https://developer.android.com/reference/android/telephony/TelephonyScanManager") + "\n              " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("requestNetworkScan()") + "\n              "))) + "\n            "))) + "\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("TelephonyScanManager.NetworkScanCallback", "https://developer.android.com/reference/android/telephony/TelephonyScanManager.NetworkScanCallback") + "\n              " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("onResults()") + "\n              "))) + "\n            "))) + "\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("PhoneStateListener", "https://developer.android.com/reference/android/telephony/PhoneStateListener") + "\n              " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("onCellLocationChanged()") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("onCellInfoChanged()") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("onServiceStateChanged()") + "\n              "))) + "\n            "))) + "\n          "))) + "\n          Wi-Fi\n          " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("WifiManager", "https://developer.android.com/reference/android/net/wifi/WifiManager") + "\n              " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("startScan()") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("getScanResults()") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("getConnectionInfo()") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("getConfiguredNetworks()") + "\n              "))) + "\n            "))) + "\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("WifiAwareManager", "https://developer.android.com/reference/android/net/wifi/aware/WifiAwareManager")) + "\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("WifiP2pManager", "https://developer.android.com/reference/android/net/wifi/p2p/WifiP2pManager")) + "\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("WifiRttManager", "https://developer.android.com/reference/android/net/wifi/rtt/WifiRttManager")) + "\n          "))) + "\n          Bluetooth\n          " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("BluetoothAdapter", "https://developer.android.com/reference/android/bluetooth/BluetoothAdapter") + "\n              " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("startDiscovery()") + "\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("startLeScan()") + "\n              "))) + "\n            "))) + "\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("BluetoothAdapter.LeScanCallback", "https://developer.android.com/reference/android/bluetooth/BluetoothAdapter.LeScanCallback")) + "\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("BluetoothLeScanner", "https://developer.android.com/reference/android/bluetooth/le/BluetoothLeScanner") + "\n              " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n                " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant("startScan()") + "\n              "))) + "\n            "))) + "\n          "))) + "\n          The following code snippet show how to declare the fine location permission in your app\u2019s manifest file:\n        ")));
        $this$filtered.xml("<manifest>\n...\n<uses-permission android:name=\"android.permission.ACCESS_FINE_LOCATION\"></uses-permission>\n...\n</manifest>");
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$8(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          Apps targeting Android 10 or higher cannot enable or disable Wi-Fi. The\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("WifiManager.setWifiEnabled()"), "https://developer.android.com/reference/android/net/wifi/WifiManager#setWifiEnabled(boolean)") + " method always returns false.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          If you need to prompt users to enable and disable Wi-Fi, use a settings panel.\n          To display a settings panel with just the Wi-Fi settings, use an intent with the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant(ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("ACTION_WIFI"), "https://developer.android.com/reference/android/provider/Settings.Panel#ACTION_WIFI") + " action:\n        ")));
        $this$filtered.kotlin("val panelIntent = Intent(Settings.Panel.ACTION_WIFI)\nstartActivityForResult(panelIntent)");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          For more information, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Settings panels", "https://developer.android.com/about/versions/10/features#settings-panels") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10$lambda$9(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          To protect user privacy,\n          manual configuration of the list of Wi-Fi networks is restricted to system apps and\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("device policy controllers (DPCs)", "https://developer.android.com/work/dpc/build-dpc") + ". A given DPC can be either the device owner or the profile owner.\n          " + ApiUtils.INSTANCE.getBlankLine$targetsdkversion_upgrade_assistant() + "\n          If your app targets Android 10 or higher, and it isn't a system app or a DPC,\n          use the following alternative methods:\n          " + ApiUtils.INSTANCE.ulist$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              To trigger an instant local connection to a Wi-Fi network, use\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("WifiNetworkSpecifier", "https://developer.android.com/reference/android/net/wifi/WifiNetworkSpecifier") + " in a standard\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("NetworkRequest", "https://developer.android.com/reference/android/net/NetworkRequest") + " object.\n            "))) + "\n            " + ApiUtils.INSTANCE.item$targetsdkversion_upgrade_assistant(StringsKt.trimIndent((String)("\n              To add Wi-Fi networks for consideration for providing internet access to the user,\n              work with\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("WifiNetworkSuggestion", "https://developer.android.com/reference/android/net/wifi/WifiNetworkSuggestion") + " objects. You can add and remove networks that appear in the auto-connect network\n              selection dialog by calling\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("addNetworkSuggestions()", "https://developer.android.com/reference/android/net/wifi/WifiManager#addNetworkSuggestions(java.util.List%3Candroid.net.wifi.WifiNetworkSuggestion%3E)") + " and\n              " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("removeNetworkSuggestions()", "https://developer.android.com/reference/android/net/wifi/WifiManager#removeNetworkSuggestions(java.util.List%3Candroid.net.wifi.WifiNetworkSuggestion%3E)") + ", respectively. These methods don't require any location permissions.\n            "))) + "\n          "))) + "\n          For more information, see\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("Restrictions on direct access to configured Wi-Fi networks", "https://developer.android.com/about/versions/10/privacy/changes#configure-wifi") + ".\n        ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$10(Par $this$par) {
        Intrinsics.checkNotNullParameter((Object)$this$par, (String)"$this$par");
        $this$par.filtered("Notifications with a full-screen intent", "fullscreenIntent", (Function1<? super ElementListBuilder, Unit>)((Function1)Api29::steps$lambda$13$lambda$10$lambda$0));
        $this$par.raw("Multi-resume support", (Function1<? super ElementListBuilder, Unit>)((Function1)Api29::steps$lambda$13$lambda$10$lambda$1));
        $this$par.filtered("Multi-window support", "multiWindowSupport", (Function1<? super ElementListBuilder, Unit>)((Function1)Api29::steps$lambda$13$lambda$10$lambda$2));
        $this$par.raw("Scoped storage enabled by default", (Function1<? super ElementListBuilder, Unit>)((Function1)Api29::steps$lambda$13$lambda$10$lambda$3));
        $this$par.raw("Permission to access background location", (Function1<? super ElementListBuilder, Unit>)((Function1)Api29::steps$lambda$13$lambda$10$lambda$4));
        $this$par.filtered("Permission to access non-resettable identifier", "nonresettableIdentifiers", (Function1<? super ElementListBuilder, Unit>)((Function1)Api29::steps$lambda$13$lambda$10$lambda$5));
        $this$par.raw("Permission to access physical activity information", (Function1<? super ElementListBuilder, Unit>)((Function1)Api29::steps$lambda$13$lambda$10$lambda$6));
        $this$par.filtered("Some telephony, Bluetooth, Wi-Fi APIs require FINE location permission", "fineLocationApi", (Function1<? super ElementListBuilder, Unit>)((Function1)Api29::steps$lambda$13$lambda$10$lambda$7));
        $this$par.filtered("Restriction on enabling and disabling Wi-Fi", "wifiEnablingRestriction", (Function1<? super ElementListBuilder, Unit>)((Function1)Api29::steps$lambda$13$lambda$10$lambda$8));
        $this$par.filtered("Restrictions on access to Wi-Fi networks", "wifiNetworkAccessRestriction", (Function1<? super ElementListBuilder, Unit>)((Function1)Api29::steps$lambda$13$lambda$10$lambda$9));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$11(ElementListBuilder $this$raw) {
        Intrinsics.checkNotNullParameter((Object)$this$raw, (String)"$this$raw");
        $this$raw.text(StringsKt.trimIndent((String)("\n          Make sure to review the\n          " + ApiUtils.INSTANCE.link$targetsdkversion_upgrade_assistant("complete set of changes", "https://developer.android.com/about/versions/10/behavior-changes-10") + ".\n      ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13$lambda$12(ElementListBuilder $this$filtered) {
        Intrinsics.checkNotNullParameter((Object)$this$filtered, (String)"$this$filtered");
        $this$filtered.text(StringsKt.trimIndent((String)("\n          Once you've finished migrating your code, update " + ApiUtils.INSTANCE.code$targetsdkversion_upgrade_assistant("targetSdkVersion") + " to 29.\n      ")));
        return Unit.INSTANCE;
    }

    private static final Unit steps$lambda$13(Seq $this$seq) {
        Intrinsics.checkNotNullParameter((Object)$this$seq, (String)"$this$seq");
        $this$seq.par((Function1<? super Par, Unit>)((Function1)Api29::steps$lambda$13$lambda$10));
        $this$seq.raw("Remember to check for other changes", (Function1<? super ElementListBuilder, Unit>)((Function1)Api29::steps$lambda$13$lambda$11));
        $this$seq.filtered("Update the SDK version", "targetSdkVersion29", (Function1<? super ElementListBuilder, Unit>)((Function1)Api29::steps$lambda$13$lambda$12));
        return Unit.INSTANCE;
    }
}

