/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.refactoring.rename.FragmentaryPsiReference;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cmake.CMakeFileLocationProvider;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeFileReferenceSet;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import com.jetbrains.cmake.resolve.CMakeResolveLog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CMakeFileReference
extends FileReference
implements FragmentaryPsiReference {
    @NotNull
    private static final RecursionGuard<CMakeFileReference> ourGuard = RecursionManager.createGuard((String)"CMakeFileReference_resolve_guard");
    private static final int STACK_LIMIT = 100;
    @NotNull
    protected final CMakeFileReferenceSet cmakeFileReferenceSet;
    protected final boolean isExpressionRef;

    CMakeFileReference(@NotNull CMakeFileReferenceSet fileReferenceSet, @NotNull TextRange range, int index, @NotNull String text) {
        if (fileReferenceSet == null) {
            CMakeFileReference.$$$reportNull$$$0(0);
        }
        if (range == null) {
            CMakeFileReference.$$$reportNull$$$0(1);
        }
        if (text == null) {
            CMakeFileReference.$$$reportNull$$$0(2);
        }
        super((FileReferenceSet)fileReferenceSet, range, index, text);
        this.cmakeFileReferenceSet = fileReferenceSet;
        this.isExpressionRef = CMakePsiUtils.isVariableRef(text);
        if (this.isExpressionRef) {
            this.cmakeFileReferenceSet.setFragmentOnlyRename(true);
        }
    }

    protected ResolveResult @NotNull [] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            CMakeFileReference.$$$reportNull$$$0(3);
        }
        if (CMakePsiUtils.isVariableRef(this.getText())) {
            return this.resolveVariable(containingFile);
        }
        if (ourGuard.currentStack().size() > 100) {
            CMakeResolveLog.LOG.warn("Too long path for resolve. Stack overflow was prevented for:" + StringUtil.first((String)this.getText(), (int)50, (boolean)true));
            ourGuard.prohibitResultCaching((Object)this);
            if (ResolveResult.EMPTY_ARRAY == null) {
                CMakeFileReference.$$$reportNull$$$0(4);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResults = (ResolveResult[])ourGuard.doPreventingRecursion((Object)this, false, () -> super.innerResolve(caseSensitive, containingFile));
        ResolveResult[] resolveResultArray = resolveResults == null ? ResolveResult.EMPTY_ARRAY : resolveResults;
        if (resolveResultArray == null) {
            CMakeFileReference.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            CMakeFileReference.$$$reportNull$$$0(6);
        }
        PsiElement psiElement = this.isReadOnlyFragment() ? this.getElement() : super.handleElementRename(newElementName);
        if (psiElement == null) {
            CMakeFileReference.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    private ResolveResult @NotNull [] resolveVariable(@NotNull PsiFile containingFile) {
        String varName;
        if (containingFile == null) {
            CMakeFileReference.$$$reportNull$$$0(8);
        }
        if ((varName = this.getText()).startsWith("$")) {
            varName = this.getText().substring(1);
        }
        if (varName.startsWith("{")) {
            int pos = varName.indexOf(125, 1);
            String string = varName = pos < 1 ? "" : varName.substring(1, pos);
        }
        if (!varName.isEmpty()) {
            PsiFile element;
            block6 : switch (varName) {
                case "CMAKE_CURRENT_LIST_FILE": {
                    PsiFile psiFile = containingFile;
                    break;
                }
                case "CMAKE_CURRENT_LIST_DIR": 
                case "CMAKE_CURRENT_SOURCE_DIR": {
                    PsiFile psiFile = containingFile.getParent();
                    break;
                }
                case "PROJECT_SOURCE_DIR": {
                    PsiFile psiFile;
                    Project project = containingFile.getProject();
                    for (CMakeFileLocationProvider provider : CMakeFileLocationProvider.EP_NAME.getExtensionList()) {
                        VirtualFile projectBaseDir = provider.getProjectBaseDir(project);
                        if (projectBaseDir == null) continue;
                        psiFile = PsiManager.getInstance((Project)project).findDirectory(projectBaseDir);
                        break block6;
                    }
                    psiFile = null;
                    break;
                }
                default: {
                    PsiFile psiFile = element = null;
                }
            }
            if (element != null) {
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)element, false)};
                if (resolveResultArray == null) {
                    CMakeFileReference.$$$reportNull$$$0(9);
                }
                return resolveResultArray;
            }
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            CMakeFileReference.$$$reportNull$$$0(10);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public Object @NotNull [] getVariants() {
        CMakeArgument thisArgument;
        if (this.getElement() instanceof CMakeLiteral && ((thisArgument = ((CMakeLiteral)this.getElement()).getArgument()).isCommandDefinitionName() || thisArgument.isEndCommandDefinitionName(false) || thisArgument.isCMakeTargetReferenceName() || thisArgument.isCMakeTargetDefinitionName())) {
            if (LookupElement.EMPTY_ARRAY == null) {
                CMakeFileReference.$$$reportNull$$$0(11);
            }
            return LookupElement.EMPTY_ARRAY;
        }
        Object[] objectArray = super.getVariants();
        if (objectArray == null) {
            CMakeFileReference.$$$reportNull$$$0(12);
        }
        return objectArray;
    }

    public boolean isReadOnlyFragment() {
        return this.isExpressionRef;
    }

    public boolean isFragmentOnlyRename() {
        return this.cmakeFileReferenceSet.isFragmentOnlyRename();
    }

    @Nullable
    protected String encode(@NotNull String name, @NotNull PsiElement psiElement) {
        if (name == null) {
            CMakeFileReference.$$$reportNull$$$0(13);
        }
        if (psiElement == null) {
            CMakeFileReference.$$$reportNull$$$0(14);
        }
        return super.encode(name, psiElement);
    }

    @NotNull
    public String decode(@NotNull String name) {
        if (name == null) {
            CMakeFileReference.$$$reportNull$$$0(15);
        }
        String string = super.decode(StringUtil.unescapeStringCharacters((String)name));
        if (string == null) {
            CMakeFileReference.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 9, 10, 11, 12, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cmake/psi/CMakeFileReference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cmake/psi/CMakeFileReference";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "innerResolve";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "handleElementRename";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveVariable";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "decode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "innerResolve";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveVariable";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "encode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 9, 10, 11, 12, 16 -> new IllegalStateException(string);
        };
    }
}

