/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.interpreter;

import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.Stack;
import com.jetbrains.cmake.interpreter.CMakeScope;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeBlockCommand;
import com.jetbrains.cmake.psi.CMakeBodyBlock;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeEndBlockCommand;
import com.jetbrains.cmake.psi.CMakeEndFunctionCommand;
import com.jetbrains.cmake.psi.CMakeEndMacroCommand;
import com.jetbrains.cmake.psi.CMakeForeachCommand;
import com.jetbrains.cmake.psi.CMakeFunctionCommand;
import com.jetbrains.cmake.psi.CMakeIfCommand;
import com.jetbrains.cmake.psi.CMakeMacroCommand;
import com.jetbrains.cmake.psi.CMakeVisitor;
import com.jetbrains.cmake.psi.CMakeWhileCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeInterpreter {
    public static void interpret(@NotNull PsiElement element, @NotNull Listener listener) {
        if (element == null) {
            CMakeInterpreter.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            CMakeInterpreter.$$$reportNull$$$0(1);
        }
        element.accept((PsiElementVisitor)new FileVisitor(listener));
    }

    public static boolean expandArguments(@Nullable List<CMakeArgument> argumentList, @NotNull CMakeScope scope, @NotNull List<String> result) {
        if (scope == null) {
            CMakeInterpreter.$$$reportNull$$$0(2);
        }
        if (result == null) {
            CMakeInterpreter.$$$reportNull$$$0(3);
        }
        if (argumentList == null) {
            return false;
        }
        for (CMakeArgument arg : argumentList) {
            arg.expandIntoArgumentList(result, scope);
        }
        return true;
    }

    public static void expandListArgument(@NotNull String listArgument, @NotNull List<String> result) {
        int from;
        if (listArgument == null) {
            CMakeInterpreter.$$$reportNull$$$0(4);
        }
        if (result == null) {
            CMakeInterpreter.$$$reportNull$$$0(5);
        }
        if (!listArgument.contains(";")) {
            result.add(listArgument);
            return;
        }
        StringBuilder arg = new StringBuilder();
        int length = listArgument.length();
        int bracketDepth = 0;
        for (int cur = from = 0; cur < length; ++cur) {
            char c = listArgument.charAt(cur);
            if (c == '\\') {
                int next = cur + 1;
                if (next >= length || listArgument.charAt(next) != ';') continue;
                arg.append(listArgument, from, cur);
                from = cur = next;
                continue;
            }
            if (c == '[') {
                ++bracketDepth;
                continue;
            }
            if (c == ']') {
                --bracketDepth;
                continue;
            }
            if (c != ';' || bracketDepth != 0) continue;
            arg.append(listArgument, from, cur);
            result.add(arg.toString());
            arg.setLength(0);
            from = cur + 1;
        }
        if (from < length) {
            arg.append(listArgument, from, length);
        }
        if (!arg.isEmpty()) {
            result.add(arg.toString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listArgument";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cmake/interpreter/CMakeInterpreter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "interpret";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "expandArguments";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "expandListArgument";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FileVisitor
    extends CMakeVisitor {
        @NotNull
        private final Stack<CMakeScope> myScopes;
        @NotNull
        private final Listener myListener;

        FileVisitor(@NotNull Listener listener) {
            if (listener == null) {
                FileVisitor.$$$reportNull$$$0(0);
            }
            this.myScopes = new Stack();
            this.myListener = listener;
            this.myScopes.push((Object)new CMakeScope());
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                FileVisitor.$$$reportNull$$$0(1);
            }
            ProgressIndicatorProvider.checkCanceled();
            for (PsiElement psiElement : element.getChildren()) {
                psiElement.accept((PsiElementVisitor)this);
            }
        }

        @Override
        public void visitCMakeFunctionCommand(@NotNull CMakeFunctionCommand o) {
            if (o == null) {
                FileVisitor.$$$reportNull$$$0(2);
            }
            this.myListener.onEnterFunction();
            this.myScopes.push((Object)new CMakeScope());
        }

        @Override
        public void visitCMakeEndFunctionCommand(@NotNull CMakeEndFunctionCommand o) {
            if (o == null) {
                FileVisitor.$$$reportNull$$$0(3);
            }
            this.myListener.onExitFunction();
            this.myScopes.pop();
        }

        @Override
        public void visitCMakeMacroCommand(@NotNull CMakeMacroCommand o) {
            if (o == null) {
                FileVisitor.$$$reportNull$$$0(4);
            }
            this.myListener.onEnterMacro();
            this.myScopes.push((Object)new CMakeScope());
        }

        @Override
        public void visitCMakeEndMacroCommand(@NotNull CMakeEndMacroCommand o) {
            if (o == null) {
                FileVisitor.$$$reportNull$$$0(5);
            }
            this.myListener.onExitMacro();
            this.myScopes.pop();
        }

        @Override
        public void visitCMakeBlockCommand(@NotNull CMakeBlockCommand o) {
            if (o == null) {
                FileVisitor.$$$reportNull$$$0(6);
            }
            this.myListener.onEnterBlock();
            this.myScopes.push((Object)new CMakeScope());
        }

        @Override
        public void visitCMakeCommand(@NotNull CMakeCommand command) {
            ArrayList<String> effectiveArgs;
            List<CMakeArgument> argumentList;
            boolean ok;
            if (command == null) {
                FileVisitor.$$$reportNull$$$0(7);
            }
            String name = command.getName().toLowerCase(Locale.getDefault());
            CMakeScope currentScope = (CMakeScope)this.myScopes.peek();
            this.myListener.beforeCommand(command, currentScope);
            if ("set".equals(name) && (ok = CMakeInterpreter.expandArguments(argumentList = command.getCMakeArgumentList(), currentScope, effectiveArgs = new ArrayList<String>())) && !effectiveArgs.isEmpty()) {
                String varName = effectiveArgs.get(0);
                List<String> values = effectiveArgs.subList(1, effectiveArgs.size());
                int parentScopeIdx = values.indexOf("PARENT_SCOPE");
                if (parentScopeIdx < 0) {
                    int cacheIdx = values.indexOf("CACHE");
                    if (cacheIdx >= 0) {
                        values = values.subList(0, cacheIdx);
                    }
                    currentScope.setVariableValue(varName, values.isEmpty() ? null : StringUtil.join(values, (String)";"));
                }
            }
        }

        @Override
        public void visitCMakeEndBlockCommand(@NotNull CMakeEndBlockCommand o) {
            if (o == null) {
                FileVisitor.$$$reportNull$$$0(8);
            }
            this.myListener.onExitBlock();
            this.myScopes.pop();
        }

        @Override
        public void visitCMakeIfCommand(@NotNull CMakeIfCommand command) {
            if (command == null) {
                FileVisitor.$$$reportNull$$$0(9);
            }
            super.visitCMakeIfCommand(command);
            this.myListener.onEnterIf();
            List<CMakeBodyBlock> branches = command.getCMakeBodyBlockList();
            for (int i = 0; i < branches.size(); ++i) {
                CMakeBodyBlock branch = branches.get(i);
                if (!this.myListener.onEnterBranch(i)) continue;
                branch.accept(this);
                this.myListener.onExitBranch();
            }
            this.myListener.onExitIf();
        }

        @Override
        public void visitCMakeWhileCommand(@NotNull CMakeWhileCommand command) {
            if (command == null) {
                FileVisitor.$$$reportNull$$$0(10);
            }
            super.visitCMakeWhileCommand(command);
            this.myListener.onEnterWhile();
            CMakeBodyBlock body = command.getCMakeBodyBlock();
            this.iterateLoopBody(body);
            this.myListener.onExitWhile();
        }

        @Override
        public void visitCMakeForeachCommand(@NotNull CMakeForeachCommand command) {
            if (command == null) {
                FileVisitor.$$$reportNull$$$0(11);
            }
            super.visitCMakeForeachCommand(command);
            this.myListener.onEnterForeach();
            CMakeBodyBlock body = command.getCMakeBodyBlock();
            this.iterateLoopBody(body);
            this.myListener.onExitForeach();
        }

        private void iterateLoopBody(@Nullable CMakeBodyBlock body) {
            if (body == null) {
                return;
            }
            for (int i = 0; i < 2; ++i) {
                if (!this.myListener.onEnterLoop(i)) continue;
                body.accept(this);
                this.myListener.onExitLoop();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cmake/interpreter/CMakeInterpreter$FileVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCMakeFunctionCommand";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCMakeEndFunctionCommand";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCMakeMacroCommand";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCMakeEndMacroCommand";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCMakeBlockCommand";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCMakeCommand";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCMakeEndBlockCommand";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCMakeIfCommand";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCMakeWhileCommand";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCMakeForeachCommand";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Listener {
        public void beforeCommand(@NotNull CMakeCommand var1, @NotNull CMakeScope var2);

        public void onEnterIf();

        public void onExitIf();

        public boolean onEnterBranch(int var1);

        public void onExitBranch();

        public void onEnterWhile();

        public void onExitWhile();

        public void onEnterForeach();

        public void onExitForeach();

        public boolean onEnterLoop(int var1);

        public void onExitLoop();

        public void onEnterFunction();

        public void onExitFunction();

        public void onEnterMacro();

        public void onExitMacro();

        public void onEnterBlock();

        public void onExitBlock();
    }
}

