/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.highlighting;

import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.jetbrains.cmake.completion.contributors.providers.CMakeKnownLiteralsProvider;
import com.jetbrains.cmake.documentation.CMakeDocumentationUtilKt;
import com.jetbrains.cmake.highlighting.CMakeHighlighterAnnotator;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeFile;
import com.jetbrains.cmake.psi.CMakeVariableName;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cmake/highlighting/CMakeRainbowVisitor;", "Lcom/intellij/codeInsight/daemon/RainbowVisitor;", "<init>", "()V", "suitableForFile", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "visit", "", "element", "Lcom/intellij/psi/PsiElement;", "addMarkup", "Lcom/intellij/psi/PsiNamedElement;", "clone", "Lcom/intellij/codeInsight/daemon/impl/HighlightVisitor;", "intellij.cmake.psi"})
public final class CMakeRainbowVisitor
extends RainbowVisitor {
    public boolean suitableForFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return psiFile instanceof CMakeFile;
    }

    public void visit(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof CMakeVariableName || element instanceof CMakeArgument && !CMakeHighlighterAnnotator.Companion.isStringLikeArgument(element) && !CMakeDocumentationUtilKt.isProperty((CMakeArgument)element)) {
            this.addMarkup((PsiNamedElement)element);
        }
    }

    private final void addMarkup(PsiNamedElement element) {
        PsiElement context;
        String id = element.getName();
        if (id != null && !CMakeKnownLiteralsProvider.isReserved(id) && !CMakeKnownLiteralsProvider.isNumeric(id) && (context = (PsiElement)element.getContainingFile()) != null) {
            HighlightInfo attrs = this.getInfo(context, (PsiElement)element, id, null);
            this.addInfo(attrs);
        }
    }

    @NotNull
    public HighlightVisitor clone() {
        return (HighlightVisitor)new CMakeRainbowVisitor();
    }
}

