/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.completion.contributors.providers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cmake.completion.contributors.providers.AbstractCMakeCaseSensitiveCompletionProvider;
import com.jetbrains.cmake.completion.contributors.providers.CMakeQtCommands;
import com.jetbrains.cmake.completion.contributors.providers.CMakeQtDeprecatedCommands;
import com.jetbrains.cmake.completion.contributors.providers.CMakeStandardCommands;
import com.jetbrains.cmake.docsInfo.CMakeDocsInfoProvider;
import com.jetbrains.cmake.psi.CMakeCommandName;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

@Service
public final class CMakeCommandProvider
extends AbstractCMakeCaseSensitiveCompletionProvider {
    public final List<String> CMAKE_COMMANDS;
    private final Set<String> CMAKE_COMMANDS_AS_SET;

    public CMakeCommandProvider() {
        super(CMakeCommandProvider.getCommands());
        this.CMAKE_COMMANDS = this.myVariants;
        this.CMAKE_COMMANDS_AS_SET = new HashSet<String>(this.CMAKE_COMMANDS);
    }

    public static CMakeCommandProvider getInstance() {
        return (CMakeCommandProvider)((Object)ApplicationManager.getApplication().getService(CMakeCommandProvider.class));
    }

    private static List<String> getCommands() {
        Stream<String> defaultCommands = Arrays.stream(CMakeStandardCommands.values()).filter(command -> !command.isLexerToken()).map(command -> command.getCommandName());
        Stream<String> qtCommands = Arrays.stream(CMakeQtCommands.values()).map(command -> command.getCommandName());
        Stream<String> moduleCommands = CMakeDocsInfoProvider.Companion.getInstance().getModules(false).stream().flatMap(i -> i.getCommands().values().stream()).map(i -> i.getCommandName());
        return Stream.concat(Stream.concat(defaultCommands, qtCommands), moduleCommands).collect(Collectors.toList());
    }

    public static boolean isStandardCommand(String command) {
        return CMakeCommandProvider.getInstance().CMAKE_COMMANDS_AS_SET.contains(StringUtil.toLowerCase((String)command));
    }

    public static boolean isIncludeCommand(@NotNull CMakeCommandName cMakeCommandName) {
        if (cMakeCommandName == null) {
            CMakeCommandProvider.$$$reportNull$$$0(0);
        }
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.INCLUDE_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isAddLibraryCommand(@NotNull CMakeCommandName cMakeCommandName) {
        if (cMakeCommandName == null) {
            CMakeCommandProvider.$$$reportNull$$$0(1);
        }
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.ADD_LIBRARY_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isAddExecutableCommand(@NotNull CMakeCommandName cMakeCommandName) {
        if (cMakeCommandName == null) {
            CMakeCommandProvider.$$$reportNull$$$0(2);
        }
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.ADD_EXECUTABLE_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isSetCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.SET_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isAddCustomTargetCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.ADD_CUSTOM_TARGET_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isFltkWrapUiCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.FLTK_WRAP_UI_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isQtWrapCppCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeQtDeprecatedCommands.QT_WRAP_CPP_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isQtWrapUiCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeQtDeprecatedCommands.QT_WRAP_UI_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isSetPropertyCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.SET_PROPERTY_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isSetSourceFilesPropertiesCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.SET_SOURCE_FILES_PROPERTIES_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isTryCompileCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.TRY_COMPILE_COMMAND_NAME, cMakeCommandName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "cMakeCommandName";
        objectArray2[1] = "com/jetbrains/cmake/completion/contributors/providers/CMakeCommandProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isIncludeCommand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAddLibraryCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAddExecutableCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

