/*
 * Decompiled with CFR 0.152.
 */
package com.android.screenshottest.util;

import com.android.screenshottest.util.ImageData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "copyReferenceImages", "", "Lcom/android/screenshottest/util/ImageData;", "imagesToCopy", "intellij.android.screenshot-test"})
@SourceDebugExtension(value={"SMAP\nReferenceImageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReferenceImageManager.kt\ncom/android/screenshottest/util/ReferenceImageManagerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1869#2:81\n1870#2:85\n216#3:82\n217#3:84\n1#4:83\n*S KotlinDebug\n*F\n+ 1 ReferenceImageManager.kt\ncom/android/screenshottest/util/ReferenceImageManagerKt\n*L\n48#1:81\n48#1:85\n57#1:82\n57#1:84\n*E\n"})
public final class ReferenceImageManagerKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final List<ImageData> copyReferenceImages(@NotNull List<ImageData> imagesToCopy) {
        Intrinsics.checkNotNullParameter(imagesToCopy, (String)"imagesToCopy");
        List failures = new ArrayList();
        Set refreshRoots = new LinkedHashSet();
        try {
            Iterable $this$forEach$iv = imagesToCopy;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ImageData imageData = (ImageData)element$iv;
                boolean bl = false;
                String destinationPath = imageData.getPreviewData().getDestImagePath();
                if (destinationPath == null) {
                    LOG.error("Failed to copy screenshot reference image because the destination path is not available for: " + imageData.getPreviewData());
                    failures.add(imageData);
                    continue;
                }
                try {
                    Map<String, String> $this$forEach$iv2 = imageData.getLoadedImagePaths();
                    boolean $i$f$forEach2 = false;
                    Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        File it;
                        Map.Entry<String, String> element$iv2;
                        Map.Entry<String, String> entry = element$iv2 = iterator.next();
                        boolean bl2 = false;
                        String imagePath = entry.getKey();
                        File sourceFile = new File(imagePath);
                        File destinationFile = new File(destinationPath);
                        destinationFile.getParentFile().mkdirs();
                        FilesKt.copyTo$default((File)sourceFile, (File)destinationFile, (boolean)true, (int)0, (int)4, null);
                        LOG.info("Copied " + sourceFile.getPath() + " to " + destinationFile.getPath());
                        if (destinationFile.getParentFile() == null) continue;
                        boolean bl3 = false;
                        refreshRoots.add(it);
                    }
                }
                catch (IOException e) {
                    LOG.error("Failed to copy screenshot reference image due to an I/O error for: " + imageData.getPreviewData(), (Throwable)e);
                    failures.add(imageData);
                }
            }
            if (!((Collection)refreshRoots).isEmpty()) {
                LocalFileSystem.getInstance().refreshIoFiles((Iterable)refreshRoots, true, true, null);
            }
        }
        catch (IllegalStateException e) {
            LOG.error("Failed to copy screenshot reference images during setup due to invalid project state or configuration.", (Throwable)e);
            return imagesToCopy;
        }
        return failures;
    }

    static {
        Logger logger = Logger.getInstance((String)"com.android.screenshottest.util.ReferenceImageManager");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

