/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Numbers;
import org.assertj.core.internal.WholeNumbers;
import org.assertj.core.util.VisibleForTesting;

public class Bytes
extends Numbers<Byte>
implements WholeNumbers<Byte> {
    private static final Bytes INSTANCE = new Bytes();

    public static Bytes instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Bytes() {
    }

    public Bytes(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    @Override
    protected Byte zero() {
        return (byte)0;
    }

    @Override
    protected Byte one() {
        return (byte)1;
    }

    @Override
    protected Byte absDiff(Byte actual, Byte other) {
        return (byte)Math.abs(actual - other);
    }

    @Override
    protected boolean isGreaterThan(Byte value2, Byte other) {
        return value2 > other;
    }

    @Override
    public boolean isEven(Byte number) {
        return (number & this.one()) == this.zero();
    }
}

