/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.reflect.Array;
import java.util.Objects;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldContainAtIndex;
import org.assertj.core.error.ShouldHaveDimensions;
import org.assertj.core.error.ShouldHaveSameDimensionsAs;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContainAtIndex;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.Failures;
import org.assertj.core.util.VisibleForTesting;

public class Arrays2D {
    private static final Arrays2D INSTANCE = new Arrays2D();

    public static Arrays2D instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    public void assertNullOrEmpty(AssertionInfo info, Failures failures, Object array) {
        if (array == null) {
            return;
        }
        if (Arrays2D.countArrayElements(array) > 0) {
            throw failures.failure(info, ShouldBeNullOrEmpty.shouldBeNullOrEmpty(array));
        }
    }

    @VisibleForTesting
    public void assertEmpty(AssertionInfo info, Failures failures, Object array) {
        Arrays.assertNotNull(info, array);
        int numberOfRows = org.assertj.core.util.Arrays.sizeOf(array);
        for (int i2 = 0; i2 < numberOfRows; ++i2) {
            Object actualArrayRow = Array.get(array, i2);
            if (org.assertj.core.util.Arrays.sizeOf(actualArrayRow) <= 0) continue;
            throw failures.failure(info, ShouldBeEmpty.shouldBeEmpty(array));
        }
    }

    @VisibleForTesting
    public void assertHasDimensions(AssertionInfo info, Failures failures, Object array2d, int expectedNumberOfRows, int expectedRowSize) {
        this.assertNumberOfRows(info, failures, array2d, expectedNumberOfRows);
        for (int i2 = 0; i2 < expectedNumberOfRows; ++i2) {
            Object actualRow = Array.get(array2d, i2);
            this.assertSecondDimension(info, failures, actualRow, expectedRowSize, i2);
        }
    }

    @VisibleForTesting
    public void assertNumberOfRows(AssertionInfo info, Failures failures, Object array, int expectedSize) {
        Arrays.assertNotNull(info, array);
        int sizeOfActual = org.assertj.core.util.Arrays.sizeOf(array);
        if (sizeOfActual != expectedSize) {
            throw failures.failure(info, ShouldHaveDimensions.shouldHaveFirstDimension(array, sizeOfActual, expectedSize));
        }
    }

    private void assertSecondDimension(AssertionInfo info, Failures failures, Object actual, int expectedSize, int rowIndex) {
        Arrays.assertNotNull(info, actual);
        Arrays2D.checkArraySizes(actual, failures, org.assertj.core.util.Arrays.sizeOf(actual), expectedSize, info, rowIndex);
    }

    private static void checkArraySizes(Object actual, Failures failures, int sizeOfActual, int sizeOfOther, AssertionInfo info, int rowIndex) {
        if (sizeOfActual != sizeOfOther) {
            throw failures.failure(info, ShouldHaveDimensions.shouldHaveSize(actual, sizeOfActual, sizeOfOther, rowIndex));
        }
    }

    @VisibleForTesting
    public void assertHasSameDimensionsAs(AssertionInfo info, Object actual, Object other) {
        Arrays.assertNotNull(info, actual);
        Arrays.assertIsArray(info, actual);
        Arrays.assertIsArray(info, other);
        int actualFirstDimension = org.assertj.core.util.Arrays.sizeOf(actual);
        int otherFirstDimension = org.assertj.core.util.Arrays.sizeOf(other);
        if (actualFirstDimension != otherFirstDimension) {
            throw Failures.instance().failure(info, ShouldHaveSameDimensionsAs.shouldHaveSameDimensionsAs(actual, other, actualFirstDimension, otherFirstDimension));
        }
        for (int i2 = 0; i2 < actualFirstDimension; ++i2) {
            Object actualRow = Array.get(actual, i2);
            Arrays.assertIsArray(info, actualRow);
            Object otherRow = Array.get(other, i2);
            Arrays.assertIsArray(info, otherRow);
            Arrays2D.hasSameRowSizeAsCheck(info, i2, actual, other, actualRow, otherRow, org.assertj.core.util.Arrays.sizeOf(actualRow));
        }
    }

    static void hasSameRowSizeAsCheck(AssertionInfo info, int rowIndex, Object actual, Object other, Object actualRow, Object otherRow, int actualRowSize) {
        Objects.requireNonNull(other, String.format("The array to compare %s size with should not be null", actual));
        int expectedRowSize = Array.getLength(otherRow);
        if (actualRowSize != expectedRowSize) {
            throw Failures.instance().failure(info, ShouldHaveSameDimensionsAs.shouldHaveSameDimensionsAs(rowIndex, actualRowSize, expectedRowSize, actualRow, otherRow, actual, other));
        }
    }

    @VisibleForTesting
    public void assertContains(AssertionInfo info, Failures failures, Object array, Object value2, Index index) {
        Arrays.assertNotNull(info, array);
        this.assertNotEmpty(info, failures, array);
        CommonValidations.checkIndexValueIsValid(index, org.assertj.core.util.Arrays.sizeOf(array) - 1);
        Object actualElement = Array.get(array, index.value);
        if (!Objects.deepEquals(actualElement, value2)) {
            throw failures.failure(info, ShouldContainAtIndex.shouldContainAtIndex(array, value2, index, Array.get(array, index.value)));
        }
    }

    @VisibleForTesting
    public void assertNotEmpty(AssertionInfo info, Failures failures, Object array) {
        Arrays.assertNotNull(info, array);
        if (Arrays2D.countArrayElements(array) == 0) {
            throw failures.failure(info, ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }

    private static int countArrayElements(Object array) {
        int numberOfRows = org.assertj.core.util.Arrays.sizeOf(array);
        int allRowsElementsCount = 0;
        for (int i2 = 0; i2 < numberOfRows; ++i2) {
            Object actualRow = Array.get(array, i2);
            allRowsElementsCount += org.assertj.core.util.Arrays.sizeOf(actualRow);
        }
        return allRowsElementsCount;
    }

    @VisibleForTesting
    public void assertDoesNotContain(AssertionInfo info, Failures failures, Object array, Object value2, Index index) {
        Arrays.assertNotNull(info, array);
        CommonValidations.checkIndexValueIsValid(index, Integer.MAX_VALUE);
        if (index.value >= org.assertj.core.util.Arrays.sizeOf(array)) {
            return;
        }
        if (Objects.deepEquals(Array.get(array, index.value), value2)) {
            throw failures.failure(info, ShouldNotContainAtIndex.shouldNotContainAtIndex(array, value2, index));
        }
    }
}

