/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.mockJDI.values;

import com.intellij.debugger.mockJDI.MockMirror;
import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.debugger.mockJDI.values.MockBooleanValue;
import com.intellij.debugger.mockJDI.values.MockDoubleValue;
import com.intellij.debugger.mockJDI.values.MockFloatValue;
import com.intellij.debugger.mockJDI.values.MockIntegerValue;
import com.intellij.debugger.mockJDI.values.MockObjectReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public abstract class MockValue
extends MockMirror
implements Value {
    public MockValue(MockVirtualMachine virtualMachine) {
        super(virtualMachine);
    }

    public abstract Object getValue();

    @Override
    public Type type() {
        throw new UnsupportedOperationException("Not implemented: \"type\" in " + this.getClass().getName());
    }

    public static MockValue createValue(@NotNull Object o, MockVirtualMachine virtualMachine) {
        if (o == null) {
            MockValue.$$$reportNull$$$0(0);
        }
        return MockObjectReference.createObjectReference(o, o.getClass(), virtualMachine);
    }

    public static MockValue createValue(Object o, Class<?> type, MockVirtualMachine virtualMachine) {
        if (type == Boolean.TYPE) {
            return new MockBooleanValue(virtualMachine, (Boolean)o);
        }
        if (type == Integer.TYPE) {
            return new MockIntegerValue(virtualMachine, (Integer)o);
        }
        if (type == Float.TYPE) {
            return new MockFloatValue(virtualMachine, ((Float)o).floatValue());
        }
        if (type == Double.TYPE) {
            return new MockDoubleValue(virtualMachine, (Double)o);
        }
        return MockObjectReference.createObjectReference(o, type, virtualMachine);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/debugger/mockJDI/values/MockValue", "createValue"));
    }
}

