/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test.junit4.matchers;

import androidx.annotation.FloatRange;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.test.junit4.matchers.BitmapMatcher;
import androidx.compose.ui.test.junit4.matchers.MatchResult;
import androidx.compose.ui.test.junit4.matchers.PixelPerfectMatcher;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Color;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0013\n\u0002\b\t\b\u0001\u0018\u0000 .2\u00020\u0001:\u0001.B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J-\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0010J8\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0002J(\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002J0\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003H\u0002J8\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0002JH\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u0010\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Landroidx/compose/ui/test/junit4/matchers/MSSIMMatcher;", "Landroidx/compose/ui/test/junit4/matchers/BitmapMatcher;", "threshold", "", "<init>", "(D)V", "compareBitmaps", "Landroidx/compose/ui/test/junit4/matchers/MatchResult;", "expected", "", "given", "width", "", "height", "calculateSSIM", "ideal", "calculateSSIM$ui_test_junit4", "offset", "stride", "computeWindowSize", "coordinateStart", "dimension", "isWindowWhite", "", "colors", "start", "windowWidth", "windowHeight", "indexFromXAndY", "x", "y", "SSIM", "muX", "muY", "sigX", "sigY", "sigXY", "getMeans", "", "pixels0", "pixels1", "getVariances", "mean0", "mean1", "getIntensity", "pixel", "Companion", "ui-test-junit4"})
@StabilityInferred(parameters=1)
public final class MSSIMMatcher
implements BitmapMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double threshold;
    public static final int $stable;
    private static final double CONSTANT_L = 254.0;
    private static final double CONSTANT_K1 = 1.0E-5;
    private static final double CONSTANT_K2 = 3.0E-5;
    private static final double CONSTANT_C1;
    private static final double CONSTANT_C2;
    private static final int WINDOW_SIZE = 10;

    public MSSIMMatcher(@FloatRange(from=0.0, to=1.0) double threshold) {
        this.threshold = threshold;
    }

    @Override
    @NotNull
    public MatchResult compareBitmaps(@NotNull int[] expected, @NotNull int[] given, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Intrinsics.checkNotNullParameter((Object)given, (String)"given");
        double SSIMTotal = this.calculateSSIM$ui_test_junit4(expected, given, width, height);
        String string = "%.3f";
        Object[] objectArray = new Object[]{SSIMTotal};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String stats = "[MSSIM] Required SSIM: " + this.threshold + ", Actual SSIM: " + string2;
        if (SSIMTotal >= this.threshold) {
            return new MatchResult(true, stats, null);
        }
        MatchResult result = new PixelPerfectMatcher().compareBitmaps(expected, given, width, height);
        objectArray = result.getDiff();
        return new MatchResult(false, stats, (int[])objectArray);
    }

    public final double calculateSSIM$ui_test_junit4(@NotNull int[] ideal, @NotNull int[] given, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)ideal, (String)"ideal");
        Intrinsics.checkNotNullParameter((Object)given, (String)"given");
        return this.calculateSSIM(ideal, given, 0, width, width, height);
    }

    private final double calculateSSIM(int[] ideal, int[] given, int offset, int stride, int width, int height) {
        double SSIMTotal = 0.0;
        int windows = 0;
        for (int currentWindowY = 0; currentWindowY < height; currentWindowY += 10) {
            int windowHeight = this.computeWindowSize(currentWindowY, height);
            int currentWindowX = 0;
            while (currentWindowX < width) {
                int windowWidth = this.computeWindowSize(currentWindowX, width);
                int start = this.indexFromXAndY(currentWindowX, currentWindowY, stride, offset);
                if (this.isWindowWhite(ideal, start, stride, windowWidth, windowHeight) && this.isWindowWhite(given, start, stride, windowWidth, windowHeight)) {
                    currentWindowX += 10;
                    continue;
                }
                ++windows;
                double[] means = this.getMeans(ideal, given, start, stride, windowWidth, windowHeight);
                double meanX = means[0];
                double meanY = means[1];
                double[] variances = this.getVariances(ideal, given, meanX, meanY, start, stride, windowWidth, windowHeight);
                double varX = variances[0];
                double varY = variances[1];
                double stdBoth = variances[2];
                double SSIM = this.SSIM(meanX, meanY, varX, varY, stdBoth);
                SSIMTotal += SSIM;
                currentWindowX += 10;
            }
        }
        if (windows == 0) {
            return 1.0;
        }
        return SSIMTotal / (double)windows;
    }

    private final int computeWindowSize(int coordinateStart, int dimension) {
        return coordinateStart + 10 <= dimension ? 10 : dimension - coordinateStart;
    }

    private final boolean isWindowWhite(int[] colors, int start, int stride, int windowWidth, int windowHeight) {
        for (int y = 0; y < windowHeight; ++y) {
            for (int x = 0; x < windowWidth; ++x) {
                if (colors[this.indexFromXAndY(x, y, stride, start)] == -1) continue;
                return false;
            }
        }
        return true;
    }

    private final int indexFromXAndY(int x, int y, int stride, int offset) {
        return x + y * stride + offset;
    }

    private final double SSIM(double muX, double muY, double sigX, double sigY, double sigXY) {
        double SSIM = ((double)2 * muX * muY + CONSTANT_C1) * ((double)2 * sigXY + CONSTANT_C2);
        double denom = (muX * muX + muY * muY + CONSTANT_C1) * (sigX + sigY + CONSTANT_C2);
        return SSIM /= denom;
    }

    private final double[] getMeans(int[] pixels0, int[] pixels1, int start, int stride, int windowWidth, int windowHeight) {
        double avg0 = 0.0;
        double avg1 = 0.0;
        for (int y = 0; y < windowHeight; ++y) {
            for (int x = 0; x < windowWidth; ++x) {
                int index = this.indexFromXAndY(x, y, stride, start);
                avg0 += this.getIntensity(pixels0[index]);
                avg1 += this.getIntensity(pixels1[index]);
            }
        }
        double[] dArray = new double[]{avg0 /= (double)windowWidth * (double)windowHeight, avg1 /= (double)windowWidth * (double)windowHeight};
        return dArray;
    }

    private final double[] getVariances(int[] pixels0, int[] pixels1, double mean0, double mean1, int start, int stride, int windowWidth, int windowHeight) {
        if (windowHeight == 1 && windowWidth == 1) {
            double[] dArray = new double[]{0.0, 0.0, 0.0};
            return dArray;
        }
        double var0 = 0.0;
        double var1 = 0.0;
        double varBoth = 0.0;
        for (int y = 0; y < windowHeight; ++y) {
            for (int x = 0; x < windowWidth; ++x) {
                int index = this.indexFromXAndY(x, y, stride, start);
                double v0 = this.getIntensity(pixels0[index]) - mean0;
                double v1 = this.getIntensity(pixels1[index]) - mean1;
                var0 += v0 * v0;
                var1 += v1 * v1;
                varBoth += v0 * v1;
            }
        }
        double denominatorWithBesselsCorrection = (double)(windowWidth * windowHeight) - 1.0;
        double[] dArray = new double[]{var0 /= denominatorWithBesselsCorrection, var1 /= denominatorWithBesselsCorrection, varBoth /= denominatorWithBesselsCorrection};
        return dArray;
    }

    private final double getIntensity(int pixel) {
        double gamma = 1.0;
        double l = 0.0;
        l += (double)0.21f * Math.pow((double)Color.INSTANCE.getR(pixel) / 255.0, gamma);
        l += (double)0.72f * Math.pow((double)Color.INSTANCE.getG(pixel) / 255.0, gamma);
        double alpha = (double)Color.INSTANCE.getA(pixel) / 255.0;
        return (l += (double)0.07f * Math.pow((double)Color.INSTANCE.getB(pixel) / 255.0, gamma)) * alpha;
    }

    static {
        CONSTANT_C1 = Math.pow(0.00254, 2.0);
        CONSTANT_C2 = Math.pow(0.00762, 2.0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Landroidx/compose/ui/test/junit4/matchers/MSSIMMatcher$Companion;", "", "<init>", "()V", "CONSTANT_L", "", "CONSTANT_K1", "CONSTANT_K2", "CONSTANT_C1", "CONSTANT_C2", "WINDOW_SIZE", "", "ui-test-junit4"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

