/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.test;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0006J\u0014\u0010\u000e\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010J\u0011\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0004J\t\u0010\u0014\u001a\u00020\u0000H\u0086\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/compose/ui/test/SemanticsMatcher;", "", "description", "", "matcher", "Lkotlin/Function1;", "Landroidx/compose/ui/semantics/SemanticsNode;", "", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getDescription", "()Ljava/lang/String;", "matches", "node", "matchesAny", "nodes", "", "and", "other", "or", "not", "Companion", "ui-test"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nSemanticsMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemanticsMatcher.kt\nandroidx/compose/ui/test/SemanticsMatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1761#2,3:77\n*S KotlinDebug\n*F\n+ 1 SemanticsMatcher.kt\nandroidx/compose/ui/test/SemanticsMatcher\n*L\n57#1:77,3\n*E\n"})
public final class SemanticsMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String description;
    @NotNull
    private final Function1<SemanticsNode, Boolean> matcher;
    public static final int $stable;

    public SemanticsMatcher(@NotNull String description, @NotNull Function1<? super SemanticsNode, Boolean> matcher) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.description = description;
        this.matcher = matcher;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public final boolean matches(@NotNull SemanticsNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return (Boolean)this.matcher.invoke((Object)node);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean matchesAny(@NotNull Iterable<SemanticsNode> nodes) {
        boolean bl;
        block3: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            Iterable<SemanticsNode> iterable = nodes;
            Function1<SemanticsNode, Boolean> predicate$iv = this.matcher;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    if (!((Boolean)predicate$iv.invoke(element$iv)).booleanValue()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final SemanticsMatcher and(@NotNull SemanticsMatcher other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new SemanticsMatcher("(" + this.description + ") && (" + other.description + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)arg_0 -> SemanticsMatcher.and$lambda$0(this, other, arg_0)));
    }

    @NotNull
    public final SemanticsMatcher or(@NotNull SemanticsMatcher other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new SemanticsMatcher("(" + this.description + ") || (" + other.description + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)arg_0 -> SemanticsMatcher.or$lambda$1(this, other, arg_0)));
    }

    @NotNull
    public final SemanticsMatcher not() {
        return new SemanticsMatcher("NOT (" + this.description + ")", (Function1<? super SemanticsNode, Boolean>)((Function1)arg_0 -> SemanticsMatcher.not$lambda$2(this, arg_0)));
    }

    private static final boolean and$lambda$0(SemanticsMatcher this$0, SemanticsMatcher $other, SemanticsNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Boolean)this$0.matcher.invoke((Object)it) != false && $other.matches(it);
    }

    private static final boolean or$lambda$1(SemanticsMatcher this$0, SemanticsMatcher $other, SemanticsNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Boolean)this$0.matcher.invoke((Object)it) != false || $other.matches(it);
    }

    private static final boolean not$lambda$2(SemanticsMatcher this$0, SemanticsNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Boolean)this$0.matcher.invoke((Object)it) == false;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b2\u0006\u0010\t\u001a\u0002H\u0006\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000b\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\bJ\u001a\u0010\f\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\b\u00a8\u0006\r"}, d2={"Landroidx/compose/ui/test/SemanticsMatcher$Companion;", "", "<init>", "()V", "expectValue", "Landroidx/compose/ui/test/SemanticsMatcher;", "T", "key", "Landroidx/compose/ui/semantics/SemanticsPropertyKey;", "expectedValue", "(Landroidx/compose/ui/semantics/SemanticsPropertyKey;Ljava/lang/Object;)Landroidx/compose/ui/test/SemanticsMatcher;", "keyIsDefined", "keyNotDefined", "ui-test"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> SemanticsMatcher expectValue(@NotNull SemanticsPropertyKey<T> key, T expectedValue) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            return new SemanticsMatcher(key.getName() + " = '" + expectedValue + "'", (Function1<? super SemanticsNode, Boolean>)((Function1)arg_0 -> Companion.expectValue$lambda$1(key, expectedValue, arg_0)));
        }

        @NotNull
        public final <T> SemanticsMatcher keyIsDefined(@NotNull SemanticsPropertyKey<T> key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            return new SemanticsMatcher(key.getName() + " is defined", (Function1<? super SemanticsNode, Boolean>)((Function1)arg_0 -> Companion.keyIsDefined$lambda$2(key, arg_0)));
        }

        @NotNull
        public final <T> SemanticsMatcher keyNotDefined(@NotNull SemanticsPropertyKey<T> key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            return new SemanticsMatcher(key.getName() + " is NOT defined", (Function1<? super SemanticsNode, Boolean>)((Function1)arg_0 -> Companion.keyNotDefined$lambda$3(key, arg_0)));
        }

        private static final Object expectValue$lambda$1$lambda$0() {
            return null;
        }

        private static final boolean expectValue$lambda$1(SemanticsPropertyKey $key, Object $expectedValue, SemanticsNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it.getConfig().getOrElseNullable($key, Companion::expectValue$lambda$1$lambda$0), (Object)$expectedValue);
        }

        private static final boolean keyIsDefined$lambda$2(SemanticsPropertyKey $key, SemanticsNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getConfig().contains($key);
        }

        private static final boolean keyNotDefined$lambda$3(SemanticsPropertyKey $key, SemanticsNode it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !it.getConfig().contains($key);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

