/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderContextCache;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCCompilerFeaturesHelper {
    @NotNull
    public static <T> T getFeatureForFile(@Nullable PsiFile file, @Nullable OCImmutableInclusionContext fileContext, @NotNull OCCompilerFeatures.Type<T> key) {
        T result;
        if (key == null) {
            OCCompilerFeaturesHelper.$$$reportNull$$$0(0);
        }
        Object object = (result = OCCompilerFeaturesHelper.getFeatureForFileOrNull(file, key, fileContext)) == null ? key.getDefault() : result;
        if (object == null) {
            OCCompilerFeaturesHelper.$$$reportNull$$$0(1);
        }
        return object;
    }

    private static <T> T getFeatureForFileOrNull(@Nullable PsiFile file, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull OCCompilerFeatures.Type<T> key, @Nullable OCImmutableInclusionContext context) {
        if (key == null) {
            OCCompilerFeaturesHelper.$$$reportNull$$$0(2);
        }
        if (file == null && context == null) {
            return null;
        }
        if (context != null && context.getConfiguration() == null && file != null) {
            context = null;
        }
        if (context == null) {
            if (!OCLanguageUtils.supportsResolve(file)) {
                return null;
            }
            context = OCHeaderContextCache.headerContext(file);
        }
        return OCCompilerFeaturesHelper.getFeatureForContext(key, context);
    }

    public static <T> T getFeatureForContext(@NotNull OCCompilerFeatures.Type<T> key, OCImmutableInclusionContext context) {
        if (key == null) {
            OCCompilerFeaturesHelper.$$$reportNull$$$0(3);
        }
        return (T)context.getCompilerFeature(key);
    }

    public static boolean isFeatureEnabled(@Nullable PsiFile file, @NotNull OCCompilerFeatures.Feature feature) {
        if (feature == null) {
            OCCompilerFeaturesHelper.$$$reportNull$$$0(4);
        }
        return (Boolean)OCCompilerFeaturesHelper.getFeatureForFile(file, null, feature);
    }

    public static boolean isFeatureEnabled(@Nullable OCImmutableInclusionContext context, @NotNull OCCompilerFeatures.Feature feature) {
        if (feature == null) {
            OCCompilerFeaturesHelper.$$$reportNull$$$0(5);
        }
        return (Boolean)OCCompilerFeaturesHelper.getFeatureForFile(null, context, feature);
    }

    @NotNull
    public static OCCompilerFeatures.DiagnosticLevel getDiagnosticLevel(@Nullable PsiFile file, @NotNull OCCompilerFeatures.Diagnostic diagnostic) {
        if (diagnostic == null) {
            OCCompilerFeaturesHelper.$$$reportNull$$$0(6);
        }
        return (OCCompilerFeatures.DiagnosticLevel)OCCompilerFeaturesHelper.getFeatureForFile(file, null, diagnostic);
    }

    public static boolean isArcDisabled(@NotNull PsiFile file) {
        if (file == null) {
            OCCompilerFeaturesHelper.$$$reportNull$$$0(7);
        }
        return (Boolean)OCCompilerFeaturesHelper.getFeatureForFile(file, null, OCCompilerFeatures.Feature.OBJC_ARC) == false;
    }

    public static boolean isArcEnabled(@NotNull PsiFile file) {
        if (file == null) {
            OCCompilerFeaturesHelper.$$$reportNull$$$0(8);
        }
        return (Boolean)OCCompilerFeaturesHelper.getFeatureForFile(file, null, OCCompilerFeatures.Feature.OBJC_ARC);
    }

    public static boolean supportsIvarsInImplementation() {
        return true;
    }

    public static boolean supportsIvarsInCategories() {
        return true;
    }

    public static boolean supportsLaterMethodDeclaration() {
        return true;
    }

    public static boolean supportsAutosynthesis(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.OBJC_DEFAULT_SYNTHESIZE_PROPERTIES);
    }

    public static boolean supportsAutosynthesis(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(context, OCCompilerFeatures.Feature.OBJC_DEFAULT_SYNTHESIZE_PROPERTIES);
    }

    public static boolean supportsNullability(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.NULLABILITY);
    }

    public static boolean supportsNullability(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(context, OCCompilerFeatures.Feature.NULLABILITY);
    }

    public static boolean supportsNullabilityNullableResult(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.NULLABILITY_NULLABLE_RESULT);
    }

    public static boolean supportsNullabilityNullableResult(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(context, OCCompilerFeatures.Feature.NULLABILITY_NULLABLE_RESULT);
    }

    public static boolean supportsGccAutoType(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.GCC_AUTO_TYPE);
    }

    public static boolean supportsGccAutoType(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(context, OCCompilerFeatures.Feature.GCC_AUTO_TYPE);
    }

    public static boolean supportsAvailableExpression(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.BUILTIN_AVAILABLE);
    }

    public static boolean supportsAvailableExpression(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(context, OCCompilerFeatures.Feature.BUILTIN_AVAILABLE);
    }

    public static boolean supportsClassProperty(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.OBJC_CLASS_PROPERTY);
    }

    public static boolean supportsClassProperty(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(context, OCCompilerFeatures.Feature.OBJC_CLASS_PROPERTY);
    }

    public static boolean supportsMsvcExtensions(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.MS_EXTENSIONS);
    }

    public static boolean supportsMsvcExtensions(@Nullable OCImmutableInclusionContext context) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(context, OCCompilerFeatures.Feature.MS_EXTENSIONS);
    }

    public static boolean supportsExplicitAtomic(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.OBJC_PROPERTY_EXPLICIT_ATOMIC);
    }

    public static boolean supportsInstancetype(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.OBJC_INSTANCETYPE);
    }

    public static boolean supportsSubscripting(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.OBJC_SUBSCRIPTING);
    }

    public static boolean supportsObjectLiterals(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.OBJC_ARRAY_LITERALS) && OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.OBJC_DICTIONARY_LITERALS);
    }

    public static boolean supportsCxxAutoType(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.CXX_AUTO_TYPE);
    }

    public static boolean supportsCAutoType(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.C_AUTO_TYPE);
    }

    public static boolean supportsCxxReturnTypeDeduction(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.CXX_RETURN_TYPE_DEDUCTION);
    }

    public static boolean supportsCxxAttributes(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.CXX_ATTRIBUTES);
    }

    public static boolean supportsCxxMaybeUnusedAttribute(@Nullable PsiFile file) {
        OCLanguageStandard std = (OCLanguageStandard)OCCompilerFeaturesHelper.getFeatureForFile(file, null, OCCompilerFeatures.LANGUAGE_STANDARD);
        return ApplicationManager.getApplication().isUnitTestMode() || std.ordinal() >= OCLanguageStandard.CPP17.ordinal();
    }

    public static boolean supportsCxxLambdas(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.CXX_LAMBDAS);
    }

    public static boolean supportsCxxGenericLambdas(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.CXX_GENERIC_LAMBDAS);
    }

    public static boolean supportsOverrideControl(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.CXX_OVERRIDE_CONTROL);
    }

    public static boolean supportsInitializerLists(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.CXX_GENERALIZED_INITIALIZERS);
    }

    public static boolean supportsNullptr(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.CXX_NULLPTR) || OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.C_NULLPTR);
    }

    public static boolean supportsInClassInitialization(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.CXX_NONSTATIC_MEMBER_INIT);
    }

    public static boolean supportsCxxConcepts(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.CXX_CONCEPTS);
    }

    public static boolean supportsCxxConstexpr(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.CXX_CONSTEXPR);
    }

    public static boolean supportsCConstexpr(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.C_CONSTEXPR);
    }

    public static boolean supportsCxxNoexcept(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.isFeatureEnabled(file, OCCompilerFeatures.Feature.CXX_NOEXCEPT);
    }

    public static boolean supportsConstexprVirtual(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.supportsLanguageStandard(file, OCLanguageStandard.CPP20);
    }

    private static boolean supportsLanguageStandard(@Nullable PsiFile file, @NotNull OCLanguageStandard languageStandard) {
        if (languageStandard == null) {
            OCCompilerFeaturesHelper.$$$reportNull$$$0(9);
        }
        OCLanguageStandard langStd = (OCLanguageStandard)OCCompilerFeaturesHelper.getFeatureForFile(file, null, OCCompilerFeatures.LANGUAGE_STANDARD);
        return langStd.supports(languageStandard);
    }

    @NotNull
    public static OCLanguageStandard getLanguageStandard(@Nullable OCImmutableInclusionContext context, @Nullable PsiFile file) {
        return (OCLanguageStandard)OCCompilerFeaturesHelper.getFeatureForFile(file, context, OCCompilerFeatures.LANGUAGE_STANDARD);
    }

    public static boolean supportsConstexprFunctionTryBlock(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.supportsLanguageStandard(file, OCLanguageStandard.CPP20);
    }

    public static boolean supportsConstexprVoid(@Nullable PsiFile file) {
        return OCCompilerFeaturesHelper.supportsLanguageStandard(file, OCLanguageStandard.CPP14);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeaturesHelper";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageStandard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/OCCompilerFeaturesHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureForFile";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureForFileOrNull";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureForContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFeatureEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDiagnosticLevel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isArcDisabled";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isArcEnabled";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "supportsLanguageStandard";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

