/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCExceptionSpecificationInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFakeFunctionSymbolBuilder {
    @NotNull
    private final String myName;
    @NotNull
    private OCType myReturnType;
    @Nullable
    private OCSymbolWithQualifiedName myContainer;
    @NotNull
    private List<Pair<OCType, String>> myParams;
    private boolean myIsConst;
    private boolean myIsCtorOrDtor;
    private int myProperties;
    private int myAttributes;
    @NotNull
    private OCVisibility myVisibility;

    public OCFakeFunctionSymbolBuilder(@NotNull String name) {
        if (name == null) {
            OCFakeFunctionSymbolBuilder.$$$reportNull$$$0(0);
        }
        this.myReturnType = OCVoidType.instance();
        this.myContainer = null;
        this.myParams = new ArrayList<Pair<OCType, String>>();
        this.myIsConst = false;
        this.myIsCtorOrDtor = false;
        this.myProperties = 0;
        this.myAttributes = 0;
        this.myVisibility = OCVisibility.HACK_MORE_VISIBLE_THAN_PUBLIC;
        this.myName = name;
    }

    public OCFakeFunctionSymbolBuilder setReturnType(@NotNull OCType type) {
        if (type == null) {
            OCFakeFunctionSymbolBuilder.$$$reportNull$$$0(1);
        }
        this.myReturnType = type;
        return this;
    }

    public OCFakeFunctionSymbolBuilder setContainer(@Nullable OCSymbolWithQualifiedName container) {
        this.myContainer = container;
        return this;
    }

    public OCFakeFunctionSymbolBuilder setIsExplicit(boolean isExplicit) {
        this.myAttributes = isExplicit ? this.myAttributes | OCSymbolAttribute.EXPLICIT.getMask() : this.myAttributes & ~OCSymbolAttribute.EXPLICIT.getMask();
        return this;
    }

    public OCFakeFunctionSymbolBuilder setIsConsteval(boolean isConsteval) {
        this.myAttributes = isConsteval ? this.myAttributes | OCSymbolAttribute.CONSTEVAL.getMask() : this.myAttributes & ~OCSymbolAttribute.CONSTEVAL.getMask();
        return this;
    }

    public OCFakeFunctionSymbolBuilder addParam(@NotNull OCType type, @NotNull String name) {
        if (type == null) {
            OCFakeFunctionSymbolBuilder.$$$reportNull$$$0(2);
        }
        if (name == null) {
            OCFakeFunctionSymbolBuilder.$$$reportNull$$$0(3);
        }
        this.myParams.add((Pair<OCType, String>)Pair.create((Object)type, (Object)name));
        return this;
    }

    public OCFakeFunctionSymbolBuilder setVisibility(@NotNull OCVisibility visibility) {
        if (visibility == null) {
            OCFakeFunctionSymbolBuilder.$$$reportNull$$$0(4);
        }
        this.myVisibility = visibility;
        return this;
    }

    public OCFakeFunctionSymbolBuilder setIsStatic(boolean isStatic) {
        this.myAttributes = isStatic ? this.myAttributes | OCSymbolAttribute.STATIC.getMask() : this.myAttributes & ~OCSymbolAttribute.STATIC.getMask();
        return this;
    }

    public OCFakeFunctionSymbolBuilder setIsConst(boolean isConst) {
        this.myIsConst = isConst;
        return this;
    }

    public OCFakeFunctionSymbolBuilder setIsCtorOrDtor(boolean isCtorOrDtor) {
        this.myIsCtorOrDtor = isCtorOrDtor;
        return this;
    }

    public OCFakeFunctionSymbolBuilder setIsOverride(boolean isOverride) {
        this.myAttributes = isOverride ? this.myAttributes | OCSymbolAttribute.OVERRIDE.getMask() : this.myAttributes & ~OCSymbolAttribute.OVERRIDE.getMask();
        return this;
    }

    public OCFakeFunctionSymbolBuilder setIsVirtual(boolean isVirtual) {
        this.myAttributes = isVirtual ? this.myAttributes | OCSymbolAttribute.VIRTUAL.getMask() : this.myAttributes & ~OCSymbolAttribute.VIRTUAL.getMask();
        return this;
    }

    public OCFakeFunctionSymbolBuilder setIsFriend(boolean friend) {
        this.myAttributes = friend ? this.myAttributes | OCSymbolAttribute.FRIEND.getMask() : this.myAttributes & ~OCSymbolAttribute.FRIEND.getMask();
        return this;
    }

    public OCFakeFunctionSymbolBuilder setIsOperator(boolean operator) {
        this.myProperties = operator ? this.myProperties | OCFunctionSymbol.Property.IS_OPERATOR.getMask() : this.myProperties & ~OCFunctionSymbol.Property.IS_OPERATOR.getMask();
        return this;
    }

    @NotNull
    public OCFunctionSymbol get() {
        List parameterSymbols = ContainerUtil.map(this.myParams, pair -> new OCDeclaratorSymbolImpl(null, Long.MAX_VALUE, null, OCQualifiedName.interned((String)pair.second), Collections.emptyList(), (OCType)pair.first, OCSymbolKind.PARAMETER, null, Collections.emptyList(), null, OCDeclaratorSymbol.Property.IS_SYNTHETIC.ordinal(), 0, null, null));
        List parameterTypes = ContainerUtil.map(this.myParams, pair -> (OCType)pair.first);
        List parameterNames = ContainerUtil.map(this.myParams, pair -> (String)pair.second);
        OCFunctionType funcType = new OCFunctionType(this.myReturnType, parameterTypes, parameterNames, this.myIsConst, false, false, false, OCExceptionSpecificationInfo.createForNone());
        return new OCFunctionSymbol(null, Long.MAX_VALUE, this.myContainer, OCQualifiedName.interned(this.myName), Collections.emptyList(), null, this.myProperties, this.myAttributes, Collections.emptyList(), funcType, OCTypeUtils.getDefaultValues(false, parameterSymbols), this.myIsCtorOrDtor ? OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION : OCSymbolKind.FUNCTION_DECLARATION, this.myVisibility);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/util/OCFakeFunctionSymbolBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setReturnType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addParam";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setVisibility";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

