/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class OCElementsRange
implements Comparable<OCElementsRange> {
    public static final TokenSet NON_IMPORTANT_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{OCLexerTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET, OCElementTypes.DIRECTIVES, OCLexerTokenTypes.DIRECTIVES, TokenSet.create((IElementType[])new IElementType[]{OCLexerTokenTypes.LBRACE, OCLexerTokenTypes.RBRACE})});
    protected PsiElement myFirstElement;
    protected PsiElement myLastElement;
    protected boolean myContainsCompositeElement;

    public OCElementsRange(@NotNull PsiElement firstElement, @NotNull PsiElement lastElement) {
        if (firstElement == null) {
            OCElementsRange.$$$reportNull$$$0(0);
        }
        if (lastElement == null) {
            OCElementsRange.$$$reportNull$$$0(1);
        }
        this.myFirstElement = firstElement;
        this.myLastElement = lastElement;
    }

    public OCElementsRange(@NotNull OCElementsRange range) {
        if (range == null) {
            OCElementsRange.$$$reportNull$$$0(2);
        }
        this.myFirstElement = range.myFirstElement;
        this.myLastElement = range.myLastElement;
        this.myContainsCompositeElement = range.myContainsCompositeElement;
    }

    @NotNull
    public PsiElement getFirstElement() {
        PsiElement psiElement = this.myFirstElement;
        if (psiElement == null) {
            OCElementsRange.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    public void setFirstElement(@NotNull PsiElement myFirstElement) {
        if (myFirstElement == null) {
            OCElementsRange.$$$reportNull$$$0(4);
        }
        this.myFirstElement = myFirstElement;
    }

    @NotNull
    public PsiElement getLastElement() {
        PsiElement psiElement = this.myLastElement;
        if (psiElement == null) {
            OCElementsRange.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    public void setLastElement(@NotNull PsiElement myLastElement) {
        if (myLastElement == null) {
            OCElementsRange.$$$reportNull$$$0(6);
        }
        this.myLastElement = myLastElement;
    }

    @NotNull
    public TextRange getTextRange() {
        int startOffset = OCElementUtil.getRangeWithMacros(this.myFirstElement).getStartOffset();
        int endOffset = OCElementUtil.getRangeWithMacros(this.myLastElement).getEndOffset();
        if (endOffset < startOffset) {
            endOffset = startOffset;
        }
        return new TextRange(startOffset, endOffset);
    }

    public int getStartOffset() {
        return this.myFirstElement.getTextRange().getStartOffset();
    }

    public int getEndOffset() {
        return this.myLastElement.getTextRange().getEndOffset();
    }

    public String getText() {
        TextRange range = this.getTextRange();
        return range.substring(this.myFirstElement.getContainingFile().getText());
    }

    public PsiFile getFile() {
        return this.myFirstElement.getContainingFile();
    }

    public boolean isValid() {
        return !(this.myFirstElement instanceof OCMacroForeignLeafElement) && !(this.myLastElement instanceof OCMacroForeignLeafElement);
    }

    public boolean containsCompositeElement() {
        return this.myContainsCompositeElement;
    }

    public void setContainsCompositeElement(boolean containsCompositeElement) {
        this.myContainsCompositeElement = containsCompositeElement;
    }

    private OCElementsRange merge(OCElementsRange range) {
        OCElementsRange merged = new OCElementsRange(this.myFirstElement, this.getEndOffset() < range.getEndOffset() ? range.myLastElement : this.myLastElement);
        merged.myContainsCompositeElement = this.myContainsCompositeElement || range.myContainsCompositeElement;
        return merged;
    }

    @Nullable
    public OCElementsRange trim(TokenSet elementsToRemove) {
        PsiElement firstChild = PsiTreeUtil.firstChild((PsiElement)this.myFirstElement);
        PsiElement lastChild = PsiTreeUtil.lastChild((PsiElement)this.myLastElement);
        boolean wasTrimmed = false;
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)firstChild, (PsiElement)lastChild);
        while (firstChild != lastChild && firstChild != null && OCElementsRange.isTrimmedElement(elementsToRemove, firstChild, commonParent)) {
            firstChild = PsiTreeUtil.nextLeaf((PsiElement)firstChild);
            wasTrimmed = true;
        }
        while (firstChild != lastChild && lastChild != null && OCElementsRange.isTrimmedElement(elementsToRemove, lastChild, commonParent)) {
            lastChild = PsiTreeUtil.prevLeaf((PsiElement)lastChild);
            wasTrimmed = true;
        }
        if (firstChild == lastChild && OCElementsRange.isTrimmedElement(elementsToRemove, firstChild, commonParent)) {
            return null;
        }
        if (wasTrimmed && firstChild != null && lastChild != null) {
            return new OCElementsRange(firstChild, lastChild);
        }
        return this;
    }

    private static boolean isEmptyBody(@Nullable PsiElement body) {
        if (body == null) {
            return true;
        }
        TokenSet semicolonAndWhitespace = TokenSet.orSet((TokenSet[])new TokenSet[]{OCLexerTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{OCLexerTokenTypes.SEMICOLON})});
        return OCElementUtil.getElementType(OCElementUtil.getNextLeaf(body.getFirstChild(), semicolonAndWhitespace)) == OCLexerTokenTypes.RBRACE;
    }

    public OCElementsRange expand() {
        TokenSet prevSet = TokenSet.create((IElementType[])new IElementType[]{OCLexerTokenTypes.IF_KEYWORD, OCLexerTokenTypes.WHILE_KEYWORD, OCLexerTokenTypes.DO_KEYWORD, OCLexerTokenTypes.SWITCH_KEYWORD, OCLexerTokenTypes.LPAR});
        OCElementsRange range = this;
        while (true) {
            PsiElement prev = OCElementUtil.getPrevNonWhitespaceCommentLeaf(range.myFirstElement);
            PsiElement next = OCElementUtil.getNextNonWhitespaceCommentLeaf(range.myLastElement);
            PsiElement statement = PsiTreeUtil.getParentOfType((PsiElement)range.myFirstElement, OCStatement.class);
            if (prevSet.contains(OCElementUtil.getElementType(prev)) && (OCElementUtil.getElementType(prev) != OCLexerTokenTypes.LPAR || !(prev.getParent() instanceof OCDoWhileStatement) || OCElementsRange.isEmptyBody(((OCDoWhileStatement)prev.getParent()).getBody())) || OCElementUtil.getElementType(prev) == OCLexerTokenTypes.COLON && prev.getParent() instanceof OCCaseStatement) {
                range = new OCElementsRange(prev.getParent(), prev.getParent());
                range.setContainsCompositeElement(true);
                continue;
            }
            if (statement != null && statement.getFirstChild() == range.myFirstElement && OCElementUtil.getElementType(next) == OCLexerTokenTypes.SEMICOLON) {
                range = new OCElementsRange(range.myFirstElement, next.getParent());
                range.setContainsCompositeElement(true);
                continue;
            }
            if (OCElementUtil.getElementType(prev) == OCLexerTokenTypes.LBRACE && OCElementUtil.getElementType(next) == OCLexerTokenTypes.RBRACE) {
                PsiElement block = prev.getParent();
                if (!(block.getParent() instanceof OCBlockStatement) && !(block.getParent() instanceof OCDoWhileStatement)) break;
                range = new OCElementsRange(block, block);
                range.setContainsCompositeElement(true);
                continue;
            }
            PsiElement parent = range.myFirstElement.getParent();
            PsiElement grParent = parent.getParent();
            if (grParent instanceof OCCondition) {
                parent = grParent;
                grParent = grParent.getParent();
            }
            if (!(parent instanceof OCCondition) || !(grParent instanceof OCForStatement)) break;
            range = new OCElementsRange(grParent, grParent);
        }
        return range;
    }

    private static OCElementsRange extractLoopCondition(OCElementsRange range) {
        PsiElement psiElement = range.myFirstElement;
        if (psiElement instanceof OCLoopStatement) {
            OCLoopStatement loop = (OCLoopStatement)psiElement;
            if (range.myFirstElement == range.myLastElement) {
                ASTNode first;
                ASTNode parenth = loop.getRParenth();
                ASTNode aSTNode = first = loop instanceof OCDoWhileStatement ? ((OCDoWhileStatement)loop).getWhileKeyword() : loop.getFirstChild().getNode();
                if (first != null && parenth != null) {
                    return new OCElementsRange(first.getPsi(), parenth.getPsi());
                }
            }
        }
        return range;
    }

    public static List<OCElementsRange> mergeRanges(@Unmodifiable List<? extends OCElementsRange> ranges, boolean trim, boolean extractLoopCondition) {
        ArrayList<OCElementsRange> resultRanges = new ArrayList<OCElementsRange>();
        OCElementsRange curRange = null;
        TokenSet trimSet = NON_IMPORTANT_TOKENS;
        for (OCElementsRange range : ContainerUtil.sorted(ranges)) {
            PsiElement nextLeaf;
            if (range == null) continue;
            PsiElement psiElement = nextLeaf = curRange != null ? OCElementUtil.getNextNonWhitespaceCommentLeaf(curRange.myLastElement) : null;
            if (nextLeaf != null && nextLeaf.getTextOffset() >= range.getStartOffset() && nextLeaf.getContainingFile() == range.myFirstElement.getContainingFile()) {
                curRange = curRange.merge(range).expand();
                continue;
            }
            if (curRange != null && curRange.isValid() && curRange.containsCompositeElement()) {
                OCElementsRange trimmed;
                OCElementsRange oCElementsRange = trimmed = trim ? curRange.trim(trimSet) : curRange;
                if (trimmed != null) {
                    trimmed = trimmed.expand();
                    resultRanges.add(extractLoopCondition ? OCElementsRange.extractLoopCondition(trimmed) : trimmed);
                }
            }
            curRange = new OCElementsRange(range);
        }
        if (curRange != null && curRange.isValid() && curRange.containsCompositeElement()) {
            OCElementsRange trimmed;
            OCElementsRange oCElementsRange = trimmed = trim ? curRange.trim(trimSet) : curRange;
            if (trimmed != null) {
                trimmed = trimmed.expand();
                resultRanges.add(extractLoopCondition ? OCElementsRange.extractLoopCondition(trimmed) : trimmed);
            }
        }
        return resultRanges;
    }

    private static boolean isTrimmedElement(TokenSet elementsToRemove, PsiElement element, PsiElement commonParent) {
        while (element != commonParent) {
            if (elementsToRemove.contains(OCElementUtil.getElementType(element))) {
                return true;
            }
            element = element.getParent();
        }
        return false;
    }

    public boolean isEmpty() {
        PsiElement curElement = this.myFirstElement;
        while (curElement != null && curElement.getTextRange().getStartOffset() < this.myLastElement.getTextRange().getEndOffset()) {
            IElementType elementType = OCElementUtil.getElementType(curElement);
            if (elementType != OCLexerTokenTypes.LBRACE && elementType != OCLexerTokenTypes.RBRACE && !OCElementUtil.isElementEmpty(curElement)) {
                return false;
            }
            curElement = PsiTreeUtil.nextLeaf((PsiElement)curElement, (boolean)true);
        }
        return true;
    }

    @Override
    public int compareTo(OCElementsRange o) {
        if (this.myFirstElement.getContainingFile() != o.myFirstElement.getContainingFile()) {
            String path1 = this.myFirstElement.getContainingFile().getVirtualFile().getPath();
            String path2 = o.myFirstElement.getContainingFile().getVirtualFile().getPath();
            return path1.compareTo(path2);
        }
        return this.getStartOffset() - o.getStartOffset();
    }

    public Iterable<PsiElement> getElements() {
        return new Iterable<PsiElement>(){

            @Override
            public Iterator<PsiElement> iterator() {
                return new Iterator<PsiElement>(){
                    PsiElement nextElem;
                    {
                        this.nextElem = OCElementsRange.this.myFirstElement;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextElem != null;
                    }

                    @Override
                    public PsiElement next() {
                        ASTNode next;
                        PsiElement curElem = this.nextElem;
                        if (this.nextElem == null) {
                            throw new NoSuchElementException();
                        }
                        this.nextElem = this.nextElem != OCElementsRange.this.myLastElement ? ((next = this.nextElem.getNode().getTreeNext()) != null ? next.getPsi() : null) : null;
                        return curElem;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/util/OCElementsRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myFirstElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myLastElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/util/OCElementsRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFirstElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setLastElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

