/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCDeductionCandidateSymbol;
import com.jetbrains.cidr.lang.resolve.OCTypeArgumentsProcessor;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCUnknownExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSimpleTypeSubstitution
extends OCTypeSubstitution {
    @NotNull
    private Map<OCTypeParameterSymbol, OCTypeArgument> mySubstitutions;

    public OCSimpleTypeSubstitution() {
    }

    OCSimpleTypeSubstitution(@NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutions) {
        if (substitutions == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(0);
        }
        this.mySubstitutions = substitutions;
    }

    @NotNull
    public Map<OCTypeParameterSymbol, OCTypeArgument> getSubstitutions() {
        Map<OCTypeParameterSymbol, OCTypeArgument> map2 = this.mySubstitutions;
        if (map2 == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(1);
        }
        return map2;
    }

    public static OCSimpleTypeSubstitution create(@NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutions) {
        if (substitutions == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(2);
        }
        return substitutions.isEmpty() ? ID : new OCSimpleTypeSubstitution(new HashMap<OCTypeParameterSymbol, OCTypeArgument>(substitutions));
    }

    @Override
    public boolean hasSubstitutionForName(@NotNull String name) {
        if (name == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(3);
        }
        for (OCTypeParameterSymbol symbol : this.getTypeParameters()) {
            if (!name.equals(symbol.getName())) continue;
            return true;
        }
        return false;
    }

    public Set<OCTypeParameterSymbol> getTypeParameters() {
        return this.mySubstitutions.keySet();
    }

    @Override
    public Collection<OCTypeArgument> getSubstitutedTypes() {
        return this.mySubstitutions.values();
    }

    @Override
    public boolean processSubstitutions(Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>> processor2) {
        return ContainerUtil.process(this.mySubstitutions.entrySet(), processor2);
    }

    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(4);
        }
        if (first == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(5);
        }
        if (second == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(6);
        }
        OCSimpleTypeSubstitution f = (OCSimpleTypeSubstitution)first;
        OCSimpleTypeSubstitution s = (OCSimpleTypeSubstitution)second;
        return c.equalMaps(f.mySubstitutions, s.mySubstitutions);
    }

    @Override
    public OCType substitute(@NotNull OCType type, final boolean overwriteSubstitution, final @NotNull OCResolveContext context) {
        if (type == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(7);
        }
        if (context == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(8);
        }
        if (this != ID) {
            return type.transformType(new OCTypeSubstitution.TypeSubstituteVisitor(this, overwriteSubstitution, context){

                @Override
                public OCType visitTypeParameterType(OCTypeParameterType type) {
                    OCTypeArgument arg = OCSimpleTypeSubstitution.this.mySubstitutions.get(type.getSymbol());
                    if (arg != null) {
                        if (arg instanceof OCType) {
                            OCType result = (OCType)arg;
                            if (arg instanceof OCReferenceType) {
                                result = OCTypeSubstitution.substituteReferenceType((OCReferenceType)arg, OCSimpleTypeSubstitution.this, overwriteSubstitution, context);
                            }
                            return result.cloneWithAddedCVQualifiers(type.getCVQualifiers(), context.getProjectOrNull());
                        }
                        return new OCMagicType(arg.getNameForPresentation(OCType.Presentation.FULL, context, true, 0));
                    }
                    return type;
                }
            });
        }
        return type;
    }

    public static List<OCTemplateSymbol> resolveTemplateSpecialization(@NotNull List<OCTemplateSymbol> symbols, List<OCTypeArgument> arguments, @NotNull OCResolveContext resolver) {
        OCTemplateSymbol substituted;
        Ref count;
        if (symbols == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(9);
        }
        if (resolver == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(10);
        }
        if (symbols.isEmpty()) {
            return symbols;
        }
        ArrayList<OCTemplateSymbol> qualifiedContainers = new ArrayList<OCTemplateSymbol>();
        ArrayList<OCTemplateSymbol> predefinitions = new ArrayList<OCTemplateSymbol>();
        ArrayList<OCTemplateSymbol> nonSpecialized = new ArrayList<OCTemplateSymbol>();
        ArrayList<OCTemplateSymbol> specialized = new ArrayList<OCTemplateSymbol>();
        ArrayList<OCTemplateSymbol> result = new ArrayList<OCTemplateSymbol>();
        OCSimpleTypeSubstitution.divideSymbols(symbols, qualifiedContainers, predefinitions, nonSpecialized, specialized);
        arguments = OCArgumentsList.expandVariadicTypes(arguments, resolver);
        List resolvedArguments = ContainerUtil.map(arguments, argument -> OCSimpleTypeSubstitution.resolveTypeArgument(resolver, Collections.emptyMap(), argument));
        boolean dependentType = OCSimpleTypeSubstitution.isDependentType(resolvedArguments, resolver);
        if (symbols.size() == 1) {
            OCTemplateSymbol symbol = symbols.get(0);
            Ref count2 = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
            OCTemplateSymbol substituted2 = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(symbol, specialized.isEmpty() ? symbol : null, null, resolvedArguments, resolver, (Ref<OCTypeUnificationVisitor.UnificationResult>)count2);
            if (count2.get() != OCTypeUnificationVisitor.NOT_UNIFIED || symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor()) {
                result.add(substituted2);
            }
            return result;
        }
        if (!specialized.isEmpty()) {
            OCTemplateSymbol bestSpecialization = null;
            OCTypeUnificationVisitor.UnificationResult bestSpecializationCount = OCTypeUnificationVisitor.NOT_UNIFIED;
            for (OCTemplateSymbol symbol : specialized) {
                Ref count3 = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
                OCTemplateSymbol baseSymbol = null;
                if (nonSpecialized.size() == 1) {
                    baseSymbol = nonSpecialized.get(0);
                } else if (predefinitions.size() == 1) {
                    baseSymbol = predefinitions.get(0);
                }
                if (symbol instanceof OCFunctionSymbol && !(baseSymbol instanceof OCFunctionSymbol)) {
                    baseSymbol = null;
                }
                OCTemplateSymbol substituted3 = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(symbol, baseSymbol, null, resolvedArguments, resolver, (Ref<OCTypeUnificationVisitor.UnificationResult>)count3);
                if (!dependentType) {
                    if (symbol instanceof OCFunctionSymbol) {
                        if (((OCTypeUnificationVisitor.UnificationResult)count3.get()).isBetter(bestSpecializationCount)) {
                            result.clear();
                            result.add(symbol);
                        } else if (!bestSpecializationCount.isBetter((OCTypeUnificationVisitor.UnificationResult)count3.get()) && count3.get() != OCTypeUnificationVisitor.NOT_UNIFIED) {
                            result.add(symbol);
                        }
                    }
                    if (!((OCTypeUnificationVisitor.UnificationResult)count3.get()).isBetter(bestSpecializationCount)) continue;
                    bestSpecialization = substituted3;
                    bestSpecializationCount = (OCTypeUnificationVisitor.UnificationResult)count3.get();
                    continue;
                }
                if (count3.get() == OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                result.add(substituted3);
            }
            if (!dependentType && bestSpecialization != null && !(bestSpecialization instanceof OCFunctionSymbol)) {
                result.add(bestSpecialization);
            }
        }
        if (result.isEmpty() || dependentType || resolver.isIncompleteMode() && arguments.isEmpty()) {
            for (OCTemplateSymbol symbol : nonSpecialized) {
                count = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
                substituted = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(symbol, symbol, null, resolvedArguments, resolver, (Ref<OCTypeUnificationVisitor.UnificationResult>)count);
                if (count.get() == OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                if (dependentType) {
                    result.add(0, substituted);
                    continue;
                }
                result.add(substituted);
            }
        }
        if (result.isEmpty()) {
            for (OCTemplateSymbol symbol : predefinitions) {
                count = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
                substituted = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(symbol, symbol, null, resolvedArguments, resolver, (Ref<OCTypeUnificationVisitor.UnificationResult>)count);
                if (count.get() == OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                if (nonSpecialized.size() == 1) {
                    count = new Ref((Object)OCTypeUnificationVisitor.UNKNOWN);
                    substituted = OCSimpleTypeSubstitution.applyArgumentsToTemplateSymbol(nonSpecialized.get(0), nonSpecialized.get(0), substituted, resolvedArguments, resolver, (Ref<OCTypeUnificationVisitor.UnificationResult>)count);
                    if (count.get() == OCTypeUnificationVisitor.NOT_UNIFIED) continue;
                    result.add(substituted);
                    continue;
                }
                result.add(substituted);
            }
        }
        result.addAll(qualifiedContainers);
        return result;
    }

    protected static void divideSymbols(@NotNull List<OCTemplateSymbol> symbols, @NotNull List<OCTemplateSymbol> qualifiedContainers, @NotNull List<OCTemplateSymbol> predefinitions, @NotNull List<OCTemplateSymbol> nonSpecialized, @NotNull List<OCTemplateSymbol> specialized) {
        if (symbols == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(11);
        }
        if (qualifiedContainers == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(12);
        }
        if (predefinitions == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(13);
        }
        if (nonSpecialized == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(14);
        }
        if (specialized == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(15);
        }
        for (OCTemplateSymbol symbol : symbols) {
            if (symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).isQualifiedContainer()) {
                qualifiedContainers.add(symbol);
                continue;
            }
            if (symbol instanceof OCStructSymbol && symbol.isPredeclaration()) {
                predefinitions.add(symbol);
                continue;
            }
            if (symbol.getTemplateSpecialization() != null) {
                specialized.add(symbol);
                continue;
            }
            nonSpecialized.add(symbol);
        }
    }

    private static boolean isDependentType(@NotNull List<OCTypeArgument> arguments, @NotNull OCResolveContext resolver) {
        if (arguments == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(16);
        }
        if (resolver == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(17);
        }
        boolean dependentType = false;
        for (OCTypeArgument argument : arguments) {
            if (argument instanceof OCCppReferenceType) {
                argument = ((OCCppReferenceType)argument).getRefType();
            }
            if (argument instanceof OCStructType) {
                if (((OCStructType)argument).getStructs().size() <= 1) continue;
                dependentType = true;
                continue;
            }
            if (!(argument instanceof OCMagicType) && (!(argument instanceof OCVariadicType) || !(((OCVariadicType)argument).getUnderlyingType() instanceof OCTypeParameterType)) && (!(argument instanceof OCExpressionTypeArgument) || OCExpressionEvaluator.evaluate(((OCExpressionTypeArgument)argument).getSymbol(), resolver) != null)) continue;
            dependentType = true;
            if (!(argument instanceof OCTypeParameterType)) continue;
            resolver.addTypeDependency(((OCTypeParameterType)argument).getSymbol());
        }
        return dependentType;
    }

    @Override
    public OCTypeArgument getSubstitutionFor(@NotNull OCTypeParameterSymbol param) {
        if (param == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(18);
        }
        return this.mySubstitutions.get(param);
    }

    private static OCTemplateSymbol applyArgumentsToTemplateSymbol(@NotNull OCTemplateSymbol symbol, @Nullable OCTemplateSymbol baseSymbol, @Nullable OCTemplateSymbol predefinition, @NotNull List<OCTypeArgument> resolvedArguments, @NotNull OCResolveContext resolver, @NotNull Ref<OCTypeUnificationVisitor.UnificationResult> specializationCount) {
        if (symbol == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(19);
        }
        if (resolvedArguments == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(20);
        }
        if (resolver == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(21);
        }
        if (specializationCount == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(22);
        }
        Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap = OCTypeUtils.newTypeParameterMap();
        List<OCTypeArgument> specialization = symbol.getTemplateSpecialization();
        int resolvedArgumentsCnt = resolvedArguments.size();
        boolean isNonExpandedVariadic = false;
        if (resolvedArgumentsCnt > 0 && ContainerUtil.getLastItem(resolvedArguments) instanceof OCVariadicType) {
            --resolvedArgumentsCnt;
            isNonExpandedVariadic = true;
        }
        if (!(specialization != null && specialization.size() >= resolvedArgumentsCnt || symbol.isVariadicTemplate() || baseSymbol != null && baseSymbol.getTemplateParameters().size() >= resolvedArgumentsCnt && !baseSymbol.isVariadicTemplate())) {
            specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
            return symbol;
        }
        if (specialization != null) {
            OCResolveContext paramResolveContext = resolver.clearSubstitution();
            paramResolveContext.setDontExpandVariadics(true);
            if (!OCTypeArgumentsProcessor.processArguments(specialization, resolvedArguments, (Function<OCTypeArgument, OCTypeArgument>)((Function)typeArgument -> OCSimpleTypeSubstitution.resolveTypeArgument(paramResolveContext, substitutionMap, typeArgument)), false, (parameter, argument) -> {
                if (parameter instanceof OCType && ((OCType)parameter).isUnresolved(paramResolveContext)) {
                    specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
                    return false;
                }
                if (argument != null) {
                    if (OCSimpleTypeSubstitution.incompatibleArgument(parameter, argument, substitutionMap, resolver)) {
                        specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
                        return false;
                    }
                    OCTypeUnificationVisitor.UnificationResult result = OCSimpleTypeSubstitution.unify(parameter, argument, substitutionMap, resolver);
                    specializationCount.set((Object)((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).add(result));
                    if (parameter instanceof OCMagicType) {
                        ((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).incNumOfNonSpecializedArgs();
                    }
                    if (specializationCount.get() == OCTypeUnificationVisitor.NOT_UNIFIED) {
                        return false;
                    }
                }
                return true;
            })) {
                return symbol;
            }
        }
        if (baseSymbol != null) {
            OCTypeArgument argument2;
            OCTypeParameterSymbol parameterSymbol;
            List<OCTypeParameterSymbol> parameters = baseSymbol.getTemplateParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                parameterSymbol = parameters.get(i);
                Object defaultValue = parameterSymbol.getDefaultValue();
                OCTypeArgument parameter2 = new OCTypeParameterType(parameterSymbol);
                if (specialization != null && i >= specialization.size() && !(ContainerUtil.getLastItem(specialization) instanceof OCVariadicType) && defaultValue != null) {
                    parameter2 = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, substitutionMap, defaultValue);
                }
                if (parameterSymbol.isVariadic()) break;
                if (i < resolvedArgumentsCnt) {
                    argument2 = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, substitutionMap, resolvedArguments.get(i));
                } else if (predefinition != null) {
                    List<OCTypeParameterSymbol> predefParameters = predefinition.getTemplateParameters();
                    OCTypeArgument oCTypeArgument = argument2 = predefParameters.size() > i ? predefinition.getSubstitution().getSubstitutionFor(predefParameters.get(i)) : null;
                    if (argument2 == null) {
                        specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
                        return symbol;
                    }
                } else {
                    if (defaultValue == null) {
                        if (!(baseSymbol instanceof OCStructSymbol) || isNonExpandedVariadic) break;
                        specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
                        return symbol;
                    }
                    argument2 = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, substitutionMap, defaultValue);
                    if (specialization != null && i < specialization.size()) {
                        OCTypeArgument specializationParameter = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, substitutionMap, specialization.get(i));
                        OCTypeUnificationVisitor.UnificationResult result = OCSimpleTypeSubstitution.unify(specializationParameter, argument2, substitutionMap, resolver);
                        specializationCount.set((Object)((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).add(result));
                        if (specializationParameter instanceof OCMagicType) {
                            ((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).incNumOfNonSpecializedArgs();
                        }
                    }
                }
                OCSimpleTypeSubstitution.unifyArgument(parameter2, argument2, parameterSymbol, substitutionMap, resolver, specializationCount);
            }
            if (baseSymbol.isVariadicTemplate()) {
                int variadicParamIndex;
                for (variadicParamIndex = parameters.size() - 1; variadicParamIndex > 0 && parameters.get(variadicParamIndex - 1).isVariadic(); --variadicParamIndex) {
                }
                parameterSymbol = parameters.get(variadicParamIndex);
                if (!(symbol instanceof OCFunctionSymbol)) {
                    substitutionMap.put(parameterSymbol, new OCExpansionPackType());
                }
                OCTypeParameterType parameter3 = new OCTypeParameterType(parameterSymbol);
                for (int i = variadicParamIndex; i < resolvedArguments.size(); ++i) {
                    argument2 = OCSimpleTypeSubstitution.resolveTypeArgument(resolver, substitutionMap, resolvedArguments.get(i));
                    OCSimpleTypeSubstitution.unifyArgument(parameter3, argument2, parameterSymbol, substitutionMap, resolver, specializationCount);
                }
                if (specialization != null) {
                    int specializationsRequiredCnt = specialization.size();
                    OCTypeArgument lastArgument = (OCTypeArgument)ContainerUtil.getLastItem(specialization);
                    if (lastArgument != null && lastArgument.isVariadic()) {
                        --specializationsRequiredCnt;
                    }
                    if (resolvedArgumentsCnt < specializationsRequiredCnt && !isNonExpandedVariadic) {
                        specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
                        return symbol;
                    }
                }
            }
        }
        OCTypeSubstitution minimalSubstitution = resolver.getSubstitution().getMinimalDependentSubstitution(resolvedArguments, resolver);
        return OCSimpleTypeSubstitution.compose(OCSimpleTypeSubstitution.create(substitutionMap), minimalSubstitution, false).substitute(symbol, null, true, resolver);
    }

    private static void unifyArgument(@NotNull OCTypeArgument parameter, @NotNull OCTypeArgument argument, @NotNull OCTypeParameterSymbol parameterSymbol, @NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @NotNull OCResolveContext resolver, @NotNull Ref<OCTypeUnificationVisitor.UnificationResult> specializationCount) {
        if (parameter == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(23);
        }
        if (argument == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(24);
        }
        if (parameterSymbol == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(25);
        }
        if (substitutionMap == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(26);
        }
        if (resolver == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(27);
        }
        if (specializationCount == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(28);
        }
        OCTypeUnificationVisitor.UnificationResult result = OCSimpleTypeSubstitution.unify(parameter, argument, substitutionMap, resolver);
        OCTypeArgument substitutionResult = substitutionMap.get(parameterSymbol);
        if (substitutionResult instanceof OCType && ((OCType)substitutionResult).isUnresolved(resolver)) {
            specializationCount.set((Object)OCTypeUnificationVisitor.NOT_UNIFIED);
        } else {
            specializationCount.set((Object)((OCTypeUnificationVisitor.UnificationResult)specializationCount.get()).add(result));
        }
    }

    private static boolean incompatibleArgument(@NotNull OCTypeArgument specializationParam, @NotNull OCTypeArgument argument, @NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @NotNull OCResolveContext resolver) {
        if (specializationParam == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(29);
        }
        if (argument == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(30);
        }
        if (substitutionMap == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(31);
        }
        if (resolver == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(32);
        }
        resolver = resolver.substitute(OCSimpleTypeSubstitution.create(substitutionMap));
        if (specializationParam instanceof OCReferenceType) {
            OCReferenceType specializationType = (OCReferenceType)specializationParam;
            if (argument instanceof OCStructType) {
                boolean isStruct;
                OCStructType argumentType = (OCStructType)argument;
                List<OCSymbol> specializationSymbols = specializationType.getReference(resolver).resolveToSymbols(true, true, false, resolver);
                boolean bl = isStruct = ContainerUtil.findInstance(specializationSymbols, OCStructSymbol.class) != null;
                if (isStruct && !specializationSymbols.contains(argumentType.getSymbol())) {
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    protected static OCTypeArgument resolveTypeArgument(@NotNull OCResolveContext resolver, Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @NotNull OCTypeArgument argument) {
        if (resolver == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(33);
        }
        if (argument == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(34);
        }
        return OCSimpleTypeSubstitution.resolveTypeArgument(argument, resolver.useFor(argument, OCSimpleTypeSubstitution.create(substitutionMap)));
    }

    @NotNull
    public static OCTypeArgument resolveTypeArgument(@NotNull OCTypeArgument argument, @NotNull OCResolveContext context) {
        OCExpressionSymbol expressionSymbol;
        OCTypeArgument value;
        if (argument == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(35);
        }
        if (context == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(36);
        }
        if (argument instanceof OCReferenceType) {
            Object prevValue = null;
            for (OCSymbol symbol : context.resolveToSymbols(((OCReferenceType)argument).getReference(context))) {
                Object value2 = OCExpressionEvaluator.evaluate(symbol, context);
                if (value2 == null) {
                    prevValue = null;
                    break;
                }
                if (prevValue != null && !value2.equals(prevValue)) {
                    return new OCExpressionTypeArgument(new OCUnknownExpressionSymbol(null, 0L));
                }
                prevValue = value2;
            }
            if (prevValue != null) {
                return new OCExpressionTypeArgument(new OCLiteralExpressionSymbol(prevValue, null, null));
            }
        }
        if (argument instanceof OCType) {
            argument = ((OCType)argument).transformType(new OCTypeResolveVisitor(context));
        } else if (argument instanceof OCExpressionTypeArgument && (value = (expressionSymbol = ((OCExpressionTypeArgument)argument).getSymbol()).evaluateToTypeArgument(context)) != null) {
            OCTypeArgument oCTypeArgument = value;
            if (oCTypeArgument == null) {
                OCSimpleTypeSubstitution.$$$reportNull$$$0(37);
            }
            return oCTypeArgument;
        }
        OCTypeArgument oCTypeArgument = argument;
        if (oCTypeArgument == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(38);
        }
        return oCTypeArgument;
    }

    public static OCTypeUnificationVisitor.UnificationResult unify(@NotNull OCTypeArgument parameter, @NotNull OCTypeArgument argument, @NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @NotNull OCResolveContext context) {
        if (parameter == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(39);
        }
        if (argument == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(40);
        }
        if (substitutionMap == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(41);
        }
        if (context == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(42);
        }
        return OCSimpleTypeSubstitution.unify(parameter, argument, null, substitutionMap, null, false, false, context);
    }

    public static OCTypeUnificationVisitor.UnificationResult unify(@NotNull OCTypeArgument parameter, @NotNull OCTypeArgument argument, @Nullable OCTypeOwner expression, @NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @Nullable Set<OCTypeParameterSymbol> dependentTypes, boolean functionParametersMode, boolean isVariadicMode, @NotNull OCResolveContext context) {
        if (parameter == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(43);
        }
        if (argument == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(44);
        }
        if (substitutionMap == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(45);
        }
        if (context == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(46);
        }
        return new OCTypeUnificationVisitor(functionParametersMode, true, isVariadicMode, true, false, argument, expression, substitutionMap, dependentTypes, context).unify(parameter, argument);
    }

    public static OCTypeUnificationVisitor.UnificationResult unifyByFunctionArgument(@Nullable OCFunctionSymbol function, @NotNull OCTypeArgument parameter, @NotNull OCTypeArgument argument, @Nullable OCTypeOwner expression, @NotNull Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap, @Nullable Set<OCTypeParameterSymbol> dependentTypes, boolean isVariadicMode, @NotNull OCResolveContext context) {
        if (parameter == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(47);
        }
        if (argument == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(48);
        }
        if (substitutionMap == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(49);
        }
        if (context == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(50);
        }
        OCTypeUnificationVisitor visitor = new OCTypeUnificationVisitor(true, true, isVariadicMode, true, false, argument, expression, substitutionMap, dependentTypes, context);
        if (function != null && !function.isFriend()) {
            visitor.setUnifiableTypeParameters(new HashSet<OCTypeParameterSymbol>(function.getTemplateParameters()));
            if (function instanceof OCDeductionCandidateSymbol) {
                visitor.setCTADParameters(new HashSet<OCTypeParameterSymbol>(((OCDeductionCandidateSymbol)function).getCTADParameters()));
            }
        }
        return visitor.unify(parameter, argument);
    }

    @NotNull
    String substList() {
        Map<OCTypeParameterSymbol, OCTypeArgument> substitutions = this.mySubstitutions;
        Function converter = entry -> {
            Object valueString;
            String keyString = ((OCTypeParameterSymbol)entry.getKey()).toString();
            keyString = keyString.substring(keyString.indexOf(91));
            OCTypeArgument value = (OCTypeArgument)entry.getValue();
            if (value instanceof OCTypeParameterType) {
                valueString = ((OCTypeParameterType)value).getSymbol().toString();
                valueString = "<param>" + ((String)valueString).substring(((String)valueString).indexOf(91));
            } else if (value instanceof OCExpressionTypeArgument) {
                valueString = ((OCExpressionTypeArgument)value).getSymbol().toString();
                valueString = "<value>" + ((String)valueString).substring(((String)valueString).indexOf(91));
            } else {
                valueString = value.toString();
            }
            return keyString + " -> " + (String)valueString;
        };
        String string = StringUtil.join((Collection)ContainerUtil.map(substitutions.entrySet(), (Function)converter), (String)", ");
        if (string == null) {
            OCSimpleTypeSubstitution.$$$reportNull$$$0(51);
        }
        return string;
    }

    public String toString() {
        return "{" + this.substList() + "}";
    }

    public int hashCode() {
        return this.mySubstitutions.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 37, 38, 51 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutions";
                break;
            }
            case 1: 
            case 37: 
            case 38: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 36: 
            case 42: 
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
            case 10: 
            case 17: 
            case 21: 
            case 27: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedContainers";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinitions";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonSpecialized";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specialized";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedArguments";
                break;
            }
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specializationCount";
                break;
            }
            case 23: 
            case 39: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 24: 
            case 30: 
            case 34: 
            case 35: 
            case 40: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterSymbol";
                break;
            }
            case 26: 
            case 31: 
            case 41: 
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutionMap";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specializationParam";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/visitors/OCSimpleTypeSubstitution";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutions";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTypeArgument";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "substList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 37: 
            case 38: 
            case 51: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasSubstitutionForName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveTemplateSpecialization";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "divideSymbols";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isDependentType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutionFor";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "applyArgumentsToTemplateSymbol";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "unifyArgument";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "incompatibleArgument";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeArgument";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "unify";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "unifyByFunctionArgument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 37, 38, 51 -> new IllegalStateException(string);
        };
    }
}

