/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.IJTracer;
import com.intellij.platform.diagnostic.telemetry.Scope;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCInitialBuildingInfo;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTableBuildingUtil;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingMode;
import io.opentelemetry.api.trace.SpanBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class OCSymbolLoadingActivity {
    static void build(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull OCInitialBuildingInfo userData) {
        Project project;
        if (indicator == null) {
            OCSymbolLoadingActivity.$$$reportNull$$$0(0);
        }
        if (userData == null) {
            OCSymbolLoadingActivity.$$$reportNull$$$0(1);
        }
        if ((project = userData.getProject()).isDisposed()) {
            return;
        }
        indicator.setText(OCBundle.message("symbol.table.activity.loading.symbols", new Object[0]));
        indicator.startTiming("Loading symbols");
        Collection<VirtualFile> allFiles = Objects.requireNonNull(userData.getAllFiles());
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project);
        long loadedFileCount = 0L;
        if (userData.getMode() != OCSymbolTablesBuildingMode.FULL) {
            IJTracer tracer = TelemetryManager.getInstance().getTracer(new Scope("symbols"));
            loadedFileCount = (Long)TraceKt.use((SpanBuilder)tracer.spanBuilder("OCSymbolLoadingActivity"), __ -> cache.deserializeTables(Objects.requireNonNull(userData.getLocationHash()), allFiles, (ProgressIndicator)indicator, 0.25));
        }
        userData.setLoadedFraction(indicator.getFraction());
        userData.setSavingFraction(1.0 - 0.1 * (double)((long)allFiles.size() - loadedFileCount) / (double)Math.max(1, allFiles.size()));
        OCLog.LOG.info("Loaded " + OCSymbolLoadingActivity.getAllTablesCount(cache) + " tables for " + cache.getCachedFiles().size() + " files (" + loadedFileCount + " project files)");
        indicator.logTiming();
    }

    @NotNull
    public static Collection<VirtualFile> getFilesToBuildCachesForSafely(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            OCSymbolLoadingActivity.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            OCSymbolLoadingActivity.$$$reportNull$$$0(3);
        }
        Collection collection = OCSymbolTableBuildingUtil.runCancelableReadAction(project, indicator, () -> {
            if (project.isDisposed()) {
                return Collections.emptyList();
            }
            return FileSymbolTablesCache.getInstance(project).getFilesToBuildTablesFor();
        });
        if (collection == null) {
            OCSymbolLoadingActivity.$$$reportNull$$$0(4);
        }
        return collection;
    }

    static int getAllTablesCount(@NotNull FileSymbolTablesCache cache) {
        if (cache == null) {
            OCSymbolLoadingActivity.$$$reportNull$$$0(5);
        }
        Set<VirtualFile> files = cache.getCachedFiles();
        return OCSymbolLoadingActivity.getAllTablesCount(cache, files);
    }

    static int getAllTablesCount(@NotNull FileSymbolTablesCache cache, @NotNull Set<VirtualFile> files) {
        if (cache == null) {
            OCSymbolLoadingActivity.$$$reportNull$$$0(6);
        }
        if (files == null) {
            OCSymbolLoadingActivity.$$$reportNull$$$0(7);
        }
        int result = 0;
        for (VirtualFile file : files) {
            result += cache.allTablesForFileCount(file);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/building/OCSymbolLoadingActivity";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/building/OCSymbolLoadingActivity";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToBuildCachesForSafely";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToBuildCachesForSafely";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllTablesCount";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

