/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.symtable.ConsumedTokenRange;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCParserRollbacksDebugHighlightingPass
extends TextEditorHighlightingPass {
    private List<HighlightInfo> myInfos;

    private OCParserRollbacksDebugHighlightingPass(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            OCParserRollbacksDebugHighlightingPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            OCParserRollbacksDebugHighlightingPass.$$$reportNull$$$0(1);
        }
        super(project, document);
        this.myInfos = null;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            OCParserRollbacksDebugHighlightingPass.$$$reportNull$$$0(2);
        }
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(this.myProject);
        if (!Registry.is((String)"cidr.debug.show.parser.rollbacks") || !cache.areSymbolsLoaded()) {
            return;
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.getDocument());
        if (!(file instanceof OCFile)) {
            return;
        }
        cache.ensurePendingFilesProcessed();
        List<FileSymbolTable> allTables = cache.allTablesForFile(file);
        if (allTables.isEmpty()) {
            return;
        }
        List<ConsumedTokenRange> count = allTables.get(0).getConsumedTokenRanges();
        if (count != null) {
            for (ConsumedTokenRange token : count) {
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(token.begin, token.end).textAttributes(new TextAttributes(null, OCParserRollbacksDebugHighlightingPass.getBackgroundColor(token.getConsumedCount()), null, null, 0)).create();
                if (info == null) continue;
                infos.add(info);
            }
        }
        this.myInfos = infos;
    }

    public void doApplyInformationToEditor() {
        if (this.myInfos == null) {
            return;
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myDocument.getTextLength(), this.myInfos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    @Nullable
    private static Color getBackgroundColor(int count) {
        if (count <= 0) {
            return Color.GREEN;
        }
        if (count == 1) {
            return null;
        }
        int numTones = 5;
        int lightness = Math.max(0, 255 - 255 / (numTones + 1) * (count - 1));
        return new Color(255, lightness, lightness);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCParserRollbacksDebugHighlightingPass";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doCollectInformation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Factory
    implements TextEditorHighlightingPassFactory,
    TextEditorHighlightingPassFactoryRegistrar {
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
            if (registrar == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (project == null) {
                Factory.$$$reportNull$$$0(1);
            }
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, true, -1);
        }

        @Nullable
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile psiFile, @NotNull Editor editor) {
            if (psiFile == null) {
                Factory.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                Factory.$$$reportNull$$$0(3);
            }
            if (!LanguageUtils.getInstance().isSupportedFile(psiFile)) {
                return null;
            }
            return new OCParserRollbacksDebugHighlightingPass(psiFile.getProject(), editor.getDocument());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "registrar";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCParserRollbacksDebugHighlightingPass$Factory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerHighlightingPassFactory";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createHighlightingPass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

