/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.symtable.EmptySymbolTableProvider;
import com.jetbrains.cidr.lang.symbols.symtable.FileContentSnapshot;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableProvider;
import com.jetbrains.cidr.lang.symbols.symtable.FileToBuildSymbolsCollector;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r\u001a\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\"\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u001d8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001d8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00180!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"isSourceFile", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "getFileText", "", "calculateTable", "Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTable;", "context", "Lcom/jetbrains/cidr/lang/preprocessor/OCInclusionContext;", "calculateTableUsingPSI", "Lcom/jetbrains/cidr/lang/psi/OCFile;", "isOutOfCodeBlockChange", "event", "Lcom/intellij/psi/impl/PsiTreeChangeEventImpl;", "isPreProcessable", "shouldProcessPsiEvent", "collectAllFilesToBuildTables", "", "findProvider", "Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTableProvider;", "getProvider", "missingProvider", "Lcom/jetbrains/cidr/lang/symbols/symtable/EmptySymbolTableProvider;", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "FILE_COLLECTOR_EP_NAME", "Lcom/jetbrains/cidr/lang/symbols/symtable/FileToBuildSymbolsCollector;", "providers", "", "getProviders", "()Ljava/util/List;", "intellij.c.core"})
@JvmName(name="FileSymbolTableHelper")
@SourceDebugExtension(value={"SMAP\nFileSymbolTableHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSymbolTableHelper.kt\ncom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTableHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1460#2,5:57\n295#2,2:62\n295#2,2:64\n295#2,2:66\n*S KotlinDebug\n*F\n+ 1 FileSymbolTableHelper.kt\ncom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTableHelper\n*L\n34#1:57,5\n36#1:62,2\n37#1:64,2\n40#1:66,2\n*E\n"})
public final class FileSymbolTableHelper {
    @JvmField
    @NotNull
    public static final ExtensionPointName<FileSymbolTableProvider> EP_NAME = ExtensionPointName.Companion.create("cidr.lang.symbolTableProvider");
    @JvmField
    @NotNull
    public static final ExtensionPointName<FileToBuildSymbolsCollector> FILE_COLLECTOR_EP_NAME = ExtensionPointName.Companion.create("cidr.lang.fileToBuildSymbolsCollector");

    public static final boolean isSourceFile(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return FileSymbolTableHelper.findProvider(virtualFile, project) != null;
    }

    public static final boolean isSourceFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FileSymbolTableHelper.findProvider(file) != null;
    }

    @NotNull
    public static final CharSequence getFileText(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CharSequence charSequence = FileContentSnapshot.get(virtualFile, project).getText();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getText(...)");
        return charSequence;
    }

    @NotNull
    public static final FileSymbolTable calculateTable(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FileSymbolTableProvider provider2 = FileSymbolTableHelper.getProvider(virtualFile, context);
        return provider2.calculateTable(virtualFile, context);
    }

    @NotNull
    public static final FileSymbolTable calculateTableUsingPSI(@NotNull OCFile file, @NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return FileSymbolTableHelper.getProvider(file).calculateTableUsingPSI(file, virtualFile, context);
    }

    public static final boolean isOutOfCodeBlockChange(@NotNull PsiTreeChangeEventImpl event, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FileSymbolTableHelper.getProvider(file).isOutOfCodeBlockChange(event);
    }

    public static final boolean isPreProcessable(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileSymbolTableProvider fileSymbolTableProvider = FileSymbolTableHelper.findProvider(file, project);
        return fileSymbolTableProvider != null ? fileSymbolTableProvider.shouldPreProcess() : false;
    }

    public static final boolean shouldProcessPsiEvent(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileSymbolTableProvider fileSymbolTableProvider = FileSymbolTableHelper.findProvider(file);
        return fileSymbolTableProvider != null ? fileSymbolTableProvider.shouldProcessPsiEvents(file) : false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<VirtualFile> collectAllFilesToBuildTables(@NotNull Project project) {
        void var2_2;
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable iterable = FILE_COLLECTOR_EP_NAME.getExtensionList();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            FileToBuildSymbolsCollector it = (FileToBuildSymbolsCollector)element$iv;
            boolean bl = false;
            Iterable list$iv = it.collectFilesToBuildTables(project);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)var2_2;
    }

    private static final FileSymbolTableProvider findProvider(PsiFile file) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = FileSymbolTableHelper.getProviders();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FileSymbolTableProvider it = (FileSymbolTableProvider)element$iv;
                boolean bl = false;
                if (!it.accepts(file)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final FileSymbolTableProvider findProvider(VirtualFile file, Project project) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = FileSymbolTableHelper.getProviders();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FileSymbolTableProvider it = (FileSymbolTableProvider)element$iv;
                boolean bl = false;
                if (!it.accepts(file, project)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final FileSymbolTableProvider getProvider(PsiFile file) {
        FileSymbolTableProvider fileSymbolTableProvider = FileSymbolTableHelper.findProvider(file);
        if (fileSymbolTableProvider == null) {
            VirtualFile virtualFile = file.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            fileSymbolTableProvider = FileSymbolTableHelper.missingProvider(virtualFile);
        }
        return fileSymbolTableProvider;
    }

    private static final FileSymbolTableProvider getProvider(VirtualFile file, OCInclusionContext context) {
        FileSymbolTableProvider fileSymbolTableProvider;
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = FileSymbolTableHelper.getProviders();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FileSymbolTableProvider it = (FileSymbolTableProvider)element$iv;
                boolean bl = false;
                if (!it.accepts(file, context)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((fileSymbolTableProvider = (FileSymbolTableProvider)v0) == null) {
            fileSymbolTableProvider = FileSymbolTableHelper.missingProvider(file);
        }
        return fileSymbolTableProvider;
    }

    private static final EmptySymbolTableProvider missingProvider(VirtualFile file) {
        EmptySymbolTableProvider emptySymbolTableProvider;
        EmptySymbolTableProvider it = emptySymbolTableProvider = EmptySymbolTableProvider.INSTANCE;
        boolean bl = false;
        OCLog.LOG.error(StringsKt.trimIndent((String)("\n    FileSymbolTable was asked for a symbol table of file \"" + file.getName() + "\" of " + file.getClass() + ". \n    No provider accepted it. \n  ")));
        return emptySymbolTableProvider;
    }

    private static final List<FileSymbolTableProvider> getProviders() {
        return EP_NAME.getExtensionList();
    }
}

