/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.search.OCSearchHelper;
import com.jetbrains.cidr.lang.symbols.OCNonNavigatableSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbolTableModificationTracker;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGlobalProjectSymbolsCache<T extends OCSymbol, S extends Symbols<T>> {
    @NotNull
    private final CachedValue<S> myGlobalSymbols;
    @NotNull
    private final ReentrantLock myGlobalSymbolsLock;
    @NotNull
    private final CachedValue<MultiMap<String, T>> myGlobalShortNames;
    @NotNull
    private final ReentrantLock myGlobalShortNamesLock;

    protected <Impl extends AbstractGlobalProjectSymbolsCache<T, S>> AbstractGlobalProjectSymbolsCache(@NotNull Class<Impl> clazz, @NotNull Project project) {
        if (clazz == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(1);
        }
        this.myGlobalSymbolsLock = new ReentrantLock();
        this.myGlobalShortNamesLock = new ReentrantLock();
        CachedValuesManager manager = CachedValuesManager.getManager((Project)project);
        OCFileSymbolTableModificationTracker FSTmt = OCFileSymbolTableModificationTracker.getInstance(project);
        this.myGlobalSymbols = manager.createCachedValue(() -> {
            S symbols;
            if (FileSymbolTablesCache.areSymbolsLoaded(project)) {
                symbols = this.buildGlobalSymbols(project);
            } else {
                AbstractGlobalProjectSymbolsCache.reportSymbolsAreNotLoaded();
                symbols = this.emptySymbols();
            }
            return CachedValueProvider.Result.create(symbols, (Object[])new Object[]{FSTmt});
        }, false);
        this.myGlobalShortNames = manager.createCachedValue(() -> {
            MultiMap result = new MultiMap();
            if (FileSymbolTablesCache.areSymbolsLoaded(project)) {
                AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project, symbol -> {
                    if (!(symbol instanceof OCNonNavigatableSymbol)) {
                        result.putValue((Object)symbol.getName(), symbol);
                    }
                    return true;
                }, null);
            } else {
                AbstractGlobalProjectSymbolsCache.reportSymbolsAreNotLoaded();
            }
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{FSTmt});
        }, false);
    }

    private static void reportSymbolsAreNotLoaded() {
        if (!PlatformUtils.isFleetBackend()) {
            OCLog.LOG.error("Symbols are not loaded");
        }
    }

    @Nullable
    protected static <Impl extends AbstractGlobalProjectSymbolsCache<T, ? extends Symbols<T>>, T extends OCSymbol> T findNearestTopLevelSymbol(@NotNull Class<Impl> clazz, @NotNull Project project, @Nullable String name, @Nullable Condition<? super T> condition, @Nullable VirtualFile contextFile) {
        if (clazz == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(2);
        }
        if (project == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(3);
        }
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor<T>((Processor)finder, true, new Condition[]{symbol -> Objects.equals(symbol.getContainingFile(), contextFile), symbol -> {
            VirtualFile file = symbol.getContainingFile();
            return contextFile != null && file != null && Objects.equals(file.getNameWithoutExtension(), contextFile.getNameWithoutExtension());
        }, symbol -> {
            VirtualFile file = symbol.getContainingFile();
            return contextFile != null && file != null && Objects.equals(file.getParent(), contextFile.getParent());
        }, symbol -> {
            VirtualFile symbolFile = symbol.getContainingFile();
            return OCSearchHelper.areFromSameProject(project, contextFile, symbolFile);
        }, Conditions.alwaysTrue()}){

            @Override
            @NotNull
            public Collection<T> sort(Collection<T> collection) {
                ArrayList list = new ArrayList(collection);
                list.sort(Comparator.comparingInt(Object::hashCode));
                ArrayList arrayList = list;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache$1", "sort"));
            }
        };
        AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project, symbol -> {
            if (condition != null && !condition.value(symbol)) {
                return true;
            }
            if (OCSearchHelper.isFromWrongSDK(project, symbol, contextFile)) {
                return true;
            }
            return orderedProcessor.process(symbol);
        }, name, true);
        orderedProcessor.finish();
        return (T)((OCSymbol)finder.getFoundValue());
    }

    @NotNull
    public static <T> T getInstance(@NotNull Class<T> clazz, @NotNull Project project) {
        if (clazz == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(4);
        }
        if (project == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(5);
        }
        Object object = project.getService(clazz);
        if (object == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(6);
        }
        return (T)object;
    }

    @NotNull
    protected S getGlobalSymbols() {
        Symbols symbols = (Symbols)ProgressIndicatorUtils.computeWithLockAndCheckingCanceled((Lock)this.myGlobalSymbolsLock, (int)100, (TimeUnit)TimeUnit.MILLISECONDS, () -> (Symbols)this.myGlobalSymbols.getValue());
        if (symbols == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(7);
        }
        return (S)symbols;
    }

    @Nullable
    protected S getUpToDateGlobalSymbols() {
        return (S)((Symbols)ProgressIndicatorUtils.computeWithLockAndCheckingCanceled((Lock)this.myGlobalSymbolsLock, (int)0, (TimeUnit)TimeUnit.MILLISECONDS, () -> (Symbols)ObjectUtils.doIfNotNull((Object)this.myGlobalSymbols.getUpToDateOrNull(), Supplier::get)));
    }

    @NotNull
    protected MultiMap<String, T> getGlobalShortNames() {
        MultiMap multiMap = (MultiMap)ProgressIndicatorUtils.computeWithLockAndCheckingCanceled((Lock)this.myGlobalShortNamesLock, (int)100, (TimeUnit)TimeUnit.MILLISECONDS, () -> (MultiMap)this.myGlobalShortNames.getValue());
        if (multiMap == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(8);
        }
        return multiMap;
    }

    @NotNull
    protected abstract S buildGlobalSymbols(@NotNull Project var1);

    @NotNull
    protected abstract S emptySymbols();

    protected static <Impl extends AbstractGlobalProjectSymbolsCache<T, ? extends Symbols<T>>, T extends OCSymbol> boolean processTopLevelSymbols(@NotNull Class<Impl> clazz, @NotNull Project project, @NotNull Processor<? super T> processor2, @Nullable String name) {
        if (clazz == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(9);
        }
        if (project == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(10);
        }
        if (processor2 == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(11);
        }
        return AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project, processor2, name, true);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache<T, ? extends Symbols<T>>, T extends OCSymbol> boolean processTopLevelAndMemberSymbols(@NotNull Class<Impl> clazz, @NotNull Project project, @NotNull Processor<? super T> processor2, @Nullable String name) {
        if (clazz == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(12);
        }
        if (project == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(13);
        }
        if (processor2 == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(14);
        }
        return AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project, processor2, name, false);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache<T, ? extends Symbols<T>>, T extends OCSymbol> boolean processByQualifiedName(@NotNull Class<Impl> clazz, @NotNull Project project, @NotNull Processor<? super T> processor2, @NotNull String name) {
        Collection iterable;
        if (clazz == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(15);
        }
        if (project == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(16);
        }
        if (processor2 == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(17);
        }
        if (name == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(18);
        }
        return (iterable = ((AbstractGlobalProjectSymbolsCache)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project)).getGlobalShortNames().get((Object)name)).isEmpty() || ContainerUtil.process((Iterable)iterable, processor2);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache> boolean processAliasNamesForType(@NotNull Class<Impl> clazz, @NotNull Project project, @NotNull String name, @NotNull Processor<? super String> processor2) {
        if (clazz == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(19);
        }
        if (project == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(20);
        }
        if (name == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(21);
        }
        if (processor2 == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(22);
        }
        FileSymbolTablesCache.getInstance(project).ensurePendingFilesProcessed();
        return ((AbstractGlobalProjectSymbolsCache)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project)).getGlobalSymbols().processAliasNamesForType(name, processor2);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache<T, ? extends Symbols<T>>, T extends OCSymbol> boolean processTopLevelAndMemberSymbols(@NotNull Class<Impl> clazz, @NotNull Project project, @NotNull Processor<? super T> processor2, @Nullable String name, boolean topLevelOnly) {
        if (clazz == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(23);
        }
        if (project == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(24);
        }
        if (processor2 == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(25);
        }
        FileSymbolTablesCache.getInstance(project).ensurePendingFilesProcessed();
        Object symbols = ((AbstractGlobalProjectSymbolsCache)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project)).getGlobalSymbols();
        if (topLevelOnly) {
            return symbols.processTopLevel(processor2, name);
        }
        return symbols.processAllSymbols(processor2, name);
    }

    @NotNull
    protected static <Impl extends AbstractGlobalProjectSymbolsCache<T, ? extends Symbols<T>>, T extends OCSymbol> Set<String> getAllSymbolNames(@NotNull Class<Impl> clazz, @NotNull Project project) {
        if (clazz == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(26);
        }
        if (project == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(27);
        }
        Set set = ((AbstractGlobalProjectSymbolsCache)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project)).getGlobalShortNames().keySet();
        if (set == null) {
            AbstractGlobalProjectSymbolsCache.$$$reportNull$$$0(28);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache";
                break;
            }
            case 11: 
            case 14: 
            case 17: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/AbstractGlobalProjectSymbolsCache";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalSymbols";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalShortNames";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSymbolNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findNearestTopLevelSymbol";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 28: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processTopLevelSymbols";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processTopLevelAndMemberSymbols";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processByQualifiedName";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processAliasNamesForType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAllSymbolNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 28 -> new IllegalStateException(string);
        };
    }

    public static interface Symbols<T> {
        public boolean processAliasNamesForType(@NotNull String var1, @NotNull Processor<? super String> var2);

        public boolean processTopLevel(@NotNull Processor<? super T> var1, @Nullable String var2);

        public boolean processAllSymbols(@NotNull Processor<? super T> var1, @Nullable String var2);
    }
}

