/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.psi.impl.OCConditionalExpressionImpl;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConditionalExpressionSymbol
extends OCExpressionSymbol {
    private OCExpressionSymbol myCondition;
    private OCExpressionSymbol myLeftOperand;
    private OCExpressionSymbol myRightOperand;

    public OCConditionalExpressionSymbol() {
    }

    public OCConditionalExpressionSymbol(@Nullable VirtualFile file, long offset, OCExpressionSymbol condition, OCExpressionSymbol leftOperand, OCExpressionSymbol rightOperand) {
        super(file, offset);
        this.myCondition = condition;
        this.myLeftOperand = leftOperand;
        this.myRightOperand = rightOperand;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCConditionalExpressionSymbol.$$$reportNull$$$0(0);
        }
        if (first == null) {
            OCConditionalExpressionSymbol.$$$reportNull$$$0(1);
        }
        if (second == null) {
            OCConditionalExpressionSymbol.$$$reportNull$$$0(2);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCConditionalExpressionSymbol firstSymbol = (OCConditionalExpressionSymbol)first;
        OCConditionalExpressionSymbol secondSymbol = (OCConditionalExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myCondition, secondSymbol.myCondition)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myLeftOperand, secondSymbol.myLeftOperand)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myRightOperand, secondSymbol.myRightOperand);
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCConditionalExpressionSymbol.$$$reportNull$$$0(3);
        }
        OCType leftType = this.myLeftOperand.getResolvedType(context);
        OCType rightType = this.myRightOperand.getResolvedType(context);
        if (leftType instanceof OCTypeParameterType) {
            context.addTypeDependency(((OCTypeParameterType)leftType).getSymbol());
        }
        if (rightType instanceof OCTypeParameterType) {
            context.addTypeDependency(((OCTypeParameterType)rightType).getSymbol());
        }
        OCType oCType = OCConditionalExpressionImpl.calcConditionalExprType(leftType, this.myLeftOperand, rightType, this.myRightOperand, context);
        if (oCType == null) {
            OCConditionalExpressionSymbol.$$$reportNull$$$0(4);
        }
        return oCType;
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        if (evaluator == null) {
            OCConditionalExpressionSymbol.$$$reportNull$$$0(5);
        }
        return (T)evaluator.evalConditional(this.myCondition.evaluate(evaluator), () -> this.myLeftOperand.evaluate(evaluator), () -> this.myRightOperand.evaluate(evaluator));
    }

    public OCExpressionSymbol getLeftOperandOrCondition() {
        return this.myLeftOperand == null ? this.myCondition : this.myLeftOperand;
    }

    public OCExpressionSymbol getCondition() {
        return this.myCondition;
    }

    public OCExpressionSymbol getLeftOperand() {
        return this.myLeftOperand;
    }

    public OCExpressionSymbol getRightOperand() {
        return this.myRightOperand;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.myCondition.getPresentableName() + " ?" + (String)(this.myLeftOperand == null ? "" : " " + this.myLeftOperand.getPresentableName() + " ") + ": " + this.myRightOperand.getPresentableName();
        if (string == null) {
            OCConditionalExpressionSymbol.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/expression/OCConditionalExpressionSymbol";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/expression/OCConditionalExpressionSymbol";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedType";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

