/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCThisSelfSuperSymbol
extends OCDeclaratorSymbolImpl {
    private Kind myKind;

    public OCThisSelfSuperSymbol() {
    }

    public OCThisSelfSuperSymbol(Kind kind, OCType type) {
        super(null, -1L, null, OCThisSelfSuperSymbol.getNameByKind(kind), Collections.emptyList(), type, OCSymbolKind.PARAMETER);
        this.myKind = kind;
    }

    private OCThisSelfSuperSymbol(@NotNull OCThisSelfSuperSymbol origin, @NotNull OCTypeSubstitution substitution, @Nullable OCSymbolWithQualifiedName parent) {
        if (origin == null) {
            OCThisSelfSuperSymbol.$$$reportNull$$$0(0);
        }
        if (substitution == null) {
            OCThisSelfSuperSymbol.$$$reportNull$$$0(1);
        }
        super(origin, substitution, parent);
        this.myKind = origin.myKind;
    }

    @Override
    @NotNull
    public OCThisSelfSuperSymbol cloneWithSubstitution(@NotNull OCTypeSubstitution substitution, @Nullable OCSymbolWithQualifiedName parent) {
        if (substitution == null) {
            OCThisSelfSuperSymbol.$$$reportNull$$$0(2);
        }
        return new OCThisSelfSuperSymbol(this, substitution, parent);
    }

    private static String getNameByKind(Kind kind) {
        return switch (kind) {
            default -> throw new IncompatibleClassChangeError();
            case Kind.THIS -> "this";
            case Kind.SELF -> "self";
            case Kind.SUPER -> "super";
            case Kind._CMD -> "_cmd";
        };
    }

    private static Kind getKindByName(String name) {
        if ("this".equals(name)) {
            return Kind.THIS;
        }
        if ("self".equals(name)) {
            return Kind.SELF;
        }
        if ("super".equals(name)) {
            return Kind.SUPER;
        }
        if ("_cmd".equals(name)) {
            return Kind._CMD;
        }
        return null;
    }

    public Kind getSelfSuperThisKind() {
        return this.myKind;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCThisSelfSuperSymbol.$$$reportNull$$$0(3);
        }
        if (first == null) {
            OCThisSelfSuperSymbol.$$$reportNull$$$0(4);
        }
        if (second == null) {
            OCThisSelfSuperSymbol.$$$reportNull$$$0(5);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        return ((OCThisSelfSuperSymbol)first).myKind == ((OCThisSelfSuperSymbol)second).myKind;
    }

    public static OCSymbol tryResolveThisSelfSuper(String elementName, @NotNull PsiElement elementContext, @NotNull OCResolveContext context) {
        Kind kind;
        if (elementContext == null) {
            OCThisSelfSuperSymbol.$$$reportNull$$$0(6);
        }
        if (context == null) {
            OCThisSelfSuperSymbol.$$$reportNull$$$0(7);
        }
        if ((kind = OCThisSelfSuperSymbol.getKindByName(elementName)) == null) {
            return null;
        }
        OCSymbol[] result = new OCSymbol[1];
        OCThisSelfSuperSymbol.processThisSelfSuperInContext(elementName, elementContext, context, (Processor<OCSymbol>)((Processor)symbol -> {
            if (((OCThisSelfSuperSymbol)symbol).getSelfSuperThisKind() == kind) {
                result[0] = symbol;
                return false;
            }
            return true;
        }), true);
        return result[0];
    }

    public static void processThisSelfSuperInContext(OCReferenceElement refElement, Processor<OCSymbol> processor2, boolean checkName) {
        OCThisSelfSuperSymbol.processThisSelfSuperInContext(refElement.getCanonicalText(), refElement, OCResolveContext.forPsi(refElement), processor2, checkName);
    }

    public static void processThisSelfSuperInContext(String elementName, @NotNull PsiElement elementContext, @NotNull OCResolveContext context, @NotNull Processor<OCSymbol> processor2, boolean checkName) {
        OCMethod containingMethod;
        if (elementContext == null) {
            OCThisSelfSuperSymbol.$$$reportNull$$$0(8);
        }
        if (context == null) {
            OCThisSelfSuperSymbol.$$$reportNull$$$0(9);
        }
        if (processor2 == null) {
            OCThisSelfSuperSymbol.$$$reportNull$$$0(10);
        }
        if (!((containingMethod = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)elementContext, OCMethod.class, (boolean)false)) == null || checkName && OCElementUtil.getSelfSuperToken(elementName, elementContext, context) == null)) {
            OCType superType;
            OCClassDeclaration containingClass = containingMethod.getContainingClass();
            String name = containingClass.getName();
            OCType selfClassType = OCReferenceType.resolvedFromText(name, context, false);
            OCType selfType = containingMethod.isInstanceMethod() ? OCPointerType.to(selfClassType) : OCReferenceType.resolvedFromText("Class", context, false);
            processor2.process((Object)new OCThisSelfSuperSymbol(Kind.SELF, selfType));
            processor2.process((Object)new OCThisSelfSuperSymbol(Kind._CMD, OCReferenceType.fromText("SEL")));
            if (selfClassType instanceof OCObjectType && (superType = ((OCObjectType)selfClassType).getSuperType()) != null) {
                superType = containingMethod.isInstanceMethod() ? OCPointerType.to(superType) : OCReferenceType.resolvedFromText("Class", context, false);
                processor2.process((Object)new OCThisSelfSuperSymbol(Kind.SUPER, superType));
            }
        }
        OCDeclaration containingFunction = (OCDeclaration)PsiTreeUtil.getContextOfType((PsiElement)elementContext, OCDeclaration.class, (boolean)false);
        while (containingFunction != null) {
            OCSymbolWithQualifiedName classSymbol;
            OCSymbol declarator;
            List<OCDeclarator> declarators = containingFunction.getDeclarators();
            if (declarators.size() == 1 && (declarator = declarators.get(0).getSymbol()) instanceof OCFunctionSymbol && (classSymbol = ((OCSymbolWithQualifiedName)declarator).getResolvedOwner(context, true)) instanceof OCStructSymbol) {
                OCType classType = classSymbol.getType();
                if (((OCFunctionSymbol)declarator).isConst()) {
                    classType = classType.cloneWithConstModifier(elementContext.getProject());
                }
                OCPointerType thisType = OCPointerType.to(classType);
                processor2.process((Object)new OCThisSelfSuperSymbol(Kind.THIS, thisType));
                return;
            }
            containingFunction = (OCDeclaration)PsiTreeUtil.getContextOfType((PsiElement)containingFunction, (Class[])new Class[]{OCDeclaration.class});
        }
    }

    public boolean isKeywordLike() {
        return this.getSelfSuperThisKind() != Kind._CMD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementContext";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/symbols/cpp/OCThisSelfSuperSymbol";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "cloneWithSubstitution";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "deepEqualStep";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "tryResolveThisSelfSuper";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processThisSelfSuperInContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Kind {
        THIS,
        SELF,
        SUPER,
        _CMD;

    }
}

