/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.v2;

import com.jetbrains.cidr.lang.resolve.v2.AmbiguousConversionSequence;
import com.jetbrains.cidr.lang.resolve.v2.BadConversionSequence;
import com.jetbrains.cidr.lang.resolve.v2.StandardConversionSequence;
import com.jetbrains.cidr.lang.resolve.v2.UserDefinedConversionSequence;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import org.jetbrains.annotations.Nullable;

public class ImplicitConversionSequence {
    Kind ConversionKind = Kind.Uninitialized;
    boolean StdInitializerListElement;
    StandardConversionSequence Standard;
    UserDefinedConversionSequence UserDefined;
    AmbiguousConversionSequence Ambiguous;
    BadConversionSequence Bad;
    private boolean hasMagic = false;

    void setKind(Kind K) {
        this.destruct();
        this.ConversionKind = K;
    }

    void destruct() {
    }

    public ImplicitConversionSequence() {
    }

    public ImplicitConversionSequence(ImplicitConversionSequence Other) {
        this.ConversionKind = Other.ConversionKind;
        this.StdInitializerListElement = Other.StdInitializerListElement;
        switch (this.ConversionKind) {
            case Uninitialized: 
            case EllipsisConversion: {
                break;
            }
            case StandardConversion: {
                this.Standard = Other.Standard;
                break;
            }
            case UserDefinedConversion: {
                this.UserDefined = Other.UserDefined;
                break;
            }
            case AmbiguousConversion: {
                this.Ambiguous = Other.Ambiguous;
                break;
            }
            case BadConversion: {
                this.Bad = Other.Bad;
            }
        }
    }

    public Kind getKind() {
        assert (this.isInitialized()) : "querying uninitialized conversion";
        return this.ConversionKind;
    }

    public int getKindRank() {
        return switch (this.getKind()) {
            case Kind.StandardConversion -> 0;
            case Kind.UserDefinedConversion, Kind.AmbiguousConversion -> 1;
            case Kind.EllipsisConversion -> 2;
            case Kind.BadConversion -> 3;
            default -> -1;
        };
    }

    public boolean isBad() {
        return this.getKind() == Kind.BadConversion;
    }

    public boolean isStandard() {
        return this.getKind() == Kind.StandardConversion;
    }

    public boolean isEllipsis() {
        return this.getKind() == Kind.EllipsisConversion;
    }

    public boolean isAmbiguous() {
        return this.getKind() == Kind.AmbiguousConversion;
    }

    public boolean isUserDefined() {
        return this.getKind() == Kind.UserDefinedConversion;
    }

    public boolean isFailure() {
        return this.isBad() || this.isAmbiguous();
    }

    boolean isInitialized() {
        return this.ConversionKind != Kind.Uninitialized;
    }

    void setBad(BadConversionSequence.FailureKind Failure, @Nullable OCTypeOwner FromExpr, OCType FromType, OCType ToType) {
        this.setKind(Kind.BadConversion);
        this.Bad = new BadConversionSequence(Failure, FromExpr, FromType, ToType);
    }

    void setBad(BadConversionSequence.FailureKind Failure, OCType FromType, OCType ToType) {
        this.setKind(Kind.BadConversion);
        this.Bad = new BadConversionSequence(Failure, FromType, ToType);
    }

    public void setStandard() {
        this.setKind(Kind.StandardConversion);
        if (this.Standard == null) {
            this.Standard = new StandardConversionSequence();
        }
    }

    public void setEllipsis() {
        this.setKind(Kind.EllipsisConversion);
    }

    public void setUserDefined() {
        this.setKind(Kind.UserDefinedConversion);
    }

    void setAmbiguous() {
        if (this.ConversionKind == Kind.AmbiguousConversion) {
            return;
        }
        this.ConversionKind = Kind.AmbiguousConversion;
    }

    boolean isStdInitializerListElement() {
        return this.StdInitializerListElement;
    }

    void setStdInitializerListElement() {
        this.setStdInitializerListElement(true);
    }

    void setStdInitializerListElement(boolean V) {
        this.StdInitializerListElement = V;
    }

    public boolean hasMagic() {
        return this.hasMagic;
    }

    public static ImplicitConversionSequence magic() {
        ImplicitConversionSequence conversion = new ImplicitConversionSequence();
        conversion.setStandard();
        conversion.hasMagic = true;
        return conversion;
    }

    public String toString() {
        return "ICS{Kind=" + String.valueOf((Object)this.ConversionKind) + ", magic=" + this.hasMagic + "}";
    }

    static enum Kind {
        StandardConversion,
        UserDefinedConversion,
        AmbiguousConversion,
        EllipsisConversion,
        BadConversion,
        Uninitialized;

    }

    public static enum CompareKind {
        Better,
        Indistinguishable,
        Worse;

    }
}

