/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCRefactoringBundle;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseExpressionInplaceIntroducer;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCVariableInplaceIntroducer
extends OCBaseExpressionInplaceIntroducer<OCDeclarator, OCExpression> {
    private JCheckBox myAutoCB;
    private JCheckBox myConstCB;
    private boolean myCreateFromAssignment;

    public OCVariableInplaceIntroducer(Project project, Editor editor, OCExpression expression, List<OCExpression> occurrences, @NlsContexts.Command String refactoringName) {
        super(project, editor, expression, occurrences, OCDeclarator.class, OCExpression.class, refactoringName);
    }

    @Override
    public void configurePanel() {
        super.configurePanel();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Editor)this.myEditor).getCustomSettings(OCCodeStyleSettings.class);
        if (this.isAutoAvailable()) {
            this.myAutoCB = this.createCheckBox(OCRefactoringBundle.message("refactoring.introducer.declare.auto", new Object[0]), settings.INTRODUCE_AUTO_VARS, () -> {
                settings.INTRODUCE_AUTO_VARS = this.myAutoCB.isSelected();
                this.rebuildDeclaration();
            });
        }
        if (this.isConstAvailable()) {
            this.myConstCB = this.createCheckBox(OCRefactoringBundle.message("refactoring.introducer.declare.const", new Object[0]), settings.INTRODUCE_CONST_VARS, () -> {
                settings.INTRODUCE_CONST_VARS = this.myConstCB.isSelected();
                this.rebuildDeclaration();
            });
        }
    }

    private void rebuildDeclaration() {
        OCDeclarator declarator = (OCDeclarator)this.getVariable();
        if (declarator != null) {
            declarator = this.rebuildDeclarator(declarator, new OCBaseExpressionInplaceIntroducer.Rebuilder(){

                @Override
                public OCDeclarator rebuild(OCDeclarator declarator) {
                    OCStatement newDeclaration = OCVariableInplaceIntroducer.this.createDeclaration(declarator.getName(), declarator.getInitializer(), declarator);
                    newDeclaration = (OCStatement)OCChangeUtil.replaceHandlingMacros(declarator.getParent().getParent(), newDeclaration);
                    return ((OCDeclarationStatement)newDeclaration).getDeclaration().getDeclarators().get(0);
                }
            });
            TextRange range = declarator.getNameIdentifier().getTextRange();
            this.myEditor.getCaretModel().moveToOffset(range.getStartOffset());
        }
    }

    @Override
    protected OCSymbolKind getDeclaratorKind() {
        return OCSymbolKind.LOCAL_VARIABLE;
    }

    @Override
    public boolean isPreviewDisabled() {
        return true;
    }

    @Nullable
    private OCExpression getInitializer(OCExpression mainExpression) {
        if (!this.isCreateFromUsageMode()) {
            return mainExpression;
        }
        PsiElement psiElement = mainExpression.getParent();
        if (psiElement instanceof OCAssignmentExpression) {
            OCAssignmentExpression assignment = (OCAssignmentExpression)psiElement;
            if (mainExpression.getParent().getParent() instanceof OCExpressionStatement && mainExpression.getParent().getParent() == this.getAnchor() && assignment.getReceiverExpression() == mainExpression) {
                return assignment.getSourceExpression();
            }
        }
        return null;
    }

    private OCStatement createDeclaration(String name, OCExpression initializer, PsiElement context) {
        boolean isAuto = this.myAutoCB != null && this.myAutoCB.isSelected();
        boolean isConst = this.myConstCB != null && this.myConstCB.isSelected();
        return OCElementFactory.declarationStatement(name, this.getType(initializer, isAuto, isConst), initializer, context);
    }

    @Override
    public void introduceForPreview(String name) {
        OCDeclarationStatement declarationStatementInFile;
        OCExpression mainExpression = (OCExpression)this.getMainExpression();
        PsiElement anchor = this.getAnchor();
        OCStatement declarationStatementInFragment = this.createDeclaration(name, this.getInitializer(mainExpression), anchor.getParent());
        anchor = this.ensureParentIsBlockStatement(anchor);
        boolean bl = this.myCreateFromAssignment = this.isCreateFromUsageMode() && this.getInitializer(mainExpression) != null;
        if (mainExpression.getParent() instanceof OCExpressionStatement && !(mainExpression.getParent().getParent() instanceof OCMacroCallArgument) || this.myCreateFromAssignment) {
            OCStatement parentStmt = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)(mainExpression.isValid() ? mainExpression : anchor), OCStatement.class, (boolean)false);
            declarationStatementInFile = (OCDeclarationStatement)OCChangeUtil.replaceHandlingMacros(parentStmt, declarationStatementInFragment);
        } else {
            declarationStatementInFile = (OCDeclarationStatement)OCChangeUtil.addBefore(anchor.getParent(), declarationStatementInFragment, anchor);
        }
        List<OCDeclarator> declarators = declarationStatementInFile.getDeclaration().getDeclarators();
        assert (!declarators.isEmpty());
        this.setVariable(declarators.get(0));
    }

    @Override
    protected void introduceForReal(String name) {
        OCAddInitializerIntentionAction action;
        this.introduceForPreview(name);
        boolean wasInitialized = false;
        for (OCExpression expression : (OCExpression[])this.myOccurrences) {
            if (this.changeUsages(name)) {
                OCChangeUtil.replaceHandlingMacros(expression, OCElementFactory.expressionFromText(name, expression));
            }
            if (new OCReadWriteAccessDetector().getExpressionAccess(expression) != ReadWriteAccessDetector.Access.Write) continue;
            wasInitialized = true;
        }
        OCDeclarator declarator = (OCDeclarator)this.getVariable();
        if (this.isCreateFromUsageMode() && !this.myCreateFromAssignment && !wasInitialized && declarator != null && (action = new OCAddInitializerIntentionAction(declarator, declarator.getSymbol())).isAvailable(declarator.getProject(), this.myEditor, declarator.getContainingFile())) {
            action.invoke(declarator.getProject(), this.myEditor, declarator.getContainingFile());
        }
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.appCodeIntroduceVariable";
    }

    protected void moveOffsetAfter(boolean success) {
        super.moveOffsetAfter(success);
        OCDeclarator variable = (OCDeclarator)this.getVariable();
        if (success && this.isCreateFromUsageMode() && variable != null) {
            this.myEditor.getCaretModel().moveToOffset(variable.getTextRange().getEndOffset());
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }

    @Override
    protected void restoreState(@NotNull OCDeclarator variable) {
        if (variable == null) {
            OCVariableInplaceIntroducer.$$$reportNull$$$0(0);
        }
        this.myExprType = variable.getResolvedType();
        super.restoreState(variable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/jetbrains/cidr/lang/refactoring/introduce/OCVariableInplaceIntroducer", "restoreState"));
    }
}

