/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.refactoring.ui.VisibilityPanelBase;
import com.intellij.ui.IdeBorderFactory;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.Nullable;

public class OCCallableKindPanel
extends VisibilityPanelBase<String> {
    private final List<JRadioButton> myButtons;

    public OCCallableKindPanel() {
        this.setBorder(IdeBorderFactory.createTitledBorder((String)OCBundle.message("callable.type.title", new Object[0])));
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        ButtonGroup bg = new ButtonGroup();
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    OCCallableKindPanel.this.stateChanged(new ChangeEvent(this));
                }
            }
        };
        JRadioButton rbMethod = new JRadioButton();
        rbMethod.setText(OCCallableKind.METHOD.getPresentableName());
        JRadioButton rbFunction = new JRadioButton();
        rbFunction.setText(OCCallableKind.FUNCTION.getPresentableName());
        JRadioButton rbBlock = new JRadioButton();
        rbBlock.setText(OCCallableKind.BLOCK.getPresentableName());
        this.myButtons = Arrays.asList(rbMethod, rbFunction, rbBlock);
        for (JRadioButton button : this.myButtons) {
            button.addItemListener(listener);
            button.setFocusable(false);
            this.add(button);
            bg.add(button);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (JRadioButton button : this.myButtons) {
            button.setEnabled(enabled);
        }
    }

    @Nullable
    public String getVisibility() {
        for (JRadioButton button : this.myButtons) {
            if (!button.isSelected()) continue;
            return button.getText();
        }
        return null;
    }

    public void setVisibility(String visibility) {
        for (JRadioButton button : this.myButtons) {
            if (!button.getText().equals(visibility)) continue;
            button.setSelected(true);
            return;
        }
        assert (false) : "Unknown callable kind: " + visibility;
    }
}

