/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRemoveTypeModifierIntentionAction
extends OCSymbolQuickFix<OCSymbol> {
    private OCElementType myModifier;
    @IntentionName
    private final String myText;

    public OCRemoveTypeModifierIntentionAction(@NotNull OCSymbolWithParent symbol, OCElementType modifier, @NotNull Project project) {
        if (symbol == null) {
            OCRemoveTypeModifierIntentionAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            OCRemoveTypeModifierIntentionAction.$$$reportNull$$$0(1);
        }
        this(symbol, modifier, symbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, project)), project);
    }

    public OCRemoveTypeModifierIntentionAction(@NotNull OCSymbolWithParent symbol, OCElementType modifier, String subject, @NotNull Project project) {
        if (symbol == null) {
            OCRemoveTypeModifierIntentionAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            OCRemoveTypeModifierIntentionAction.$$$reportNull$$$0(3);
        }
        super(project, symbol);
        this.myModifier = modifier;
        this.myText = OCInspectionsBundle.message((String)"intention.name.remove.type.modifier", (Object[])new Object[]{subject, this.myModifier.getName()});
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"intentions.remove.subj", (Object[])new Object[]{this.myModifier.getName()});
        if (string == null) {
            OCRemoveTypeModifierIntentionAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isAvailable() {
        if (!super.isAvailable()) {
            return false;
        }
        if (!(this.myModifier != OCLexerTokenTypes.CONST_KEYWORD || ((OCDeclaratorSymbol)this.mySymbol).isConst() && this.mySymbol.getKind() != OCSymbolKind.ENUM_CONST)) {
            return false;
        }
        if (this.myModifier == OCLexerTokenTypes.BLOCK_KEYWORD && !((OCDeclaratorSymbol)this.mySymbol).isBlockModifiable()) {
            return false;
        }
        return this.myModifier != OCLexerTokenTypes.STATIC_KEYWORD || !(this.mySymbol instanceof OCFunctionSymbol) || ((OCFunctionSymbol)this.mySymbol).isStatic();
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        if (project == null) {
            OCRemoveTypeModifierIntentionAction.$$$reportNull$$$0(5);
        }
        if (!OCCodeInsightUtil.isValid(this.mySymbol.locateDefinition(project))) {
            return;
        }
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
        this.mySymbol.processSameSymbols((Processor<OCSymbol>)collector, project);
        List<SmartPsiElementPointer> psiSmartPointers = collector.getResults().stream().map(symbol1 -> symbol1.locateDefinition(project)).filter(Predicates.nonNull()).map(OCElementUtil::createPsiElementPointer).toList();
        for (SmartPsiElementPointer pointer : psiSmartPointers) {
            OCTypeElement typeElement;
            PsiElement element = pointer.getElement();
            if (element == null || this.findAndRemove(element) || !(element instanceof OCDeclarator) || !(element.getParent() instanceof OCDeclaration) || (typeElement = ((OCDeclaration)element.getParent()).getTypeElement()) == null || this.findAndRemove(typeElement)) continue;
            this.findAndRemove(typeElement.getParent());
        }
    }

    @Override
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        PsiElement psiElement;
        PsiElement definition;
        if (project == null) {
            OCRemoveTypeModifierIntentionAction.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            OCRemoveTypeModifierIntentionAction.$$$reportNull$$$0(7);
        }
        if (psiFile == null) {
            OCRemoveTypeModifierIntentionAction.$$$reportNull$$$0(8);
        }
        if (!OCCodeInsightUtil.isValid(definition = this.mySymbol.locateDefinition(project))) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                OCRemoveTypeModifierIntentionAction.$$$reportNull$$$0(9);
            }
            return intentionPreviewInfo;
        }
        ArrayList<PsiElement> elementsToTry = new ArrayList<PsiElement>();
        elementsToTry.add(definition);
        if (definition instanceof OCDeclarator && (psiElement = definition.getParent()) instanceof OCDeclaration) {
            OCDeclaration declaration = (OCDeclaration)psiElement;
            elementsToTry.add(declaration.getTypeElement());
            elementsToTry.add(declaration);
        }
        for (PsiElement element : elementsToTry) {
            String textAfterFix = this.getElementTextWithoutModifier(element);
            if (StringUtil.isEmpty((String)textAfterFix)) continue;
            return new IntentionPreviewInfo.CustomDiff(psiFile.getFileType(), element.getText(), textAfterFix);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            OCRemoveTypeModifierIntentionAction.$$$reportNull$$$0(10);
        }
        return intentionPreviewInfo;
    }

    @Nullable
    private String getElementTextWithoutModifier(@NotNull PsiElement element) {
        ASTNode[] children;
        ASTNode nodeWithModifier;
        if (element == null) {
            OCRemoveTypeModifierIntentionAction.$$$reportNull$$$0(11);
        }
        if ((nodeWithModifier = this.findNodeWithModifier(children = element.getNode().getChildren(null))) == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (ASTNode child : children) {
            if (child == nodeWithModifier) continue;
            builder.append(child.getText());
        }
        return builder.toString();
    }

    private boolean findAndRemove(PsiElement element) {
        ASTNode[] children = element.getNode().getChildren(null);
        ASTNode nodeWithModifier = this.findNodeWithModifier(children);
        if (nodeWithModifier == null) {
            return false;
        }
        PsiElement psi = nodeWithModifier.getPsi();
        if (psi != null) {
            OCChangeUtil.delete(psi);
        }
        return true;
    }

    @Nullable
    private ASTNode findNodeWithModifier(ASTNode[] nodes) {
        for (int i = nodes.length - 1; i >= 0; --i) {
            if (nodes[i].getElementType() != this.myModifier) continue;
            return nodes[i];
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCRemoveTypeModifierIntentionAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCRemoveTypeModifierIntentionAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getElementTextWithoutModifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9, 10 -> new IllegalStateException(string);
        };
    }
}

