/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class OCPsiElementsQuickFix
extends OCQuickFix {
    protected List<SmartPsiElementPointer> myElementPointers;

    protected OCPsiElementsQuickFix(Collection<? extends PsiElement> elements) {
        if (elements != null) {
            this.myElementPointers = new ArrayList<SmartPsiElementPointer>(elements.size());
            for (PsiElement psiElement : elements) {
                if (psiElement == null) continue;
                this.myElementPointers.add(SmartPointerManager.getInstance((Project)psiElement.getProject()).createSmartPsiElementPointer(psiElement));
            }
        }
    }

    protected OCPsiElementsQuickFix(PsiElement ... elements) {
        this.myElementPointers = new ArrayList<SmartPsiElementPointer>();
        for (PsiElement element : elements) {
            this.myElementPointers.add(SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element));
        }
    }

    @Override
    public boolean isAvailable() {
        boolean[] exists = new boolean[]{false};
        if (!this.processElements((Processor<PsiElement>)((Processor)element -> {
            exists[0] = true;
            return OCCodeInsightUtil.isValid(element);
        }))) {
            return false;
        }
        return exists[0];
    }

    protected boolean processElements(Processor<PsiElement> processor2) {
        for (SmartPsiElementPointer pointer : this.myElementPointers) {
            PsiElement element = pointer.getElement();
            if (element == null || processor2.process((Object)element)) continue;
            return false;
        }
        return true;
    }

    public List<? extends PsiElement> getElements() {
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        for (SmartPsiElementPointer pointer : this.myElementPointers) {
            PsiElement element = pointer.getElement();
            if (element == null) continue;
            elements.add(element);
        }
        return elements;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            OCPsiElementsQuickFix.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            OCPsiElementsQuickFix.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            OCPsiElementsQuickFix.$$$reportNull$$$0(2);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            OCPsiElementsQuickFix.$$$reportNull$$$0(3);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCPsiElementsQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCPsiElementsQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

