/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementsQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeElementIntentionAction
extends OCPsiElementsQuickFix {
    @IntentionName
    private final String myIntentionName;
    @IntentionFamilyName
    private final String myFamilyName;

    public OCChangeElementIntentionAction(PsiElement element, PsiElement newElement, @IntentionFamilyName String intentionName) {
        this(element, newElement, intentionName, intentionName);
    }

    public OCChangeElementIntentionAction(PsiElement element, PsiElement newElement, @IntentionName String intentionName, @IntentionFamilyName String familyName) {
        super(element, newElement);
        this.myIntentionName = intentionName;
        this.myFamilyName = familyName;
    }

    public OCChangeElementIntentionAction(PsiElement element, List<? extends PsiElement> newElements, @IntentionFamilyName String intentionName) {
        this(ContainerUtil.concat(Collections.singletonList(element), newElements), intentionName, intentionName);
    }

    public OCChangeElementIntentionAction(List<? extends PsiElement> elements, @IntentionFamilyName String intentionName, @IntentionFamilyName String familyName) {
        super(elements);
        this.myIntentionName = intentionName;
        this.myFamilyName = familyName;
    }

    @Override
    protected String getTextInternal() {
        return this.myIntentionName;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myFamilyName;
        if (string == null) {
            OCChangeElementIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isAvailable() {
        return OCCodeInsightUtil.isValid(((SmartPsiElementPointer)this.myElementPointers.get(0)).getElement());
    }

    @Override
    protected void invoke(PsiFile file, @NotNull Project project) {
        if (project == null) {
            OCChangeElementIntentionAction.$$$reportNull$$$0(1);
        }
        List<? extends PsiElement> elements = this.getElements();
        PsiElement oldElement = elements.get(0);
        if (elements.size() == 2) {
            PsiElement newElement = elements.get(1);
            if (oldElement instanceof OCExpression && newElement instanceof OCExpression) {
                OCParenthesesUtils.replaceExpressionAndAppendParentheses((OCExpression)oldElement, (OCExpression)newElement);
            } else {
                OCChangeUtil.replaceHandlingMacros(oldElement, newElement);
            }
        } else {
            PsiElement anchor = oldElement;
            for (int i = 1; i < elements.size(); ++i) {
                anchor = OCChangeUtil.addAfter(anchor.getParent(), elements.get(i), anchor);
            }
            OCChangeUtil.delete(oldElement);
        }
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        List copyElements;
        if (target == null) {
            OCChangeElementIntentionAction.$$$reportNull$$$0(2);
        }
        return (copyElements = OCInspectionUtil.findSameElementsInCopy((List)this.myElementPointers, (PsiFile)target)) != null && !copyElements.isEmpty() ? new OCChangeElementIntentionAction(copyElements, this.myIntentionName, this.myFamilyName) : null;
    }

    @Override
    protected boolean shouldCommitAllDocuments() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCChangeElementIntentionAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCChangeElementIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

