/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateConstructorHandler;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCUniqueNameGenerator;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCAddSuperConstructorCallsFix
extends OCSymbolQuickFix<OCFunctionSymbol> {
    private final OCStructSymbol myClassMissingBaseCtors;

    public OCAddSuperConstructorCallsFix(@NotNull OCFunctionSymbol constructor, OCStructSymbol classMissingBaseCtors, @NotNull Project project) {
        if (constructor == null) {
            OCAddSuperConstructorCallsFix.$$$reportNull$$$0(0);
        }
        if (project == null) {
            OCAddSuperConstructorCallsFix.$$$reportNull$$$0(1);
        }
        super(project, constructor);
        this.myClassMissingBaseCtors = classMissingBaseCtors;
    }

    @Override
    protected String getTextInternal() {
        return OCInspectionsBundle.message((String)"intention.name.add.call.to.base.constructor", (Object[])new Object[]{this.myClassMissingBaseCtors.getName()});
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"intentions.add.super.constructor.call", (Object[])new Object[0]);
        if (string == null) {
            OCAddSuperConstructorCallsFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        List<OCFunctionSymbol> chosenCtors;
        OCFunctionDefinition constructor;
        if (project == null) {
            OCAddSuperConstructorCallsFix.$$$reportNull$$$0(3);
        }
        if ((constructor = (OCFunctionDefinition)((OCFunctionSymbol)this.mySymbol).locateFunctionDefinition(project)) == null) {
            return;
        }
        ArrayList<Collection<OCFunctionSymbol>> baseConstructors = new ArrayList<Collection<OCFunctionSymbol>>();
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
        this.myClassMissingBaseCtors.processConstructors((Processor<? super OCFunctionSymbol>)collector, OCResolveContext.forPsi(constructor));
        if (!collector.getResults().isEmpty()) {
            baseConstructors.add(collector.getResults());
        }
        if ((chosenCtors = OCGenerateConstructorHandler.chooseBaseConstructors(baseConstructors, project)) == null) {
            return;
        }
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler(constructor, constructor, EnumSet.of(OCChangeSignatureActionHandler.ChangeSignatureFlags.SilentMode));
        HashSet<String> names = new HashSet<String>(ContainerUtil.map(((OCFunctionSymbol)this.mySymbol).getParameterSymbols(), symbol1 -> symbol1.getName()));
        int index = 0;
        OCConstructorInitializationList list = OCElementFactory.constructorInitializationList(constructor);
        for (OCFunctionSymbol baseConstructor : chosenCtors) {
            StringBuilder builder = new StringBuilder();
            builder.append(baseConstructor.getName()).append("(");
            boolean firstParam = true;
            for (OCDeclaratorSymbol param : baseConstructor.getParameterSymbols()) {
                String name = OCUniqueNameGenerator.suggestUniqueName(OCSymbolKind.PARAMETER, param.getName(), null, names, project);
                names.add(name);
                handler.insertParameter(name, param.getType(), index++);
                if (!firstParam) {
                    builder.append(",");
                }
                firstParam = false;
                builder.append(name);
            }
            builder.append(")");
            OCChangeUtil.add(list, OCElementFactory.constructorFieldInitializerFromText(builder.toString(), constructor));
        }
        OCConstructorInitializationList existingList = constructor.getConstructorInitializationList();
        if (existingList != null) {
            for (OCConstructorFieldInitializer initializer : existingList.getInitializers()) {
                OCChangeUtil.add(list, initializer);
            }
        }
        handler.getGeneratedInfo().runOnSuccess(() -> constructor.setConstructorInitializationList(list));
        handler.setTitle(this.getText());
        handler.invoke();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCAddSuperConstructorCallsFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCAddSuperConstructorCallsFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

