/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCBoostPPHelper {
    @NlsSafe
    public static final String BOOST_PP_PREFIX = "BOOST_PP_";
    private static final Map<String, FastBoostEvaluator> EVALUATORS = OCBoostPPHelper.evaluatorMap();

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static Map<@NlsSafe String, FastBoostEvaluator> evaluatorMap() {
        @NlsSafe Map r = CollectionFactory.createSmallMemoryFootprintMap((int)12);
        r.put("ADD", OCBoostPPHelper::tryFastAdd);
        r.put("ADD_D", OCBoostPPHelper::tryFastAddD);
        r.put("SUB", OCBoostPPHelper::tryFastSub);
        r.put("SUB_D", OCBoostPPHelper::tryFastSubD);
        r.put("TUPLE_ELEM", OCBoostPPHelper::tryFastTupleElem);
        r.put("WHILE_", OCBoostPPHelper::tryFastWhile);
        r.put("FOR_", OCBoostPPHelper::tryFastFor);
        r.put("REPEAT_", OCBoostPPHelper::tryFastRepeat);
        r.put("SEQ_FOLD_LEFT_", OCBoostPPHelper::tryFastSeqFoldLeft);
        r.put("SEQ_FOLD_RIGHT_", OCBoostPPHelper::tryFastSeqFoldRight);
        r.put("LIST_FOLD_LEFT_", OCBoostPPHelper::tryFastListFoldLeft);
        r.put("LIST_FOLD_RIGHT_", OCBoostPPHelper::tryFastListFoldRight);
        return r;
    }

    public static OCPreprocessingLexer.SubstitutionResult tryFastSubstitution(@NotNull OCPreprocessingLexer pp, @NotNull OCMacroSymbol macro, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap) {
        String macroName;
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(0);
        }
        if (macro == null) {
            OCBoostPPHelper.$$$reportNull$$$0(1);
        }
        if (params == null) {
            OCBoostPPHelper.$$$reportNull$$$0(2);
        }
        if (paramIndices == null) {
            OCBoostPPHelper.$$$reportNull$$$0(3);
        }
        if (paramSubst == null) {
            OCBoostPPHelper.$$$reportNull$$$0(4);
        }
        if (substitutionMap == null) {
            OCBoostPPHelper.$$$reportNull$$$0(5);
        }
        if (!(macroName = macro.getName()).startsWith(BOOST_PP_PREFIX)) {
            return null;
        }
        int evalKeyEnd = macroName.length();
        while (Character.isDigit(macroName.charAt(evalKeyEnd - 1))) {
            --evalKeyEnd;
        }
        String evalKey = macroName.substring(BOOST_PP_PREFIX.length(), evalKeyEnd);
        FastBoostEvaluator evaluator = EVALUATORS.get(evalKey);
        if (evaluator == null) {
            return null;
        }
        String numSuffix = evalKeyEnd != macroName.length() ? macroName.substring(evalKeyEnd) : "";
        return evaluator.trySubstitute(pp, params, paramIndices, paramSubst, substitutionMap, numSuffix);
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastTupleElem(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        String tupleText;
        String idxText;
        int paramSize;
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(6);
        }
        if (params == null) {
            OCBoostPPHelper.$$$reportNull$$$0(7);
        }
        if (paramIndices == null) {
            OCBoostPPHelper.$$$reportNull$$$0(8);
        }
        if (paramSubst == null) {
            OCBoostPPHelper.$$$reportNull$$$0(9);
        }
        if (substitutionMap == null) {
            OCBoostPPHelper.$$$reportNull$$$0(10);
        }
        if (numSuffix == null) {
            OCBoostPPHelper.$$$reportNull$$$0(11);
        }
        if ((paramSize = params.size()) != 1 && paramSize != 3) {
            return null;
        }
        boolean isVariadic = paramSize == 1;
        int limitTuple = OCBoostPPHelper.tryParseAsBoostInt(pp.preprocess("BOOST_PP_LIMIT_TUPLE", OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG));
        if (limitTuple < 0) {
            return null;
        }
        int size = -1;
        if (isVariadic) {
            String paramText = paramSubst.get(params.get(0));
            List<String> paramTuple = OCBoostPPHelper.tryParseAsBoostTupleContents(paramText);
            if (paramTuple == null || paramTuple.size() < 2 || paramTuple.size() > 3) {
                return null;
            }
            boolean hasSize = paramTuple.size() == 3;
            idxText = pp.preprocess(paramTuple.get(hasSize ? 1 : 0), OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG);
            tupleText = pp.preprocess(paramTuple.get(hasSize ? 2 : 1), OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG);
        } else {
            String sizeText = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(0));
            size = OCBoostPPHelper.tryParseAsBoostInt(sizeText);
            if (size < 0 || size > limitTuple) {
                return null;
            }
            idxText = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(1));
            tupleText = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(2));
        }
        int idx = OCBoostPPHelper.tryParseAsBoostInt(idxText);
        if (idx < 0 || idx >= limitTuple) {
            return null;
        }
        List<String> tuple = OCBoostPPHelper.tryParseAsBoostTuple(tupleText);
        if (tuple == null) {
            return null;
        }
        if (tuple.size() <= idx || !isVariadic && tuple.size() != size) {
            return null;
        }
        OCPreprocessingLexer.SubstitutionResult result = new OCPreprocessingLexer.SubstitutionResult();
        result.append(tuple.get(idx));
        return result;
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastListFoldLeft(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(12);
        }
        if (params == null) {
            OCBoostPPHelper.$$$reportNull$$$0(13);
        }
        if (paramIndices == null) {
            OCBoostPPHelper.$$$reportNull$$$0(14);
        }
        if (paramSubst == null) {
            OCBoostPPHelper.$$$reportNull$$$0(15);
        }
        if (substitutionMap == null) {
            OCBoostPPHelper.$$$reportNull$$$0(16);
        }
        if (numSuffix == null) {
            OCBoostPPHelper.$$$reportNull$$$0(17);
        }
        return OCBoostPPHelper.tryFastListFold(pp, params, paramIndices, paramSubst, substitutionMap, numSuffix, true);
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastListFoldRight(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(18);
        }
        if (params == null) {
            OCBoostPPHelper.$$$reportNull$$$0(19);
        }
        if (paramIndices == null) {
            OCBoostPPHelper.$$$reportNull$$$0(20);
        }
        if (paramSubst == null) {
            OCBoostPPHelper.$$$reportNull$$$0(21);
        }
        if (substitutionMap == null) {
            OCBoostPPHelper.$$$reportNull$$$0(22);
        }
        if (numSuffix == null) {
            OCBoostPPHelper.$$$reportNull$$$0(23);
        }
        return OCBoostPPHelper.tryFastListFold(pp, params, paramIndices, paramSubst, substitutionMap, numSuffix, false);
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastListFold(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix, boolean isLeft) {
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(24);
        }
        if (params == null) {
            OCBoostPPHelper.$$$reportNull$$$0(25);
        }
        if (paramIndices == null) {
            OCBoostPPHelper.$$$reportNull$$$0(26);
        }
        if (paramSubst == null) {
            OCBoostPPHelper.$$$reportNull$$$0(27);
        }
        if (substitutionMap == null) {
            OCBoostPPHelper.$$$reportNull$$$0(28);
        }
        if (numSuffix == null) {
            OCBoostPPHelper.$$$reportNull$$$0(29);
        }
        if (params.size() != 3) {
            return null;
        }
        int limitMag = OCBoostPPHelper.tryParseAsBoostInt(pp.preprocess("BOOST_PP_LIMIT_MAG", OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG));
        if (limitMag < 0) {
            return null;
        }
        int s = OCBoostPPHelper.tryParseAsBoostInt(numSuffix);
        if (s < 1 || s > limitMag) {
            return null;
        }
        String op = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(0));
        String state = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(1));
        String listParam = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(2));
        List<String> list = OCBoostPPHelper.tryParseAsBoostList(listParam);
        if (list == null) {
            return null;
        }
        if (s + list.size() > limitMag) {
            return null;
        }
        return OCBoostPPHelper.foldList(pp, isLeft, s, op, state, list, "BOOST_PP_LIST_FOLD_LEFT_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static OCPreprocessingLexer.SubstitutionResult foldList(@NotNull OCPreprocessingLexer pp, boolean isLeft, int step, @NotNull String operation, @NotNull String state, @NotNull List<String> list, @NlsSafe @NotNull String macroCheckName) {
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(30);
        }
        if (operation == null) {
            OCBoostPPHelper.$$$reportNull$$$0(31);
        }
        if (state == null) {
            OCBoostPPHelper.$$$reportNull$$$0(32);
        }
        if (list == null) {
            OCBoostPPHelper.$$$reportNull$$$0(33);
        }
        if (macroCheckName == null) {
            OCBoostPPHelper.$$$reportNull$$$0(34);
        }
        ArrayList<Object> undef = new ArrayList<Object>();
        try {
            int n;
            Object undefM = macroCheckName + step;
            undef.add(undefM);
            pp.hideDefinition((String)undefM);
            boolean bl = false;
            while (n < list.size()) {
                undefM = macroCheckName + step;
                undef.add(undefM);
                pp.hideDefinition((String)undefM);
                String elem = list.get(isLeft ? n : list.size() - n - 1);
                String text = operation + "(" + ++step + ", " + state + ", " + elem + ")";
                state = pp.preprocess(text, OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG);
                ++n;
            }
        }
        finally {
            for (String string : undef) {
                pp.revealDefinition(string);
            }
        }
        OCPreprocessingLexer.SubstitutionResult result = new OCPreprocessingLexer.SubstitutionResult();
        result.append(state);
        OCPreprocessingLexer.SubstitutionResult substitutionResult = result;
        if (substitutionResult == null) {
            OCBoostPPHelper.$$$reportNull$$$0(35);
        }
        return substitutionResult;
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastSeqFoldLeft(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(36);
        }
        if (params == null) {
            OCBoostPPHelper.$$$reportNull$$$0(37);
        }
        if (paramIndices == null) {
            OCBoostPPHelper.$$$reportNull$$$0(38);
        }
        if (paramSubst == null) {
            OCBoostPPHelper.$$$reportNull$$$0(39);
        }
        if (substitutionMap == null) {
            OCBoostPPHelper.$$$reportNull$$$0(40);
        }
        if (numSuffix == null) {
            OCBoostPPHelper.$$$reportNull$$$0(41);
        }
        return OCBoostPPHelper.tryFastSeqFold(pp, params, paramIndices, paramSubst, substitutionMap, numSuffix, true);
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastSeqFoldRight(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(42);
        }
        if (params == null) {
            OCBoostPPHelper.$$$reportNull$$$0(43);
        }
        if (paramIndices == null) {
            OCBoostPPHelper.$$$reportNull$$$0(44);
        }
        if (paramSubst == null) {
            OCBoostPPHelper.$$$reportNull$$$0(45);
        }
        if (substitutionMap == null) {
            OCBoostPPHelper.$$$reportNull$$$0(46);
        }
        if (numSuffix == null) {
            OCBoostPPHelper.$$$reportNull$$$0(47);
        }
        return OCBoostPPHelper.tryFastSeqFold(pp, params, paramIndices, paramSubst, substitutionMap, numSuffix, false);
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastSeqFold(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix, boolean isLeft) {
        int iterLimit;
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(48);
        }
        if (params == null) {
            OCBoostPPHelper.$$$reportNull$$$0(49);
        }
        if (paramIndices == null) {
            OCBoostPPHelper.$$$reportNull$$$0(50);
        }
        if (paramSubst == null) {
            OCBoostPPHelper.$$$reportNull$$$0(51);
        }
        if (substitutionMap == null) {
            OCBoostPPHelper.$$$reportNull$$$0(52);
        }
        if (numSuffix == null) {
            OCBoostPPHelper.$$$reportNull$$$0(53);
        }
        if (params.size() != 3) {
            return null;
        }
        int limitMag = OCBoostPPHelper.tryParseAsBoostInt(pp.preprocess("BOOST_PP_LIMIT_MAG", OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG));
        if (limitMag < 0) {
            return null;
        }
        int s = OCBoostPPHelper.tryParseAsBoostInt(numSuffix);
        if (s < 1 || s > limitMag) {
            return null;
        }
        String op = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(0));
        String state = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(1));
        String seqParam = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(2));
        List<String> seq = OCBoostPPHelper.tryParseAsBoostSequence(seqParam);
        if (seq == null || seq.isEmpty()) {
            return null;
        }
        int n = iterLimit = isLeft ? limitMag + 1 : limitMag;
        if (s + seq.size() > iterLimit) {
            return null;
        }
        return OCBoostPPHelper.foldList(pp, isLeft, s, op, state, seq, "BOOST_PP_SEQ_FOLD_LEFT_I_");
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastFor(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(54);
        }
        if (params == null) {
            OCBoostPPHelper.$$$reportNull$$$0(55);
        }
        if (paramIndices == null) {
            OCBoostPPHelper.$$$reportNull$$$0(56);
        }
        if (paramSubst == null) {
            OCBoostPPHelper.$$$reportNull$$$0(57);
        }
        if (substitutionMap == null) {
            OCBoostPPHelper.$$$reportNull$$$0(58);
        }
        if (numSuffix == null) {
            OCBoostPPHelper.$$$reportNull$$$0(59);
        }
        if (params.size() != 4) {
            return null;
        }
        int r = OCBoostPPHelper.tryParseAsBoostInt(numSuffix);
        if (r < 1) {
            return null;
        }
        int limitMag = OCBoostPPHelper.tryParseAsBoostInt(pp.preprocess("BOOST_PP_LIMIT_MAG", OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG));
        if (limitMag < 0) {
            return null;
        }
        int iterLimit = limitMag + 1;
        if (r > iterLimit) {
            return null;
        }
        String state = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(0));
        String pred = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(1));
        String op = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(2));
        String forMacro = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(3));
        OCPreprocessingLexer.SubstitutionResult result = new OCPreprocessingLexer.SubstitutionResult();
        @NlsSafe String macroCheckBase = "BOOST_PP_FOR_";
        ArrayList<CallSite> hiddenDefs = new ArrayList<CallSite>();
        try {
            while (true) {
                OCPreprocessingLexer.SubstitutionResult substitutionResult;
                String macroCheck = macroCheckBase + r;
                hiddenDefs.add((CallSite)((Object)macroCheck));
                pp.hideDefinition(macroCheck);
                String predCall = pred + "(" + ++r + "," + state + ")";
                String predPP = pp.preprocess(predCall, OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG);
                int predR = OCBoostPPHelper.tryParseAsBoostInt(predPP);
                if (predR < 0 || predR > limitMag) {
                    substitutionResult = null;
                    return substitutionResult;
                }
                if (predR == 0) {
                    substitutionResult = result;
                    return substitutionResult;
                }
                if (r > iterLimit) {
                    substitutionResult = null;
                    return substitutionResult;
                }
                String forMacroCall = forMacro + "(" + r + ", " + state + ")";
                String forMacroPP = pp.preprocess(forMacroCall, OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG);
                result.append(forMacroPP);
                result.append(" ");
                String string = op + "(" + r + ", " + state + ")";
                state = pp.preprocess(string, OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG);
            }
        }
        finally {
            for (String string : hiddenDefs) {
                pp.revealDefinition(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastRepeat(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(60);
        }
        if (params == null) {
            OCBoostPPHelper.$$$reportNull$$$0(61);
        }
        if (paramIndices == null) {
            OCBoostPPHelper.$$$reportNull$$$0(62);
        }
        if (paramSubst == null) {
            OCBoostPPHelper.$$$reportNull$$$0(63);
        }
        if (substitutionMap == null) {
            OCBoostPPHelper.$$$reportNull$$$0(64);
        }
        if (numSuffix == null) {
            OCBoostPPHelper.$$$reportNull$$$0(65);
        }
        if (params.size() != 3) {
            return null;
        }
        int z = OCBoostPPHelper.tryParseAsBoostInt(numSuffix);
        if (z < 1 || z > 3) {
            return null;
        }
        int limitRepeat = OCBoostPPHelper.tryParseAsBoostInt(pp.preprocess("BOOST_PP_LIMIT_REPEAT", OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG));
        if (limitRepeat < 0) {
            return null;
        }
        String countText = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(0));
        int count = OCBoostPPHelper.tryParseAsBoostInt(countText);
        if (count < 0 || count > limitRepeat) {
            return null;
        }
        String op = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(1));
        String data = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(2));
        OCPreprocessingLexer.SubstitutionResult result = new OCPreprocessingLexer.SubstitutionResult();
        @NlsSafe String macroCheckName = "BOOST_PP_REPEAT_" + z;
        pp.hideDefinition(macroCheckName);
        try {
            for (int i = 0; i < count; ++i) {
                String callText = op + "(" + (z + 1) + ", " + i + ", " + data + ")";
                String callResult = pp.preprocess(callText, OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG);
                result.append(callResult);
                result.append(" ");
            }
        }
        finally {
            pp.revealDefinition(macroCheckName);
        }
        return result;
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastWhile(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(66);
        }
        if (params == null) {
            OCBoostPPHelper.$$$reportNull$$$0(67);
        }
        if (paramIndices == null) {
            OCBoostPPHelper.$$$reportNull$$$0(68);
        }
        if (paramSubst == null) {
            OCBoostPPHelper.$$$reportNull$$$0(69);
        }
        if (substitutionMap == null) {
            OCBoostPPHelper.$$$reportNull$$$0(70);
        }
        if (numSuffix == null) {
            OCBoostPPHelper.$$$reportNull$$$0(71);
        }
        if (params.size() != 3) {
            return null;
        }
        int limitMag = OCBoostPPHelper.tryParseAsBoostInt(pp.preprocess("BOOST_PP_LIMIT_MAG", OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG));
        if (limitMag < 0) {
            return null;
        }
        int d = OCBoostPPHelper.tryParseAsBoostInt(numSuffix);
        if (d < 1 || d > limitMag) {
            return null;
        }
        String pred = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(0));
        String op = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(1));
        String state = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, params.get(2));
        ArrayList<CallSite> undef = new ArrayList<CallSite>();
        try {
            while (true) {
                @NlsSafe String toHide = "BOOST_PP_WHILE_" + d;
                undef.add((CallSite)((Object)toHide));
                pp.hideDefinition(toHide);
                String predExpr = pred + "(" + ++d + "," + state + ")";
                String predPP = pp.preprocess(predExpr, OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG);
                int pr = OCBoostPPHelper.tryParseAsBoostInt(predPP);
                if (pr < 0 || pr > limitMag) {
                    OCPreprocessingLexer.SubstitutionResult substitutionResult = null;
                    return substitutionResult;
                }
                if (pr == 0) {
                    OCPreprocessingLexer.SubstitutionResult r = new OCPreprocessingLexer.SubstitutionResult();
                    r.append(state);
                    OCPreprocessingLexer.SubstitutionResult substitutionResult = r;
                    return substitutionResult;
                }
                String opExpr = op + "(" + d + ", " + state + ")";
                state = pp.preprocess(opExpr, OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG);
                if (d <= limitMag) continue;
                OCPreprocessingLexer.SubstitutionResult substitutionResult = null;
                return substitutionResult;
            }
        }
        finally {
            for (String string : undef) {
                pp.revealDefinition(string);
            }
        }
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastSub(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(72);
        }
        if (params == null) {
            OCBoostPPHelper.$$$reportNull$$$0(73);
        }
        if (paramIndices == null) {
            OCBoostPPHelper.$$$reportNull$$$0(74);
        }
        if (paramSubst == null) {
            OCBoostPPHelper.$$$reportNull$$$0(75);
        }
        if (substitutionMap == null) {
            OCBoostPPHelper.$$$reportNull$$$0(76);
        }
        if (numSuffix == null) {
            OCBoostPPHelper.$$$reportNull$$$0(77);
        }
        return OCBoostPPHelper.tryFastSubInt(pp, params, paramIndices, paramSubst, substitutionMap, false);
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastSubD(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(78);
        }
        if (params == null) {
            OCBoostPPHelper.$$$reportNull$$$0(79);
        }
        if (paramIndices == null) {
            OCBoostPPHelper.$$$reportNull$$$0(80);
        }
        if (paramSubst == null) {
            OCBoostPPHelper.$$$reportNull$$$0(81);
        }
        if (substitutionMap == null) {
            OCBoostPPHelper.$$$reportNull$$$0(82);
        }
        if (numSuffix == null) {
            OCBoostPPHelper.$$$reportNull$$$0(83);
        }
        return OCBoostPPHelper.tryFastSubInt(pp, params, paramIndices, paramSubst, substitutionMap, true);
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastSubInt(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, boolean isDVersion) {
        int d;
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(84);
        }
        if (params == null) {
            OCBoostPPHelper.$$$reportNull$$$0(85);
        }
        if (paramIndices == null) {
            OCBoostPPHelper.$$$reportNull$$$0(86);
        }
        if (paramSubst == null) {
            OCBoostPPHelper.$$$reportNull$$$0(87);
        }
        if (substitutionMap == null) {
            OCBoostPPHelper.$$$reportNull$$$0(88);
        }
        if (params.size() != (isDVersion ? 3 : 2)) {
            return null;
        }
        int limit = OCBoostPPHelper.tryParseAsBoostInt(pp.preprocess("BOOST_PP_LIMIT_MAG", OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG));
        if (limit < 0) {
            return null;
        }
        int n = d = isDVersion ? OCBoostPPHelper.trySubstituteParamAsInt(pp, paramIndices, paramSubst, substitutionMap, params.get(0)) : 1;
        if (d < 1) {
            return null;
        }
        int x = OCBoostPPHelper.trySubstituteParamAsInt(pp, paramIndices, paramSubst, substitutionMap, params.get(isDVersion ? 1 : 0));
        if (x < 0 || x > limit + 1) {
            return null;
        }
        int y = OCBoostPPHelper.trySubstituteParamAsInt(pp, paramIndices, paramSubst, substitutionMap, params.get(isDVersion ? 2 : 1));
        if (y < 0 || y + d > limit) {
            return null;
        }
        OCPreprocessingLexer.SubstitutionResult r = new OCPreprocessingLexer.SubstitutionResult();
        r.append(Integer.toString(Math.max(x - y, 0)));
        return r;
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastAddD(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(89);
        }
        if (params == null) {
            OCBoostPPHelper.$$$reportNull$$$0(90);
        }
        if (paramIndices == null) {
            OCBoostPPHelper.$$$reportNull$$$0(91);
        }
        if (paramSubst == null) {
            OCBoostPPHelper.$$$reportNull$$$0(92);
        }
        if (substitutionMap == null) {
            OCBoostPPHelper.$$$reportNull$$$0(93);
        }
        if (numSuffix == null) {
            OCBoostPPHelper.$$$reportNull$$$0(94);
        }
        return OCBoostPPHelper.tryFastAddInt(pp, params, paramIndices, paramSubst, substitutionMap, true);
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastAdd(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String numSuffix) {
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(95);
        }
        if (params == null) {
            OCBoostPPHelper.$$$reportNull$$$0(96);
        }
        if (paramIndices == null) {
            OCBoostPPHelper.$$$reportNull$$$0(97);
        }
        if (paramSubst == null) {
            OCBoostPPHelper.$$$reportNull$$$0(98);
        }
        if (substitutionMap == null) {
            OCBoostPPHelper.$$$reportNull$$$0(99);
        }
        if (numSuffix == null) {
            OCBoostPPHelper.$$$reportNull$$$0(100);
        }
        return OCBoostPPHelper.tryFastAddInt(pp, params, paramIndices, paramSubst, substitutionMap, false);
    }

    @Nullable
    private static OCPreprocessingLexer.SubstitutionResult tryFastAddInt(@NotNull OCPreprocessingLexer pp, @NotNull List<String> params, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, boolean isDVersion) {
        int d;
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(101);
        }
        if (params == null) {
            OCBoostPPHelper.$$$reportNull$$$0(102);
        }
        if (paramIndices == null) {
            OCBoostPPHelper.$$$reportNull$$$0(103);
        }
        if (paramSubst == null) {
            OCBoostPPHelper.$$$reportNull$$$0(104);
        }
        if (substitutionMap == null) {
            OCBoostPPHelper.$$$reportNull$$$0(105);
        }
        if (params.size() != (isDVersion ? 3 : 2)) {
            return null;
        }
        int limit = OCBoostPPHelper.tryParseAsBoostInt(pp.preprocess("BOOST_PP_LIMIT_MAG", OCPreprocessingLexer.PreprocessingMode.FIRST_MACRO_ARG));
        if (limit < 0) {
            return null;
        }
        int n = d = isDVersion ? OCBoostPPHelper.trySubstituteParamAsInt(pp, paramIndices, paramSubst, substitutionMap, params.get(0)) : 1;
        if (d < 1) {
            return null;
        }
        String xParam = params.get(isDVersion ? 1 : 0);
        int x = OCBoostPPHelper.trySubstituteParamAsInt(pp, paramIndices, paramSubst, substitutionMap, xParam);
        if (x < 0 || x > limit) {
            return null;
        }
        String yParam = params.get(isDVersion ? 2 : 1);
        int y = OCBoostPPHelper.trySubstituteParamAsInt(pp, paramIndices, paramSubst, substitutionMap, yParam);
        if (y < 0 || y + d > limit) {
            return null;
        }
        OCPreprocessingLexer.SubstitutionResult r = new OCPreprocessingLexer.SubstitutionResult();
        r.append(Integer.toString(Math.min(x + y, limit)));
        return r;
    }

    private static List<String> tryParseAsBoostTuple(String tupleText) {
        if (!(tupleText = tupleText.trim()).startsWith("(") || !tupleText.endsWith(")")) {
            return null;
        }
        return OCBoostPPHelper.tryParseAsBoostTupleContents(tupleText.substring(1, tupleText.length() - 1));
    }

    @Nullable
    private static List<String> tryParseAsBoostTupleContents(String tupleContents) {
        ArrayList<String> result = new ArrayList<String>();
        int parenDepth = 0;
        int elemStart = 0;
        for (int i = 0; i < tupleContents.length(); ++i) {
            char c = tupleContents.charAt(i);
            if (c == ',') {
                if (parenDepth != 0) continue;
                result.add(tupleContents.substring(elemStart, i).trim());
                elemStart = i + 1;
                continue;
            }
            if (c == '(') {
                ++parenDepth;
                continue;
            }
            if (c != ')') continue;
            if (parenDepth == 0) {
                return null;
            }
            --parenDepth;
        }
        result.add(tupleContents.substring(elemStart).trim());
        return result;
    }

    @Nullable
    private static List<String> tryParseAsBoostList(@NotNull String str) {
        if (str == null) {
            OCBoostPPHelper.$$$reportNull$$$0(106);
        }
        ArrayList<String> result = new ArrayList<String>();
        if ("BOOST_PP_NIL".equals(str = str.trim())) {
            return Collections.emptyList();
        }
        int parenDepth = 0;
        int subseqStart = 0;
        boolean atElement = false;
        boolean hasNonWs = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '(') {
                if (parenDepth < result.size()) {
                    return null;
                }
                if (parenDepth == result.size()) {
                    if (hasNonWs) {
                        return null;
                    }
                    subseqStart = i + 1;
                    atElement = true;
                }
                ++parenDepth;
                continue;
            }
            if (c == ')') {
                if (parenDepth == 0) {
                    return null;
                }
                if (parenDepth == result.size()) {
                    result.add(str.substring(subseqStart, i));
                }
                --parenDepth;
                continue;
            }
            if (c == ',') {
                if (!atElement) {
                    return null;
                }
                if (parenDepth != result.size() + 1) continue;
                result.add(str.substring(subseqStart, i));
                subseqStart = i + 1;
                atElement = false;
                hasNonWs = false;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            if (parenDepth < result.size()) {
                return null;
            }
            hasNonWs = true;
        }
        if (parenDepth != 0 || result.isEmpty()) {
            return null;
        }
        String last = ((String)result.remove(result.size() - 1)).trim();
        return "BOOST_PP_NIL".equals(last) ? result : null;
    }

    private static List<String> tryParseAsBoostSequence(String seqString) {
        ArrayList<String> r = new ArrayList<String>();
        int inElem = 0;
        int elemStart = 0;
        seqString = seqString.trim();
        for (int i = 0; i < seqString.length(); ++i) {
            char c = seqString.charAt(i);
            if (c == '(') {
                if (inElem == 0) {
                    elemStart = i + 1;
                }
                ++inElem;
                continue;
            }
            if (c == ')') {
                if (inElem == 0) {
                    return null;
                }
                if (--inElem != 0) continue;
                r.add(seqString.substring(elemStart, i));
                continue;
            }
            if (inElem != 0 || Character.isWhitespace(c)) continue;
            return null;
        }
        return r;
    }

    private static int trySubstituteParamAsInt(@NotNull OCPreprocessingLexer pp, @NotNull Map<String, Integer> paramIndices, @NotNull Map<String, String> paramSubst, @NotNull Map<String, String> substitutionMap, @NotNull String param) {
        if (pp == null) {
            OCBoostPPHelper.$$$reportNull$$$0(107);
        }
        if (paramIndices == null) {
            OCBoostPPHelper.$$$reportNull$$$0(108);
        }
        if (paramSubst == null) {
            OCBoostPPHelper.$$$reportNull$$$0(109);
        }
        if (substitutionMap == null) {
            OCBoostPPHelper.$$$reportNull$$$0(110);
        }
        if (param == null) {
            OCBoostPPHelper.$$$reportNull$$$0(111);
        }
        String str = pp.substituteMacroParam(paramIndices, paramSubst, substitutionMap, param);
        return OCBoostPPHelper.tryParseAsBoostInt(str);
    }

    private static int tryParseAsBoostInt(String str) {
        if ((str = str.trim()).length() > 1 && str.startsWith("0")) {
            return -1;
        }
        return StringUtil.parseInt((String)str, (int)-1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macro";
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 19: 
            case 25: 
            case 37: 
            case 43: 
            case 49: 
            case 55: 
            case 61: 
            case 67: 
            case 73: 
            case 79: 
            case 85: 
            case 90: 
            case 96: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 3: 
            case 8: 
            case 14: 
            case 20: 
            case 26: 
            case 38: 
            case 44: 
            case 50: 
            case 56: 
            case 62: 
            case 68: 
            case 74: 
            case 80: 
            case 86: 
            case 91: 
            case 97: 
            case 103: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramIndices";
                break;
            }
            case 4: 
            case 9: 
            case 15: 
            case 21: 
            case 27: 
            case 39: 
            case 45: 
            case 51: 
            case 57: 
            case 63: 
            case 69: 
            case 75: 
            case 81: 
            case 87: 
            case 92: 
            case 98: 
            case 104: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramSubst";
                break;
            }
            case 5: 
            case 10: 
            case 16: 
            case 22: 
            case 28: 
            case 40: 
            case 46: 
            case 52: 
            case 58: 
            case 64: 
            case 70: 
            case 76: 
            case 82: 
            case 88: 
            case 93: 
            case 99: 
            case 105: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutionMap";
                break;
            }
            case 11: 
            case 17: 
            case 23: 
            case 29: 
            case 41: 
            case 47: 
            case 53: 
            case 59: 
            case 65: 
            case 71: 
            case 77: 
            case 83: 
            case 94: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "numSuffix";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroCheckName";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCBoostPPHelper";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCBoostPPHelper";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "foldList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryFastSubstitution";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryFastTupleElem";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryFastListFoldLeft";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "tryFastListFoldRight";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "tryFastListFold";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "foldList";
                break;
            }
            case 35: {
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "tryFastSeqFoldLeft";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "tryFastSeqFoldRight";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "tryFastSeqFold";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "tryFastFor";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "tryFastRepeat";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "tryFastWhile";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "tryFastSub";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "tryFastSubD";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "tryFastSubInt";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "tryFastAddD";
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "tryFastAdd";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "tryFastAddInt";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "tryParseAsBoostList";
                break;
            }
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "trySubstituteParamAsInt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 35 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    static interface FastBoostEvaluator {
        public OCPreprocessingLexer.SubstitutionResult trySubstitute(@NotNull OCPreprocessingLexer var1, @NotNull List<String> var2, @NotNull Map<String, Integer> var3, @NotNull Map<String, String> var4, @NotNull Map<String, String> var5, @NotNull String var6);
    }
}

