/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.navigation.OCGotoActionSync;
import com.jetbrains.cidr.lang.navigation.OCLineMarkerProvider;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import icons.CidrLangIcons;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGotoRelatedSymbolActionSync
extends OCGotoActionSync<OCSymbolDeclarator<?>> {
    private @NlsContexts.PopupTitle String myPopupTitle;
    private @NlsContexts.Tooltip String myTooltip;

    public OCGotoRelatedSymbolActionSync(@NotNull OCSymbolDeclarator<?> element) {
        if (element == null) {
            OCGotoRelatedSymbolActionSync.$$$reportNull$$$0(0);
        }
        super(element, CidrLangIcons.AssocFile);
        this.myPopupTitle = OCBundle.message("action.CIDR.Lang.goto.definition.declaration", new Object[0]);
        this.myTooltip = OCBundle.message("action.CIDR.Lang.goto.definition.declaration.tooltip", new Object[0]);
    }

    @Override
    @NotNull
    public String getTooltip() {
        String string = this.myTooltip;
        if (string == null) {
            OCGotoRelatedSymbolActionSync.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPopupTitle() {
        String string = this.myPopupTitle;
        if (string == null) {
            OCGotoRelatedSymbolActionSync.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected List<OCSymbol> evaluateTargets(@NotNull OCSymbolDeclarator<?> source) {
        if (source == null) {
            OCGotoRelatedSymbolActionSync.$$$reportNull$$$0(3);
        }
        Object symbol = source.getSymbol();
        Project project = source.getProject();
        OCSymbol relatedSymbol = OCLineMarkerProvider.getRelatedSymbol(symbol, project);
        List relatedSymbols = symbol instanceof OCStructSymbol ? OCSearchUtil.getRelatedSymbols((OCStructSymbol)symbol, true, project) : Collections.emptyList();
        this.updatePopupTitleAndTooltip((OCSymbol)symbol, relatedSymbol, relatedSymbols, project);
        List list = relatedSymbols.isEmpty() ? ContainerUtil.createMaybeSingletonList((Object)relatedSymbol) : relatedSymbols;
        if (list == null) {
            OCGotoRelatedSymbolActionSync.$$$reportNull$$$0(4);
        }
        return list;
    }

    private void updatePopupTitleAndTooltip(@Nullable OCSymbol symbol, @Nullable OCSymbol relatedSymbol, @NotNull List<OCSymbol> relatedSymbols, @NotNull Project project) {
        if (relatedSymbols == null) {
            OCGotoRelatedSymbolActionSync.$$$reportNull$$$0(5);
        }
        if (project == null) {
            OCGotoRelatedSymbolActionSync.$$$reportNull$$$0(6);
        }
        if (!relatedSymbols.isEmpty()) {
            this.myPopupTitle = OCBundle.message("goto.related.symbol.name1", new Object[0]);
            this.myTooltip = OCBundle.message("goto.related.symbol.name1.tooltip", new Object[0]);
        } else if (symbol == null || relatedSymbol == null) {
            this.myPopupTitle = OCBundle.message("goto.symbol", new Object[0]);
            this.myTooltip = OCBundle.message("goto.symbol", new Object[0]);
        } else if (relatedSymbol.getKind().isClass()) {
            this.myPopupTitle = OCBundle.message("goto.related.symbol.name2", relatedSymbol.getKind().getNameLowercase(), relatedSymbol.getName());
            this.myTooltip = OCBundle.message("goto.related.symbol.name2.tooltip", relatedSymbol.getKind().getNameLowercase(), relatedSymbol.getName());
        } else if (relatedSymbol instanceof OCStructSymbol && relatedSymbol.isPredeclaration()) {
            String relatedSymbolNameWithKindLowercase = relatedSymbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, project));
            this.myPopupTitle = OCBundle.message("goto.related.symbol.name3", relatedSymbolNameWithKindLowercase);
            this.myTooltip = OCBundle.message("goto.related.symbol.name3.tooltip", relatedSymbolNameWithKindLowercase);
        } else if (relatedSymbol.getKind() == symbol.getKind()) {
            String relatedSymbolNameWithKindLowercase = relatedSymbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, project));
            if (relatedSymbol.isDefinition()) {
                this.myPopupTitle = OCBundle.message("goto.related.symbol.name4", relatedSymbolNameWithKindLowercase);
                this.myTooltip = OCBundle.message("goto.related.symbol.name4.tooltip", relatedSymbolNameWithKindLowercase);
            } else {
                this.myPopupTitle = OCBundle.message("goto.related.symbol.name5", relatedSymbolNameWithKindLowercase);
                this.myTooltip = OCBundle.message("goto.related.symbol.name5.tooltip", relatedSymbolNameWithKindLowercase);
            }
        } else {
            this.myPopupTitle = OCBundle.message("goto.related.symbol.name6", new Object[]{relatedSymbol.getKind()});
            this.myTooltip = OCBundle.message("goto.related.symbol.name6.tooltip", new Object[]{relatedSymbol.getKind()});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/navigation/OCGotoRelatedSymbolActionSync";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relatedSymbols";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/navigation/OCGotoRelatedSymbolActionSync";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltip";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupTitle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTargets";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updatePopupTitleAndTooltip";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4 -> new IllegalStateException(string);
        };
    }
}

