/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import com.jetbrains.cidr.lang.navigation.OCSymbolNavigationItem;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCForeignSymbol;
import com.jetbrains.cidr.lang.symbols.OCNonNavigatableSymbol;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCGotoByNameContributor
implements GotoClassContributor,
ChooseByNameContributorEx {
    private static final boolean ourGotoContributorsEnabled = Registry.is((String)"cidr.enable.goto.contributors", (boolean)true);

    public void processNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor2 == null) {
            OCGotoByNameContributor.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            OCGotoByNameContributor.$$$reportNull$$$0(1);
        }
        if (!ourGotoContributorsEnabled) {
            return;
        }
        Project project = Objects.requireNonNull(scope.getProject());
        if (!ContainerUtil.process(OCGlobalProjectSymbolsCache.getAllSymbolNames(project), processor2)) {
            return;
        }
        OCGlobalProjectSymbolsCache.getAllCategories(project).processAllValues(o -> o instanceof OCNonNavigatableSymbol || processor2.process((Object)(o.getName() + "+" + o.getCategoryName())));
    }

    public void processElementsWithName(@NotNull String name, @NotNull Processor<? super NavigationItem> processor2, @NotNull FindSymbolParameters parameters) {
        if (name == null) {
            OCGotoByNameContributor.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            OCGotoByNameContributor.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            OCGotoByNameContributor.$$$reportNull$$$0(4);
        }
        if (!ourGotoContributorsEnabled) {
            return;
        }
        GlobalSearchScope scope0 = parameters.getSearchScope();
        GlobalSearchScope scope = scope0.isSearchInLibraries() ? scope0 : scope0.intersectWith(OCSearchScope.getProjectSourcesScope(parameters.getProject()));
        this.processSymbolsByName(name, processor2, parameters.getProject(), scope, (Condition<OCSymbol>)((Condition)symbol -> symbol instanceof OCImplementationSymbol), false);
    }

    protected abstract boolean filterSymbol(@NotNull Project var1, @NotNull OCSymbol var2);

    public void processSymbolsByName(@NotNull String name, @NotNull Processor<? super OCSymbolNavigationItem> processor2, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Condition<OCSymbol> condition, boolean isStrict) {
        if (name == null) {
            OCGotoByNameContributor.$$$reportNull$$$0(5);
        }
        if (processor2 == null) {
            OCGotoByNameContributor.$$$reportNull$$$0(6);
        }
        if (project == null) {
            OCGotoByNameContributor.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            OCGotoByNameContributor.$$$reportNull$$$0(8);
        }
        if (condition == null) {
            OCGotoByNameContributor.$$$reportNull$$$0(9);
        }
        HashSet implementations = new HashSet();
        Processor innerProcessor = ocSymbol -> {
            if (ocSymbol instanceof OCUsingSymbol) {
                return true;
            }
            if (ocSymbol.getKind().isType() && ocSymbol.isPredeclaration()) {
                return true;
            }
            if (ocSymbol instanceof OCForeignSymbol) {
                return true;
            }
            if (ocSymbol.isSynthetic()) {
                return true;
            }
            if (ocSymbol instanceof OCInterfaceSymbol && implementations.contains(ocSymbol.getPresentableName())) {
                return true;
            }
            VirtualFile file = ocSymbol.getContainingFile();
            if (file != null && this.filterSymbol(project, (OCSymbol)ocSymbol) && scope.contains(file)) {
                if (!processor2.process((Object)new OCSymbolNavigationItem((OCSymbol)ocSymbol, project))) {
                    return false;
                }
                if (ocSymbol instanceof OCImplementationSymbol) {
                    implementations.add(ocSymbol.getPresentableName());
                }
            }
            return true;
        };
        OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor(innerProcessor, condition, isStrict ? Conditions.alwaysFalse() : Conditions.alwaysTrue());
        int plus = name.indexOf(43);
        if (plus != -1) {
            String className = name.substring(0, plus).trim();
            String categoryName = name.substring(plus + 1).trim();
            OCGlobalProjectSymbolsCache.processSymbolsByCategory(project, (Processor<? super OCSymbol>)Processors.filter(orderedProcessor, o -> o instanceof OCClassSymbol && o.getName().equals(className)), categoryName);
        } else {
            OCGlobalProjectSymbolsCache.processByQualifiedName(project, orderedProcessor, name);
            OCGlobalProjectSymbolsCache.processSymbolsByCategory(project, orderedProcessor, name);
        }
        orderedProcessor.finish();
    }

    @Nullable
    public String getQualifiedName(@NotNull NavigationItem item) {
        if (item == null) {
            OCGotoByNameContributor.$$$reportNull$$$0(10);
        }
        OCSymbol symbol = null;
        Project project = null;
        if (item instanceof OCSymbolHolderVirtualPsiElement) {
            symbol = (OCSymbol)((OCSymbolHolderVirtualPsiElement)item).getSymbol();
            project = ((OCSymbolHolderVirtualPsiElement)item).getProject();
        } else if (item instanceof OCSymbolNavigationItem) {
            symbol = ((OCSymbolNavigationItem)item).getSymbol();
            project = ((OCSymbolNavigationItem)item).getProject();
        }
        if (symbol instanceof OCSymbolWithQualifiedName) {
            OCResolveContext context;
            OCQualifiedName qualifiedName;
            OCSymbolWithQualifiedName qnSymbol = (OCSymbolWithQualifiedName)symbol;
            if (qnSymbol.getQualifier() == null && (qualifiedName = qnSymbol.getResolvedQualifiedName(context = OCResolveContext.forSymbol(qnSymbol, project))) != null) {
                return qualifiedName.getFullName(context);
            }
        } else if (symbol != null) {
            return symbol.getPresentableName();
        }
        return null;
    }

    @Nullable
    public String getQualifiedNameSeparator() {
        return "::";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/navigation/OCGotoByNameContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processElementsWithName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "processSymbolsByName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifiedName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

