/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.inspections.OCProblemRegister;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardDetector;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardInfo;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCDefineDirectiveImpl;
import com.jetbrains.cidr.lang.psi.impl.OCMacroReferenceElementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.OCNamingConventionUtil;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenameHandler;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenamer;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCNamingConventionConfigurable;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCHeaderGuardUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCInconsistentNamingInspection
extends OCInspections.GeneralCpp {
    public static final Key<Boolean> INCONSISTENT_NAMING_UNIT_TEST_MODE = Key.create((String)"INCONSISTENT_NAMING_UNIT_TEST_MODE");

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = OCInspectionsBundle.message((String)"inspection.inconsistent.naming", (Object[])new Object[0]);
        if (string == null) {
            OCInconsistentNamingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            OCInconsistentNamingInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    public boolean worksWithClangd() {
        return true;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.settingLink((String)OCInspectionsBundle.message((String)"inspection.naming.convention.edit.settings.link", (Object[])new Object[0]), (String)CodeStyleSettings.generateConfigurableIdByLanguage((Language)OCLanguage.getInstance()), (String)OCNamingConventionConfigurable.getTitle())});
        if (optPane == null) {
            OCInconsistentNamingInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OCInconsistentNamingInspection.$$$reportNull$$$0(3);
        }
        PsiFile file = holder.getFile();
        if (ApplicationManager.getApplication().isUnitTestMode() && file.getUserData(INCONSISTENT_NAMING_UNIT_TEST_MODE) != Boolean.TRUE && holder.getProject().getUserData(INCONSISTENT_NAMING_UNIT_TEST_MODE) != Boolean.TRUE) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                OCInconsistentNamingInspection.$$$reportNull$$$0(4);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = file instanceof OCFile && ((OCFile)file).isInProjectSources() ? new Visitor((OCFile)file, holder) : PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            OCInconsistentNamingInspection.$$$reportNull$$$0(5);
        }
        return psiElementVisitor;
    }

    @InspectionMessage
    private static String getInspectionMessage(@NotNull String suggestedName) {
        if (suggestedName == null) {
            OCInconsistentNamingInspection.$$$reportNull$$$0(6);
        }
        return OCInspectionsBundle.message((String)"inspection.naming.convention.rename.fix", (Object[])new Object[]{StringUtil.wrapWithDoubleQuote((String)suggestedName)});
    }

    @InspectionMessage
    private static String getRenameHeaderGuardMessage(@NotNull String suggestedHeaderGuardName) {
        if (suggestedHeaderGuardName == null) {
            OCInconsistentNamingInspection.$$$reportNull$$$0(7);
        }
        return OCInspectionsBundle.message((String)"inspection.naming.convention.rename.header.guard.fix", (Object[])new Object[]{StringUtil.wrapWithDoubleQuote((String)suggestedHeaderGuardName)});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/OCInconsistentNamingInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedHeaderGuardName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/OCInconsistentNamingInspection";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRenameHeaderGuardMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private class Visitor
    extends OCVisitor {
        private final ProblemsHolder myHolder;
        private final OCHeaderGuardInfo myHeaderGuardInfo;

        Visitor(@NotNull OCFile file, ProblemsHolder holder) {
            if (file == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.myHeaderGuardInfo = ApplicationManager.getApplication().isUnitTestMode() || file.isHeader() ? OCHeaderGuardDetector.findCachedHeaderGuard(file, true) : null;
            this.myHolder = holder;
        }

        @Override
        public void visitDeclarator(OCDeclarator declarator) {
            this.validateNamingConvention(declarator.getName(), declarator, declarator.getNameIdentifier());
        }

        @Override
        public void visitNamespace(OCCppNamespace namespace) {
            this.validateNamingConvention(namespace.getName(), namespace, namespace.getNameIdentifier());
        }

        @Override
        public void visitStructLike(OCStructLike struct) {
            this.validateNamingConvention(struct.getName(), struct, struct.getNameIdentifier());
        }

        @Override
        public void visitDefineDirective(OCDefineDirectiveImpl directive) {
            if (this.myHeaderGuardInfo != null && this.myHeaderGuardInfo.getDefineDirective() == directive) {
                this.validateHeaderGuardStylePattern(directive);
            } else {
                this.validateNamingConvention(directive.getName(), directive, directive.getNameIdentifier());
            }
        }

        @Override
        public void visitUsingStatement(OCCppUsingStatement usingStatement) {
            if (!usingStatement.isNamespaceUsing()) {
                this.validateNamingConvention(usingStatement.getName(), usingStatement, usingStatement.getNameIdentifier());
            }
        }

        private void validateNamingConvention(@Nullable String name, @NotNull OCSymbolDeclarator<?> symbolDeclarator, @Nullable PsiElement nameIdentifier) {
            String suggestedName;
            Object symbol;
            if (symbolDeclarator == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((symbol = symbolDeclarator.getSymbol()) == null || OCNamingConventionUtil.shouldIgnoreNamingConventionForSymbol(symbol) || StringUtil.isEmpty((String)name) || nameIdentifier == null) {
                return;
            }
            OCResolveContext resolveContext = OCResolveContext.forPsi(symbolDeclarator);
            if (symbol instanceof OCFunctionSymbol && Visitor.isOverrideMemberFunction((OCFunctionSymbol)symbol, resolveContext)) {
                return;
            }
            Project project = symbolDeclarator.getProject();
            OCSymbolKind symbolKind = symbol.getKind();
            if (!OCNamingConventionUtil.matchesToNamingConvention(name, symbolKind, symbol, resolveContext, project) && !(suggestedName = OCNamingConventionUtil.applyNamingConvention(name, symbolKind, symbol, resolveContext, project)).isEmpty()) {
                String message = OCInconsistentNamingInspection.getInspectionMessage(suggestedName);
                OCProblemRegister.ProblemConsumer consumer = new OCProblemRegister.ProblemConsumer(this.myHolder);
                OCProblemRegister.registerProblem(consumer, nameIdentifier, message, "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (Class<? extends OCInspection>)OCInconsistentNamingInspection.this.getInspectionClass(), new RenameElementFix(symbolDeclarator, suggestedName, message));
            }
        }

        private void validateHeaderGuardStylePattern(@NotNull OCDefineDirective defineDirective) {
            PsiFile file;
            VirtualFile virtualFile;
            if (defineDirective == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if ((virtualFile = (file = defineDirective.getContainingFile()).getVirtualFile()) == null) {
                return;
            }
            String filePath = virtualFile.getPath();
            Project project = this.myHolder.getProject();
            String headerGuardStylePattern = ((OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class)).HEADER_GUARD_STYLE_PATTERN;
            if (!OCHeaderGuardUtil.headerGuardMatchesPattern((String)this.myHeaderGuardInfo.getHeaderGuardName(), (String)headerGuardStylePattern, (String)filePath, (Project)project)) {
                String suggestedHeaderGuardName = OCHeaderGuardUtil.buildHeaderGuardName((String)headerGuardStylePattern, (String)filePath, (Project)project);
                PsiElement macroReference = PsiTreeUtil.findChildOfType((PsiElement)this.myHeaderGuardInfo.getBeginIfndefDirective(), OCMacroReferenceElementImpl.class);
                if (StringUtil.isNotEmpty((String)suggestedHeaderGuardName) && macroReference != null) {
                    String message = OCInconsistentNamingInspection.getRenameHeaderGuardMessage(suggestedHeaderGuardName);
                    OCProblemRegister.ProblemConsumer consumer = new OCProblemRegister.ProblemConsumer(this.myHolder);
                    OCProblemRegister.registerProblem(consumer, macroReference, message, "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (Class<? extends OCInspection>)OCInconsistentNamingInspection.this.getInspectionClass(), new RenameElementFix(defineDirective, suggestedHeaderGuardName, message));
                }
            }
        }

        private static boolean isOverrideMemberFunction(@NotNull OCFunctionSymbol functionSymbol, @NotNull OCResolveContext context) {
            if (functionSymbol == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (context == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (functionSymbol.isOverride()) {
                return true;
            }
            OCSymbolWithQualifiedName functionSymbolOwner = functionSymbol.getResolvedOwner(context);
            if (!(functionSymbolOwner instanceof OCStructSymbol)) {
                return false;
            }
            Ref isOverrideMemberFunction = Ref.create((Object)false);
            OCType functionType = functionSymbol.getResolvedType(context);
            OCStructType.processMembersInBaseTypes((OCStructSymbol)functionSymbolOwner, functionSymbol.getName(), false, false, (Condition<? super OCSymbol>)((Condition)parentMember -> {
                if (parentMember instanceof OCFunctionSymbol) {
                    OCFunctionSymbol parentMemberFunction = (OCFunctionSymbol)parentMember;
                    OCTypeEqualityVisitor equalityVisitor = new OCTypeEqualityVisitor(parentMemberFunction.getResolvedType(context), true, context);
                    if (parentMemberFunction.isVirtual() && equalityVisitor.isFunctionSignatureEqual(functionType)) {
                        return true;
                    }
                }
                return false;
            }), (Processor<? super OCSymbol>)((Processor)parentMember -> {
                isOverrideMemberFunction.set((Object)true);
                return true;
            }), context);
            return (Boolean)isOverrideMemberFunction.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbolDeclarator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defineDirective";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionSymbol";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/inspections/OCInconsistentNamingInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "validateNamingConvention";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "validateHeaderGuardStylePattern";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOverrideMemberFunction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static final class RenameElementFix
    extends OCPsiElementQuickFix<PsiElement> {
        @NotNull
        private final String myNewName;
        @NotNull
        @IntentionFamilyName
        private final String myMessage;

        RenameElementFix(@NotNull PsiElement elementToRename, @NotNull String newName, @NotNull @IntentionFamilyName String message) {
            if (elementToRename == null) {
                RenameElementFix.$$$reportNull$$$0(0);
            }
            if (newName == null) {
                RenameElementFix.$$$reportNull$$$0(1);
            }
            if (message == null) {
                RenameElementFix.$$$reportNull$$$0(2);
            }
            super(elementToRename);
            this.myNewName = newName;
            this.myMessage = message;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myMessage;
            if (string == null) {
                RenameElementFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        protected String getTextInternal() {
            return this.myMessage;
        }

        @Override
        protected void invoke(PsiFile file, @NotNull PsiElement element) {
            Editor editor;
            if (element == null) {
                RenameElementFix.$$$reportNull$$$0(4);
            }
            if ((editor = FileEditorManager.getInstance((Project)file.getProject()).getSelectedTextEditor()) == null) {
                return;
            }
            OCInplaceRenamer renamer = (OCInplaceRenamer)new OCInplaceRenameHandler().createRenamer(element, editor);
            if (renamer != null) {
                renamer.performRenameInner(element, this.myNewName);
            }
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToRename";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/inspections/OCInconsistentNamingInspection$RenameElementFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/inspections/OCInconsistentNamingInspection$RenameElementFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

