/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.call;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.hierarchy.OCHierarchyUtil;
import com.jetbrains.cidr.lang.hierarchy.polyglot.PolyglotCallHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCallHierarchyNodeDescriptor
extends PolyglotCallHierarchyNodeDescriptor {
    private final Set<OCSymbol> myPossibleResponders = new HashSet<OCSymbol>();

    public OCCallHierarchyNodeDescriptor(Project project, PolyglotCallHierarchyNodeDescriptor parentDescriptor, PsiElement element, boolean isBase, boolean navigateToReference) {
        super(project, parentDescriptor, element, isBase, navigateToReference);
    }

    @Nullable
    public final OCCallable getEnclosingElement() {
        PsiElement element = this.getPsiElement();
        return element == null ? null : OCCallHierarchyNodeDescriptor.getEnclosingElement(element);
    }

    public Set<OCSymbol> getPossibleResponders() {
        return this.myPossibleResponders;
    }

    @Override
    public void addPossibleInheritor(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCCallHierarchyNodeDescriptor.$$$reportNull$$$0(0);
        }
        this.myPossibleResponders.add(symbol);
    }

    @Nullable
    static OCCallable getEnclosingElement(PsiElement element) {
        return (OCCallable)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCCallable.class});
    }

    public final boolean isValid() {
        return this.getEnclosingElement() != null;
    }

    public final boolean update() {
        boolean polymorphicCall;
        OCQualifiedName qualifiedName;
        OCSymbolWithParent symbol;
        CompositeAppearance oldText = this.myHighlightedText;
        Icon oldIcon = this.getIcon();
        boolean changes = super.update();
        OCCallable enclosingElement = this.getEnclosingElement();
        if (enclosingElement == null) {
            return this.invalidElement();
        }
        this.installIcon(enclosingElement, changes);
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes mainTextAttributes = null;
        if (this.myColor != null) {
            mainTextAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        String name = null;
        if (enclosingElement instanceof OCMethod) {
            symbol = (OCMethodSymbol)((OCMethod)enclosingElement).getSymbol();
            name = symbol != null ? symbol.getNameWithParent(OCResolveContext.forPsi(enclosingElement)) : ((OCMethod)enclosingElement).getName();
        } else if (enclosingElement instanceof OCFunctionDeclaration && (symbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)enclosingElement).getSymbol()) != null && (qualifiedName = symbol.getResolvedQualifiedName(OCResolveContext.forPsi(enclosingElement))) != null) {
            name = qualifiedName.getNameWithParent();
        }
        if (name == null) {
            ItemPresentation presentation = ((NavigatablePsiElement)enclosingElement).getPresentation();
            name = presentation != null ? presentation.getPresentableText() : ((NavigatablePsiElement)enclosingElement).getName();
        }
        this.myHighlightedText.getEnding().addText(name, mainTextAttributes);
        String location = OCHierarchyUtil.getLocationString(enclosingElement);
        if (location != null) {
            this.myHighlightedText.getEnding().addText(" (" + location + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        }
        boolean bl = polymorphicCall = this.myPossibleResponders.size() > 1;
        if (polymorphicCall) {
            this.myHighlightedText.getEnding().addText(" ", HierarchyNodeDescriptor.getPackageNameAttributes());
            this.myHighlightedText.getEnding().addText(OCBundle.message("polymorphic.call", new Object[0]), HierarchyNodeDescriptor.getPackageNameAttributes());
        }
        if (this.getUsages() > 1) {
            this.myHighlightedText.getEnding().addText(IdeBundle.message((String)"node.call.hierarchy.N.usages", (Object[])new Object[]{this.getUsages()}), HierarchyNodeDescriptor.getUsageCountPrefixAttributes());
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText) || !Comparing.equal((Object)this.getIcon(), (Object)oldIcon)) {
            changes = true;
        }
        return changes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/hierarchy/call/OCCallHierarchyNodeDescriptor", "addPossibleInheritor"));
    }
}

