/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.call;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.hierarchy.polyglot.PolyglotCallHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.hierarchy.polyglot.PolyglotCallStructure;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OCCallHierarchyNodeAggregator {
    private final Map<String, PolyglotCallHierarchyNodeDescriptor> myMap;
    private final PolyglotCallHierarchyNodeDescriptor myParentDescriptor;

    public OCCallHierarchyNodeAggregator(PolyglotCallHierarchyNodeDescriptor parentDescriptor) {
        this.myParentDescriptor = parentDescriptor;
        this.myMap = new HashMap<String, PolyglotCallHierarchyNodeDescriptor>();
    }

    @Nullable
    public PolyglotCallHierarchyNodeDescriptor addNodeDescriptor(OCSymbol known, @Nullable String selectorName, PsiElement context, @Nullable PsiReference reference) {
        PolyglotCallHierarchyNodeDescriptor descriptor;
        Object name;
        Project project = this.myParentDescriptor.getProject();
        if (project == null) {
            return null;
        }
        if (known instanceof OCFunctionSymbol) {
            OCQualifiedName qualifiedName = ((OCFunctionSymbol)known).getResolvedQualifiedName(OCResolveContext.forPsi(context));
            name = qualifiedName != null ? String.valueOf(qualifiedName) + ((OCFunctionSymbol)known).getParametersSignature(project) : known.getSignature(project);
        } else if (known instanceof OCMethodSymbol) {
            OCMethodSymbol methodSymbol = (OCMethodSymbol)known;
            if (methodSymbol.getDefinitionSymbol(project) == null && methodSymbol.getGeneratedFromProperty() != null) {
                return null;
            }
            name = methodSymbol.getParent().getName() + "." + known.getSignature(project);
        } else {
            name = selectorName;
        }
        if (this.myMap.containsKey(name)) {
            descriptor = this.myMap.get(name);
            descriptor.incrementUsageCount();
        } else {
            PsiElement element;
            descriptor = known != null ? PolyglotCallStructure.createNodeDescriptor(project, this.myParentDescriptor, (element = known.locateDefinition(project)) != null ? element : context, false, true) : PolyglotCallStructure.createNodeDescriptor(project, this.myParentDescriptor, context, false, true);
            if (descriptor != null) {
                descriptor.addReference((PsiReference)ObjectUtils.coalesce((Object)context.getReference(), (Object)reference));
                this.myMap.put((String)name, descriptor);
            }
        }
        return descriptor;
    }

    public Object[] getChildren() {
        return this.myMap.values().toArray();
    }

    public Collection<PolyglotCallHierarchyNodeDescriptor> getChildrenCollection() {
        return this.myMap.values();
    }
}

