/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCGenerateUtil {
    @NotNull
    public static PsiElement getElementAt(@Nullable Editor editor, @NotNull PsiFile file) {
        if (file == null) {
            OCGenerateUtil.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = (PsiElement)ObjectUtils.notNull((Object)OCGenerateUtil.findElementAt(editor, file), (Object)file);
        if (psiElement == null) {
            OCGenerateUtil.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement findElementAt(@Nullable Editor editor, @NotNull PsiFile file) {
        if (file == null) {
            OCGenerateUtil.$$$reportNull$$$0(2);
        }
        return editor != null ? file.findElementAt(editor.getCaretModel().getOffset()) : null;
    }

    public static boolean shouldInsertNewLineBefore(@NotNull CharSequence sequence, int at) {
        int prevNonSpace;
        if (sequence == null) {
            OCGenerateUtil.$$$reportNull$$$0(3);
        }
        return (prevNonSpace = CharArrayUtil.shiftBackward((CharSequence)sequence, (int)(at - 1), (String)" \t")) < 0 || prevNonSpace >= sequence.length() || !StringUtil.isLineBreak((char)sequence.charAt(prevNonSpace));
    }

    public static boolean shouldInsertNewLineAfter(@NotNull CharSequence sequence, int at) {
        int nextNonSpace;
        if (sequence == null) {
            OCGenerateUtil.$$$reportNull$$$0(4);
        }
        return (nextNonSpace = CharArrayUtil.shiftForward((CharSequence)sequence, (int)at, (String)" \t")) >= sequence.length() || !StringUtil.isLineBreak((char)sequence.charAt(nextNonSpace));
    }

    public static List<PsiFile> getAffectedFiles(@NotNull List<Replacement> replacements) {
        if (replacements == null) {
            OCGenerateUtil.$$$reportNull$$$0(5);
        }
        return replacements.stream().map(r -> r.position.file).distinct().collect(Collectors.toList());
    }

    public static void applyReplacements(@NotNull Project project, @NotNull List<Replacement> replacements, boolean fixImports) {
        if (project == null) {
            OCGenerateUtil.$$$reportNull$$$0(6);
        }
        if (replacements == null) {
            OCGenerateUtil.$$$reportNull$$$0(7);
        }
        HashSet<Document> documents = new HashSet<Document>();
        ArrayList<Pair> repsAndMarkers = new ArrayList<Pair>(replacements.size());
        for (Replacement t : replacements) {
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(t.position.file);
            if (document == null) {
                OCLog.LOG.warn("Can't get document for " + String.valueOf(t.position.file));
                continue;
            }
            documents.add(document);
            RangeMarker marker = document.createRangeMarker(t.position.range);
            marker.setGreedyToRight(true);
            repsAndMarkers.add(Pair.create((Object)t, (Object)marker));
        }
        for (Document document : documents) {
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        }
        for (Pair repAndMarker : repsAndMarkers) {
            Replacement r = (Replacement)repAndMarker.first;
            ReplacePosition p = r.position;
            RangeMarker marker = (RangeMarker)repAndMarker.second;
            marker.getDocument().replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)r.text);
            PsiDocumentManager.getInstance((Project)project).commitDocument(marker.getDocument());
            OCChangeUtil.reformatTextIfNotInjected(p.file, marker.getStartOffset(), CharArrayUtil.shiftForward((CharSequence)marker.getDocument().getCharsSequence(), (int)marker.getEndOffset(), (String)" \t\n"));
            if (!fixImports) continue;
            OCImportSymbolFix.fixAllSymbolsRecursively((PsiElement)p.file, marker.getTextRange());
        }
        boolean selected = false;
        for (Pair repAndMarker : repsAndMarkers) {
            if (!selected) {
                selected = OCCodeInsightUtil.showCallableInEditorAndSelectBody(((Replacement)repAndMarker.first).position.file, (Segment)repAndMarker.second, (Condition<? super OCBlockStatement>)((Condition)body -> true));
            }
            ((RangeMarker)repAndMarker.second).dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/OCGenerateUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/OCGenerateUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementAt";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findElementAt";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldInsertNewLineBefore";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldInsertNewLineAfter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedFiles";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyReplacements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class Replacement {
        @NotNull
        public final ReplacePosition position;
        @NotNull
        public final String text;

        public Replacement(@NotNull ReplacePosition position, @NotNull String text) {
            if (position == null) {
                Replacement.$$$reportNull$$$0(0);
            }
            if (text == null) {
                Replacement.$$$reportNull$$$0(1);
            }
            this.position = position;
            this.text = (position.addNewLineBefore ? "\n" : "") + text + (position.addNewLineAfter ? "\n" : "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "position";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/generate/OCGenerateUtil$Replacement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ReplacePosition {
        @NotNull
        public final PsiFile file;
        @NotNull
        public final TextRange range;
        @NotNull
        public final PsiElement context;
        public final boolean addNewLineBefore;
        public final boolean addNewLineAfter;

        public ReplacePosition(@NotNull PsiFile file, @NotNull TextRange range, @NotNull PsiElement context) {
            if (file == null) {
                ReplacePosition.$$$reportNull$$$0(0);
            }
            if (range == null) {
                ReplacePosition.$$$reportNull$$$0(1);
            }
            if (context == null) {
                ReplacePosition.$$$reportNull$$$0(2);
            }
            this(file, range, context, true);
        }

        public ReplacePosition(@NotNull PsiFile file, @NotNull TextRange range, @NotNull PsiElement context, boolean fixNewLineBefore) {
            if (file == null) {
                ReplacePosition.$$$reportNull$$$0(3);
            }
            if (range == null) {
                ReplacePosition.$$$reportNull$$$0(4);
            }
            if (context == null) {
                ReplacePosition.$$$reportNull$$$0(5);
            }
            this.file = file;
            this.range = range;
            this.context = context;
            Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
            this.addNewLineBefore = fixNewLineBefore && (document == null || OCGenerateUtil.shouldInsertNewLineBefore(document.getCharsSequence(), range.getStartOffset()));
            this.addNewLineAfter = document == null || OCGenerateUtil.shouldInsertNewLineAfter(document.getCharsSequence(), range.getEndOffset());
        }

        public ReplacePosition(@NotNull PsiFile file, @NotNull TextRange range, @NotNull PsiElement context, boolean addNewLineBefore, boolean addNewLineAfter) {
            if (file == null) {
                ReplacePosition.$$$reportNull$$$0(6);
            }
            if (range == null) {
                ReplacePosition.$$$reportNull$$$0(7);
            }
            if (context == null) {
                ReplacePosition.$$$reportNull$$$0(8);
            }
            this.file = file;
            this.range = range;
            this.context = context;
            this.addNewLineBefore = addNewLineBefore;
            this.addNewLineAfter = addNewLineAfter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/generate/OCGenerateUtil$ReplacePosition";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

