/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCPragmaSuppressionUtils {
    @NonNls
    public static final String CLANG = "clang";
    @NonNls
    public static final String CIDR_IDE = "ide";
    private static final NotNullLazyKey<CachedValue<ScopesStack>, OCFile> CACHE = NotNullLazyKey.createLazyKey((String)"OCPragmaSuppressionUtils", file -> CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> {
        final ScopesStack stack = new ScopesStack();
        final Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument((PsiFile)file);
        file.accept(new OCRecursiveVisitor(){

            @Override
            public void visitPragma(OCPragma pragma) {
                stack.processPragma(pragma, document);
            }
        });
        while (!stack.myStack.isEmpty()) {
            stack.pop(new TextRange(file.getTextLength(), file.getTextLength()));
        }
        return CachedValueProvider.Result.create((Object)stack, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    }, false));

    @Contract(value="_, _, null -> null")
    public static OCPragma.Mode getDiagnosticMode(OCFile file, int offset, @Nullable String suppressOption) {
        if (suppressOption == null) {
            return null;
        }
        Scope scope = OCPragmaSuppressionUtils.findScope(file, offset);
        OCPragma.Mode curMode = null;
        for (Pair pair : scope.settings.get((Object)suppressOption)) {
            if (((TextRange)pair.first).getEndOffset() > offset) break;
            curMode = (OCPragma.Mode)((Object)pair.second);
        }
        return curMode;
    }

    @NotNull
    private static Scope findScope(@NotNull Scope scope, int offset) {
        if (scope == null) {
            OCPragmaSuppressionUtils.$$$reportNull$$$0(0);
        }
        for (Scope child : scope.children) {
            if (child.push.getStartOffset() > offset || child.pop == null || offset >= child.pop.getEndOffset()) continue;
            return OCPragmaSuppressionUtils.findScope(child, offset);
        }
        Scope scope2 = scope;
        if (scope2 == null) {
            OCPragmaSuppressionUtils.$$$reportNull$$$0(1);
        }
        return scope2;
    }

    @NotNull
    public static Scope findScope(OCFile file, int offset) {
        return OCPragmaSuppressionUtils.findScope(((ScopesStack)((CachedValue)OCPragmaSuppressionUtils.CACHE.getValue((UserDataHolder)file)).getValue()).myRootScope, offset);
    }

    @Nullable
    public static Scope findExactScope(OCFile file, int startOffset, int endOffset) {
        PsiElement leaf = startOffset > 0 ? file.findElementAt(startOffset - 1) : null;
        int pushOffset = OCPragmaSuppressionUtils.getOffset(OCPragma.Mode.PUSH, leaf, (Function.Mono<PsiElement>)((Function.Mono)element -> PsiTreeUtil.prevLeaf((PsiElement)element)));
        leaf = endOffset < file.getTextLength() ? file.findElementAt(endOffset) : null;
        int popOffset = OCPragmaSuppressionUtils.getOffset(OCPragma.Mode.POP, leaf, (Function.Mono<PsiElement>)((Function.Mono)element -> PsiTreeUtil.nextLeaf((PsiElement)element)));
        if (pushOffset != -1 && popOffset != -1) {
            Scope scope = OCPragmaSuppressionUtils.findScope(file, pushOffset);
            if (scope.push != null && scope.pop != null && scope.push.getStartOffset() == pushOffset && scope.pop.getStartOffset() == popOffset) {
                return scope;
            }
        } else {
            Scope scope = OCPragmaSuppressionUtils.findScope(file, file.getTextLength() - 1);
            if (scope.push != null && scope.pop != null && scope.push.getStartOffset() == startOffset && scope.pop.getEndOffset() == endOffset) {
                return scope;
            }
        }
        return null;
    }

    private static int getOffset(OCPragma.Mode mode, PsiElement leaf, Function.Mono<PsiElement> iter) {
        int pushOffset = -1;
        while (pushOffset < 0 && leaf != null && (OCElementUtil.isWhitespace(leaf) || leaf.getParent() instanceof OCPragma)) {
            leaf = (PsiElement)iter.fun((Object)leaf);
            pushOffset = OCPragmaSuppressionUtils.getStartOfPragmaContentOffset(leaf, mode);
        }
        return pushOffset;
    }

    private static int getStartOfPragmaContentOffset(@Nullable PsiElement leaf, OCPragma.Mode mode) {
        OCPragma pragma;
        Pair<OCPragma.Mode, String> pair;
        PsiElement psiElement;
        if (leaf != null && (psiElement = leaf.getParent()) instanceof OCPragma && (pair = (pragma = (OCPragma)psiElement).parsePragma()) != null && pair.first == mode) {
            return OCElementUtil.getRangeWithMacros(pragma).getStartOffset();
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/OCPragmaSuppressionUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/OCPragmaSuppressionUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findScope";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class Scope {
        private MultiMap<String, Pair<TextRange, OCPragma.Mode>> settings = new MultiMap();
        private int ownSettingsCnt;
        private TextRange push;
        private TextRange pop;
        private final List<Scope> children = new ArrayList<Scope>();

        public boolean isTopLevel() {
            return this.pop == null;
        }

        public TextRange getPush() {
            return this.push;
        }

        public TextRange getPop() {
            return this.pop;
        }

        public MultiMap<String, Pair<TextRange, OCPragma.Mode>> getSettings() {
            return this.settings;
        }

        public int getOwnSettingsCnt() {
            return this.ownSettingsCnt;
        }
    }

    private static final class ScopesStack {
        private final Stack<Scope> myStack = new Stack();
        private Scope myCurScope = this.myRootScope = new Scope();
        private final Scope myRootScope;

        private ScopesStack() {
        }

        private void processPragma(OCPragma pragma, Document document) {
            Pair<OCPragma.Mode, String> pair = pragma.parsePragma();
            if (pair != null) {
                int line;
                TextRange range = OCElementUtil.getRangeWithMacros(pragma);
                if (document != null && (line = document.getLineNumber(range.getEndOffset())) < document.getLineCount() - 1) {
                    range = new TextRange(range.getStartOffset(), document.getLineStartOffset(line + 1));
                }
                switch ((OCPragma.Mode)((Object)pair.first)) {
                    case PUSH: {
                        this.push(range);
                        break;
                    }
                    case POP: {
                        this.pop(range);
                        break;
                    }
                    case IGNORE: 
                    case WARNING: 
                    case ERROR: 
                    case FATAL: {
                        this.myCurScope.settings.putValue((Object)((String)pair.getSecond()), (Object)Pair.create((Object)range, (Object)((Object)((OCPragma.Mode)((Object)pair.getFirst())))));
                        ++this.myCurScope.ownSettingsCnt;
                    }
                }
            }
        }

        private void push(TextRange range) {
            Scope newScope = new Scope();
            newScope.settings = new MultiMap();
            newScope.settings.putAllValues(this.myCurScope.settings);
            newScope.push = range;
            this.myStack.push((Object)this.myCurScope);
            this.myCurScope.children.add(newScope);
            this.myCurScope = newScope;
        }

        private void pop(TextRange range) {
            if (!this.myStack.isEmpty()) {
                this.myCurScope.pop = range;
                this.myCurScope = (Scope)this.myStack.pop();
            }
        }
    }
}

