/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.actions.newFile.OCNewClassAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.ui.OCTypeReferenceEditor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import icons.CidrLangIcons;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewCategoryAction
extends OCNewClassAction<CreateCategoryDialog> {
    private static final String CATEGORY_TEMPLATE_NAME = "Objective-C Category File.m";

    public OCNewCategoryAction() {
        super(OCBundle.messagePointer("create.category.title", new Object[0]), OCBundle.messagePointer("create.category.description", new Object[0]), CidrLangIcons.CodeAssistantClassExtension);
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        selectedName = ((CreateCategoryDialog)this.getState().dialogPeer).myClassField.getText() + "+" + (String)selectedName;
        return new OCNewFileActionBase.NewFileNames((String)selectedName + ((CreateCategoryDialog)this.getState().dialogPeer).getImplementationExtension(), ((CreateCategoryDialog)this.getState().dialogPeer).myCreateInterfaceCB.isSelected() ? (String)selectedName + ".h" : null);
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, @NotNull PsiFile sampleFile) {
        if (sampleFile == null) {
            OCNewCategoryAction.$$$reportNull$$$0(0);
        }
        OCFile implFile = ((OCFile)sampleFile).isHeader() ? ((OCFile)sampleFile).getAssociatedFile() : (OCFile)sampleFile;
        String extension = implFile != null && implFile.getName().endsWith(".mm") ? ".mm" : ".m";
        OCClassSymbol baseClass = this.getBaseClass();
        OCLog.LOG.assertTrue(baseClass != null);
        String categoryName = baseClass.getName() + "+" + selectedName;
        return new OCNewFileActionBase.NewFileNames(categoryName + extension, categoryName + ".h");
    }

    @Override
    protected void setAdditionalProperties(Properties properties, String fileName, @Nullable PsiFile sampleFile, Project project) {
        OCClassSymbol mainClassSymbol;
        String mainClassName;
        if (this.getState() != null) {
            mainClassName = ((CreateCategoryDialog)this.getState().dialogPeer).myClassField.getText();
            mainClassSymbol = (OCClassSymbol)((CreateCategoryDialog)this.getState().dialogPeer).myClassField.getClassDeclaration(project);
        } else {
            mainClassSymbol = this.getBaseClass();
            String string = mainClassName = mainClassSymbol != null ? mainClassSymbol.getName() : null;
        }
        if (mainClassSymbol != null && fileName.endsWith(".h")) {
            this.addAuxAction(createdElements -> {
                OCInterfaceSymbol symbol = mainClassSymbol.getMainInterface(project);
                for (PsiFile file : createdElements) {
                    OCClassSymbol mainClass;
                    PsiElement declarationBase;
                    if (!(file instanceof OCFile) || !((OCFile)file).isHeader()) continue;
                    Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
                    if (document != null) {
                        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                    }
                    PsiElement psiElement = declarationBase = (mainClass = (OCClassSymbol)((OCFile)file).getSameNamedClass()) != null ? mainClass.locateDefinition(project) : null;
                    if (declarationBase == null) continue;
                    new OCImportSymbolFix(declarationBase, symbol, true, true, true).fixBestItem(project, file);
                }
            });
        }
        properties.setProperty("NAME", mainClassName + "(" + this.mySelectedName + ")");
        if (this.getState() == null) {
            OCLog.LOG.assertTrue(sampleFile != null);
            properties.setProperty("HEADER_FILENAME", this.getNewFileNames(this.mySelectedName, sampleFile).getHeaderName());
        } else if (((CreateCategoryDialog)this.getState().dialogPeer).myCreateInterfaceCB.isSelected()) {
            properties.setProperty("HEADER_FILENAME", this.getNewFileNames(this.mySelectedName).getHeaderName());
        } else {
            properties.setProperty("HEADER_FILENAME", mainClassName + ".h");
        }
    }

    @Override
    protected String getFileTemplate(String fileName) {
        if (fileName.endsWith(".m") || fileName.endsWith(".mm")) {
            return "Objective-C Class.m";
        }
        if (fileName.endsWith(".h")) {
            return CATEGORY_TEMPLATE_NAME;
        }
        assert (false);
        return null;
    }

    @Nullable
    protected OCClassSymbol getBaseClass() {
        OCClassSymbol classSymbol = this.getState().selectedFile instanceof OCFile ? OCCodeInsightUtil.getClassInFile((OCFile)this.getState().selectedFile) : null;
        return classSymbol != null && classSymbol.getCategoryName() != null ? classSymbol.getMainInterface(this.getState().project) : classSymbol;
    }

    @Override
    @NotNull
    protected CreateCategoryDialog createDialog(@NotNull String defaultName) {
        if (defaultName == null) {
            OCNewCategoryAction.$$$reportNull$$$0(1);
        }
        return new CreateCategoryDialog(defaultName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/actions/newFile/OCNewCategoryAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getNewFileNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class CreateCategoryDialog
    extends OCNewClassAction.CreateClassDialog {
        private JCheckBox myCreateInterfaceCB;
        private OCTypeReferenceEditor myClassField;

        public CreateCategoryDialog(String defaultName) {
            super(OCNewCategoryAction.this, OCBundle.message("create.category.dialog.title", new Object[0]), OCBundle.message("create.field.name.category", new Object[0]), defaultName);
        }

        @Override
        public void fillGenericControls(FormBuilder formBuilder) {
            this.myCreateInterfaceCB = new JCheckBox(OCBundle.message("create.checkbox.category.interface", new Object[0]));
            DialogUtil.registerMnemonic((AbstractButton)this.myCreateInterfaceCB, (char)'&');
            OCClassSymbol classSymbol = OCNewCategoryAction.this.getBaseClass();
            this.myClassField = OCTypeReferenceEditor.create(classSymbol, (Condition<OCSymbol>)((Condition)symbol -> symbol instanceof OCInterfaceSymbol && ((OCInterfaceSymbol)symbol).getCategoryName() == null), (PsiElement)OCNewCategoryAction.this.getState().selectedFile, false, OCNewCategoryAction.this.getState().project);
            formBuilder.addLabeledComponent(OCBundle.message("create.field.class", new Object[0]), (JComponent)((Object)this.myClassField));
            super.fillGenericControls(formBuilder);
            formBuilder.addLabeledComponent("", (JComponent)this.myCreateInterfaceCB, 0);
            this.myClassField.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    CreateCategoryDialog.this.validateOkAction();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/lang/actions/newFile/OCNewCategoryAction$CreateCategoryDialog$1", "documentChanged"));
                }
            });
            this.myCreateInterfaceCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CreateCategoryDialog.this.validateOkAction();
                }
            });
            OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)OCNewCategoryAction.this.getState().project).getCustomSettings(OCCodeStyleSettings.class);
            this.myCreateInterfaceCB.setSelected(settings.CREATE_INTERFACE_FOR_CATEGORIES);
            OCNewCategoryAction.this.addAuxAction(createdElements -> {
                settings.CREATE_INTERFACE_FOR_CATEGORIES = this.myCreateInterfaceCB.isSelected();
            });
        }

        protected boolean areControlsConsistent() {
            String message;
            String title;
            OCSymbol classDeclaration = this.myClassField.getClassDeclaration(OCNewCategoryAction.this.getState().project);
            if (!(classDeclaration instanceof OCInterfaceSymbol) && !(classDeclaration instanceof OCImplementationSymbol) && ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)(title = OCBundle.message("create.category.no.class.dialog.title", new Object[0])), (String)(message = OCBundle.message("create.category.no.class.dialog", this.myClassField.getText()))).icon(Messages.getWarningIcon())).show() != 0) {
                return false;
            }
            return super.areControlsConsistent();
        }

        @Nullable
        protected String collectOkActionErrors() {
            if (StringUtil.isEmpty((String)this.myClassField.getText()) || StringUtil.isEmpty((String)this.myLocationField.getText())) {
                return "";
            }
            return super.collectOkActionErrors();
        }
    }
}

