/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomHeaderProvider {
    public static final ExtensionPointName<CustomHeaderProvider> EP_NAME = ExtensionPointName.create((String)"cidr.lang.customHeaderProvider");
    private final Map<HeaderSearchStage, StageProvider> myStageProviders = new EnumMap<HeaderSearchStage, StageProvider>(HeaderSearchStage.class);

    public abstract boolean accepts(@Nullable OCResolveRootAndConfiguration var1);

    @Nullable
    public abstract String provideSerializationPath(@NotNull VirtualFile var1);

    @Nullable
    public abstract VirtualFile getCustomSerializedHeaderFile(@NotNull String var1, @NotNull Project var2, @NotNull VirtualFile var3);

    @Nullable
    public OCCompilerSettings getCompilerSettings(@NotNull OCResolveConfiguration configuration, @NotNull OCResolveRootAndConfiguration rootAndConfiguration) {
        if (configuration == null) {
            CustomHeaderProvider.$$$reportNull$$$0(0);
        }
        if (rootAndConfiguration == null) {
            CustomHeaderProvider.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nullable
    public VirtualFile getCustomHeaderFile(@NotNull String headerName, @NotNull HeaderSearchStage stage, @Nullable OCResolveConfiguration configuration) {
        StageProvider provider2;
        if (headerName == null) {
            CustomHeaderProvider.$$$reportNull$$$0(2);
        }
        if (stage == null) {
            CustomHeaderProvider.$$$reportNull$$$0(3);
        }
        if ((provider2 = this.myStageProviders.get((Object)stage)) != null) {
            return provider2.getHeader(headerName, configuration);
        }
        return null;
    }

    protected void registerProvider(@NotNull HeaderSearchStage stage, @NotNull StageProvider provider2) {
        if (stage == null) {
            CustomHeaderProvider.$$$reportNull$$$0(4);
        }
        if (provider2 == null) {
            CustomHeaderProvider.$$$reportNull$$$0(5);
        }
        this.myStageProviders.put(stage, provider2);
    }

    @NotNull
    public static Helper getProviders(@NotNull String headerName, @Nullable OCResolveRootAndConfiguration configuration) {
        if (headerName == null) {
            CustomHeaderProvider.$$$reportNull$$$0(6);
        }
        ArrayList<CustomHeaderProvider> helpers = new ArrayList<CustomHeaderProvider>();
        for (CustomHeaderProvider provider2 : (CustomHeaderProvider[])EP_NAME.getExtensions()) {
            if (!provider2.accepts(configuration)) continue;
            helpers.add(provider2);
        }
        return new Helper(ContainerUtil.trimToSize(helpers), headerName, configuration != null ? configuration.getConfiguration() : null);
    }

    @Nullable
    public static String provideSerializationPathForFile(@NotNull VirtualFile file) {
        if (file == null) {
            CustomHeaderProvider.$$$reportNull$$$0(7);
        }
        for (CustomHeaderProvider provider2 : (CustomHeaderProvider[])EP_NAME.getExtensions()) {
            String path = provider2.provideSerializationPath(file);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    @Nullable
    public static VirtualFile getCustomHeaderFile(@NotNull String serializationPath, @NotNull Project project, @NotNull VirtualFile file) {
        if (serializationPath == null) {
            CustomHeaderProvider.$$$reportNull$$$0(8);
        }
        if (project == null) {
            CustomHeaderProvider.$$$reportNull$$$0(9);
        }
        if (file == null) {
            CustomHeaderProvider.$$$reportNull$$$0(10);
        }
        for (CustomHeaderProvider provider2 : (CustomHeaderProvider[])EP_NAME.getExtensions()) {
            VirtualFile headerFile = provider2.getCustomSerializedHeaderFile(serializationPath, project, file);
            if (headerFile == null) continue;
            return headerFile;
        }
        return null;
    }

    @Nullable
    public static OCCompilerSettings getCustomCompilerSettings(@NotNull OCResolveConfiguration configuration, @NotNull OCResolveRootAndConfiguration rootAndConfiguration) {
        if (configuration == null) {
            CustomHeaderProvider.$$$reportNull$$$0(11);
        }
        if (rootAndConfiguration == null) {
            CustomHeaderProvider.$$$reportNull$$$0(12);
        }
        for (CustomHeaderProvider provider2 : (CustomHeaderProvider[])EP_NAME.getExtensions()) {
            OCCompilerSettings settings = provider2.getCompilerSettings(configuration, rootAndConfiguration);
            if (settings == null) continue;
            return settings;
        }
        return null;
    }

    @Nullable
    public static String getFrameworkNameFromImport(@NotNull String importPath) {
        String headerName;
        if (importPath == null) {
            CustomHeaderProvider.$$$reportNull$$$0(13);
        }
        String adjustedName = OCIncludeHelpers.adjustHeaderName(importPath);
        List parts = StringsKt.split((CharSequence)adjustedName, (String[])new String[]{"/"}, (boolean)false, (int)3);
        if (parts.size() != 2) {
            return null;
        }
        String frameworkName = (String)parts.get(0);
        if (!FileUtil.pathsEqual((String)frameworkName, (String)(headerName = StringUtil.trimEnd((String)((String)parts.get(1)), (String)".h")))) {
            return null;
        }
        return frameworkName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootAndConfiguration";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializationPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/CustomHeaderProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCompilerSettings";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomHeaderFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getProviders";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "provideSerializationPathForFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomCompilerSettings";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getFrameworkNameFromImport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum HeaderSearchStage {
        BEFORE_START,
        BEFORE_CURRENT,
        BEFORE_LIBRARIES,
        BEFORE_FRAMEWORKS,
        AFTER_END;

    }

    protected static interface StageProvider {
        @Nullable
        public VirtualFile getHeader(@NotNull String var1, @Nullable OCResolveConfiguration var2);
    }

    public static class Helper {
        @NotNull
        private final List<CustomHeaderProvider> myProviders;
        @NotNull
        private final String myHeaderName;
        @Nullable
        private final OCResolveConfiguration myConfiguration;

        public Helper(@NotNull List<CustomHeaderProvider> providers, @NotNull String headerName, @Nullable OCResolveConfiguration configuration) {
            if (providers == null) {
                Helper.$$$reportNull$$$0(0);
            }
            if (headerName == null) {
                Helper.$$$reportNull$$$0(1);
            }
            this.myProviders = providers;
            this.myHeaderName = headerName;
            this.myConfiguration = configuration;
        }

        @Nullable
        public VirtualFile getCustomHeader(HeaderSearchStage stage) {
            for (CustomHeaderProvider provider2 : this.myProviders) {
                VirtualFile file = provider2.getCustomHeaderFile(this.myHeaderName, stage, this.myConfiguration);
                if (file == null) continue;
                return file;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "providers";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "headerName";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/CustomHeaderProvider$Helper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

