/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp.lexer;

import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0014J\b\u0010\f\u001a\u00020\u0005H\u0014J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0014J\b\u0010\u000e\u001a\u00020\u0005H\u0014J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0014J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0016J$\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/cidr/cpp/lexer/CidrStringLiteralLexer;", "Lcom/intellij/lexer/StringLiteralLexer;", "quoteChar", "", "originalLiteralToken", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(CLcom/intellij/psi/tree/IElementType;)V", "locateHexEscapeSequence", "", "start", "indexOfCharAfterSlash", "getHexCodedEscapeSeq", "locateUnicodeEscapeSequence", "getUnicodeEscapeSequenceType", "locateAdditionalEscapeSequence", "getTokenType", "locateSeq", "valid", "Lkotlin/Function1;", "", "Companion", "intellij.cidr.psi.base"})
public final class CidrStringLiteralLexer
extends StringLiteralLexer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final char LONG_UNICODE_ESCAPE_CHAR = 'U';
    public static final char NAMED_UNICODE_ESCAPE_CHAR = 'N';
    public static final char OCTAL_ESCAPE_CHAR = 'o';
    public static final int LONG_UNICODE_ESCAPE_SEQUENCE_LENGTH = 10;
    @NotNull
    public static final String ADDITIONAL_VALID_ESCAPES = "?abvUNo";

    public CidrStringLiteralLexer(char quoteChar, @Nullable IElementType originalLiteralToken) {
        super(quoteChar, originalLiteralToken, false, ADDITIONAL_VALID_ESCAPES, true, true);
    }

    protected int locateHexEscapeSequence(int start, int indexOfCharAfterSlash) {
        int location = this.locateSeq(indexOfCharAfterSlash, (Function1<? super Character, Boolean>)((Function1)CidrStringLiteralLexer::locateHexEscapeSequence$lambda$0));
        if (location >= 0) {
            return location;
        }
        for (location = indexOfCharAfterSlash + 1; location < this.myBufferEnd; ++location) {
            if (StringUtil.isHexDigit((char)this.myBuffer.charAt(location))) continue;
            return location;
        }
        return location;
    }

    @NotNull
    protected IElementType getHexCodedEscapeSeq() {
        IElementType iElementType;
        if (this.myStart + 2 < this.myEnd && this.myBuffer.charAt(this.myStart + 2) == '{') {
            IElementType iElementType2;
            if (this.myBuffer.charAt(this.myEnd - 1) == '}' && StringUtil.isHexDigit((char)this.myBuffer.charAt(this.myEnd - 2))) {
                IElementType iElementType3 = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                iElementType2 = iElementType3;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"VALID_STRING_ESCAPE_TOKEN");
            } else {
                IElementType iElementType4 = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                iElementType2 = iElementType4;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType4, (String)"INVALID_UNICODE_ESCAPE_TOKEN");
            }
            return iElementType2;
        }
        if (this.myStart + 2 < this.myEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(this.myStart + 2))) {
            IElementType iElementType5 = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            iElementType = iElementType5;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType5, (String)"VALID_STRING_ESCAPE_TOKEN");
        } else {
            IElementType iElementType6 = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            iElementType = iElementType6;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType6, (String)"INVALID_UNICODE_ESCAPE_TOKEN");
        }
        return iElementType;
    }

    protected int locateUnicodeEscapeSequence(int start, int indexOfCharAfterSlash) {
        int location = this.locateSeq(indexOfCharAfterSlash, (Function1<? super Character, Boolean>)((Function1)CidrStringLiteralLexer::locateUnicodeEscapeSequence$lambda$1));
        if (location >= 0) {
            return location;
        }
        return super.locateUnicodeEscapeSequence(start, indexOfCharAfterSlash);
    }

    @NotNull
    protected IElementType getUnicodeEscapeSequenceType() {
        if (this.myStart + 2 < this.myEnd && this.myBuffer.charAt(this.myStart + 2) == '{') {
            IElementType iElementType;
            if (this.myBuffer.charAt(this.myEnd - 1) == '}' && StringUtil.isHexDigit((char)this.myBuffer.charAt(this.myEnd - 2))) {
                IElementType iElementType2 = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                iElementType = iElementType2;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"VALID_STRING_ESCAPE_TOKEN");
            } else {
                IElementType iElementType3 = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                iElementType = iElementType3;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"INVALID_UNICODE_ESCAPE_TOKEN");
            }
            return iElementType;
        }
        IElementType iElementType = super.getUnicodeEscapeSequenceType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getUnicodeEscapeSequenceType(...)");
        return iElementType;
    }

    protected int locateAdditionalEscapeSequence(int start, int indexOfCharAfterSlash) {
        char chAfterSlash = this.myBuffer.charAt(indexOfCharAfterSlash);
        int location = 0;
        if (chAfterSlash == 'U') {
            for (location = indexOfCharAfterSlash + 1; location < start + 10; ++location) {
                if (location != this.myBufferEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(location))) continue;
                return location;
            }
            return location;
        }
        if (chAfterSlash == 'o' && (location = this.locateSeq(indexOfCharAfterSlash, (Function1<? super Character, Boolean>)((Function1)CidrStringLiteralLexer::locateAdditionalEscapeSequence$lambda$2))) >= 0) {
            return location;
        }
        if (chAfterSlash == 'N' && (location = this.locateSeq(indexOfCharAfterSlash, (Function1<? super Character, Boolean>)((Function1)CidrStringLiteralLexer::locateAdditionalEscapeSequence$lambda$3))) >= 0) {
            return location;
        }
        return -1;
    }

    @Nullable
    public IElementType getTokenType() {
        IElementType type = super.getTokenType();
        if (type == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN) {
            char ch = this.myBuffer.charAt(this.myStart + 1);
            switch (ch) {
                case 'U': {
                    if (this.myEnd - this.myStart == 10) break;
                    return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                }
                case 'N': {
                    if (this.myEnd - this.myStart > 4 && this.myBuffer.charAt(this.myEnd - 1) == '}') break;
                    return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                }
                case 'o': {
                    if (this.myBuffer.charAt(this.myEnd - 1) == '}' && StringUtil.isOctalDigit((char)this.myBuffer.charAt(this.myEnd - 2))) break;
                    return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                }
            }
        }
        return type;
    }

    private final int locateSeq(int indexOfCharAfterSlash, Function1<? super Character, Boolean> valid) {
        if (indexOfCharAfterSlash + 1 < this.myBufferEnd && this.myBuffer.charAt(indexOfCharAfterSlash + 1) == '{') {
            int location;
            for (location = indexOfCharAfterSlash + 2; location < this.myBufferEnd; ++location) {
                char ch = this.myBuffer.charAt(location);
                if (ch == '}') {
                    return location + 1;
                }
                if (((Boolean)valid.invoke((Object)Character.valueOf(ch))).booleanValue()) continue;
                return location;
            }
            return location;
        }
        return -1;
    }

    private static final boolean locateHexEscapeSequence$lambda$0(char ch) {
        return StringUtil.isHexDigit((char)ch);
    }

    private static final boolean locateUnicodeEscapeSequence$lambda$1(char ch) {
        return StringUtil.isHexDigit((char)ch);
    }

    private static final boolean locateAdditionalEscapeSequence$lambda$2(char ch) {
        return StringUtil.isOctalDigit((char)ch);
    }

    private static final boolean locateAdditionalEscapeSequence$lambda$3(char ch) {
        return ch != '}' && ch != '\"';
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/cidr/cpp/lexer/CidrStringLiteralLexer$Companion;", "", "<init>", "()V", "LONG_UNICODE_ESCAPE_CHAR", "", "NAMED_UNICODE_ESCAPE_CHAR", "OCTAL_ESCAPE_CHAR", "LONG_UNICODE_ESCAPE_SEQUENCE_LENGTH", "", "ADDITIONAL_VALID_ESCAPES", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.cidr.psi.base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

