/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.cpp;

import com.intellij.cidr.cpp.psi.CidrStringLiteralExpression;
import com.intellij.cidr.cpp.util.CidrStringCodec;
import com.intellij.cidr.cpp.util.CidrStringLiteral;
import com.intellij.cidr.cpp.util.CidrStringLiteralUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH&R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/cidr/cpp/CidrLiteralExpressionTextEscaper;", "T", "Lcom/intellij/cidr/cpp/util/CidrStringLiteral;", "Lcom/intellij/psi/LiteralTextEscaper;", "Lcom/intellij/cidr/cpp/psi/CidrStringLiteralExpression;", "myExpression", "<init>", "(Lcom/intellij/cidr/cpp/psi/CidrStringLiteralExpression;)V", "sourceOffsets", "", "decode", "", "rangeInsideHost", "Lcom/intellij/openapi/util/TextRange;", "outChars", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "singleOCStringLiteralForRange", "relatedNodes", "Lkotlin/sequences/Sequence;", "Lcom/intellij/lang/ASTNode;", "buildSourceOffsets", "getOffsetInHost", "", "offsetInDecoded", "isOneLine", "getStringCodec", "Lcom/intellij/cidr/cpp/util/CidrStringCodec;", "intellij.cidr.psi.base"})
public abstract class CidrLiteralExpressionTextEscaper<T extends CidrStringLiteral>
extends LiteralTextEscaper<CidrStringLiteralExpression<? extends T>> {
    private int[] sourceOffsets;

    public CidrLiteralExpressionTextEscaper(@NotNull CidrStringLiteralExpression<? extends T> myExpression) {
        Intrinsics.checkNotNullParameter(myExpression, (String)"myExpression");
        super((PsiLanguageInjectionHost)myExpression);
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
        Intrinsics.checkNotNullParameter((Object)outChars, (String)"outChars");
        int[] nArray = this.buildSourceOffsets(rangeInsideHost);
        if (nArray == null) {
            return false;
        }
        this.sourceOffsets = nArray;
        CidrStringLiteral cidrStringLiteral = this.singleOCStringLiteralForRange(rangeInsideHost);
        if (cidrStringLiteral == null) {
            return false;
        }
        CidrStringLiteral ocStringLiteral = cidrStringLiteral;
        String contents = ocStringLiteral.getContents(false);
        outChars.append(contents);
        return this.getOffsetInHost(contents.length(), rangeInsideHost) == rangeInsideHost.getEndOffset();
    }

    private final CidrStringLiteral singleOCStringLiteralForRange(TextRange rangeInsideHost) {
        ASTNode aSTNode = (ASTNode)SequencesKt.singleOrNull(this.relatedNodes(rangeInsideHost));
        if (aSTNode == null) {
            return null;
        }
        ASTNode astNode = aSTNode;
        return CidrStringLiteralUtil.parseStringLiteral(this.getStringCodec(), astNode.getText());
    }

    private final Sequence<ASTNode> relatedNodes(TextRange rangeInsideHost) {
        TextRange textRange = rangeInsideHost.shiftRight(((CidrStringLiteralExpression)this.myHost).getTextOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
        TextRange rangeInDoc = textRange;
        ASTNode[] aSTNodeArray = ((CidrStringLiteralExpression)this.myHost).getNode().getChildren(this.getStringCodec().getAllLiterals());
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
        return SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])aSTNodeArray), arg_0 -> CidrLiteralExpressionTextEscaper.relatedNodes$lambda$0(rangeInDoc, arg_0));
    }

    private final int[] buildSourceOffsets(TextRange rangeInsideHost) {
        IntArrayList sourceOffsetsList = new IntArrayList();
        int sourceOffset = 0;
        for (ASTNode astNode : this.relatedNodes(rangeInsideHost)) {
            CharSequence text;
            TextRange contentRangeInHost;
            T ocStringLiteral;
            Intrinsics.checkNotNullExpressionValue(CidrStringLiteralUtil.parseStringLiteral(this.getStringCodec(), astNode.getText()), (String)"parseStringLiteral(...)");
            String string = ((CidrStringLiteralExpression)this.myHost).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            CharSequence charSequence = string;
            String string2 = ((CidrStringLiteral)ocStringLiteral).contents;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"contents");
            int startIndex = StringsKt.indexOf$default((CharSequence)charSequence, (String)string2, (int)(astNode.getStartOffset() - ((CidrStringLiteralExpression)this.myHost).getTextRange().getStartOffset()), (boolean)false, (int)4, null);
            if (startIndex == -1) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)TextRange.from((int)startIndex, (int)((CidrStringLiteral)ocStringLiteral).contents.length()), (String)"from(...)");
            Intrinsics.checkNotNullExpressionValue((Object)contentRangeInHost.subSequence((CharSequence)((CidrStringLiteralExpression)this.myHost).getText()), (String)"subSequence(...)");
            int textLength = text.length();
            if (((CidrStringLiteral)ocStringLiteral).prefix.isRaw) {
                int n = 0;
                while (n < textLength) {
                    int it = n++;
                    boolean bl = false;
                    int n2 = sourceOffset;
                    sourceOffset = n2 + 1;
                    sourceOffsetsList.add(n2);
                }
                continue;
            }
            for (int positionInHost = 0; positionInHost < contentRangeInHost.getLength(); ++positionInHost) {
                int n = sourceOffset;
                sourceOffset = n + 1;
                sourceOffsetsList.add(n);
                if (text.charAt(positionInHost) != '\\') continue;
                n = sourceOffset;
                sourceOffset = n + 1;
                ++positionInHost;
            }
        }
        sourceOffsetsList.add(sourceOffset);
        return sourceOffsetsList.toIntArray();
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
        int[] nArray = this.sourceOffsets;
        if (this.sourceOffsets == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourceOffsets");
            nArray = null;
        }
        if (offsetInDecoded >= nArray.length) {
            return -1;
        }
        int[] nArray2 = this.sourceOffsets;
        if (this.sourceOffsets == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sourceOffsets");
            nArray2 = null;
        }
        return RangesKt.coerceAtMost((int)nArray2[offsetInDecoded], (int)rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    public boolean isOneLine() {
        return true;
    }

    @NotNull
    public abstract CidrStringCodec<T> getStringCodec();

    private static final boolean relatedNodes$lambda$0(TextRange $rangeInDoc, ASTNode it) {
        return $rangeInDoc.intersects(it.getTextRange());
    }
}

