/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.DexPathList;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import sun.misc.CompoundEnumeration;

public class BaseDexClassLoader
extends ClassLoader {
    private static volatile Reporter reporter = null;
    @UnsupportedAppUsage
    private final DexPathList pathList;
    protected final ClassLoader[] sharedLibraryLoaders;
    protected final ClassLoader[] sharedLibraryLoadersAfter;

    public BaseDexClassLoader(String dexPath, File optimizedDirectory, String librarySearchPath, ClassLoader parent) {
        this(dexPath, librarySearchPath, parent, null, null, false);
    }

    @UnsupportedAppUsage
    public BaseDexClassLoader(String dexPath, File optimizedDirectory, String librarySearchPath, ClassLoader parent, boolean isTrusted) {
        this(dexPath, librarySearchPath, parent, null, null, isTrusted);
    }

    public BaseDexClassLoader(String dexPath, String librarySearchPath, ClassLoader parent, ClassLoader[] libraries) {
        this(dexPath, librarySearchPath, parent, libraries, null, false);
    }

    public BaseDexClassLoader(String dexPath, String librarySearchPath, ClassLoader parent, ClassLoader[] libraries, ClassLoader[] librariesAfter) {
        this(dexPath, librarySearchPath, parent, libraries, librariesAfter, false);
    }

    public BaseDexClassLoader(String dexPath, String librarySearchPath, ClassLoader parent, ClassLoader[] sharedLibraryLoaders, ClassLoader[] sharedLibraryLoadersAfter, boolean isTrusted) {
        super(parent);
        this.sharedLibraryLoaders = sharedLibraryLoaders == null ? null : Arrays.copyOf(sharedLibraryLoaders, sharedLibraryLoaders.length);
        this.pathList = new DexPathList(this, dexPath, librarySearchPath, null, isTrusted);
        this.sharedLibraryLoadersAfter = sharedLibraryLoadersAfter == null ? null : Arrays.copyOf(sharedLibraryLoadersAfter, sharedLibraryLoadersAfter.length);
        this.pathList.maybeRunBackgroundVerification(this);
        this.reportClassLoaderChain();
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void reportClassLoaderChain() {
        if (reporter == null) {
            return;
        }
        String[] classPathAndClassLoaderContexts = this.computeClassLoaderContextsNative();
        if (classPathAndClassLoaderContexts.length == 0) {
            return;
        }
        HashMap<String, String> dexFileMapping = new HashMap<String, String>(classPathAndClassLoaderContexts.length / 2);
        for (int i = 0; i < classPathAndClassLoaderContexts.length; i += 2) {
            dexFileMapping.put(classPathAndClassLoaderContexts[i], classPathAndClassLoaderContexts[i + 1]);
        }
        reporter.report(Collections.unmodifiableMap(dexFileMapping));
    }

    private String[] computeClassLoaderContextsNative() {
        return (String[])OverrideMethod.invokeA("dalvik.system.BaseDexClassLoader#computeClassLoaderContextsNative()[Ljava/lang/String;", true, this);
    }

    public BaseDexClassLoader(ByteBuffer[] dexFiles, String librarySearchPath, ClassLoader parent) {
        super(parent);
        this.sharedLibraryLoaders = null;
        this.sharedLibraryLoadersAfter = null;
        this.pathList = new DexPathList(this, librarySearchPath);
        this.pathList.initByteBufferDexPath(dexFiles);
        this.pathList.maybeRunBackgroundVerification(this);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        ArrayList<Throwable> suppressedExceptions;
        Class<?> c;
        if (this.sharedLibraryLoaders != null) {
            for (ClassLoader loader : this.sharedLibraryLoaders) {
                try {
                    return loader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        if ((c = this.pathList.findClass(name, suppressedExceptions = new ArrayList<Throwable>())) != null) {
            return c;
        }
        if (this.sharedLibraryLoadersAfter != null) {
            for (ClassLoader loader : this.sharedLibraryLoadersAfter) {
                try {
                    return loader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        if (c == null) {
            ClassNotFoundException cnfe = new ClassNotFoundException("Didn't find class \"" + name + "\" on path: " + this.pathList);
            for (Throwable t : suppressedExceptions) {
                cnfe.addSuppressed(t);
            }
            throw cnfe;
        }
        return c;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public void addDexPath(String dexPath) {
        this.addDexPath(dexPath, false);
    }

    @UnsupportedAppUsage
    public void addDexPath(String dexPath, boolean isTrusted) {
        this.pathList.addDexPath(dexPath, null, isTrusted);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public void addNativePath(Collection<String> libPaths) {
        this.pathList.addNativePath(libPaths);
    }

    @Override
    protected URL findResource(String name) {
        URL url;
        if (this.sharedLibraryLoaders != null) {
            for (ClassLoader loader : this.sharedLibraryLoaders) {
                URL url2 = loader.getResource(name);
                if (url2 == null) continue;
                return url2;
            }
        }
        if ((url = this.pathList.findResource(name)) != null) {
            return url;
        }
        if (this.sharedLibraryLoadersAfter != null) {
            for (ClassLoader loader : this.sharedLibraryLoadersAfter) {
                URL url2 = loader.getResource(name);
                if (url2 == null) continue;
                return url2;
            }
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        int i;
        Enumeration<URL> myResources = this.pathList.findResources(name);
        if (this.sharedLibraryLoaders == null && this.sharedLibraryLoadersAfter == null) {
            return myResources;
        }
        int sharedLibraryLoadersCount = this.sharedLibraryLoaders != null ? this.sharedLibraryLoaders.length : 0;
        int sharedLibraryLoadersAfterCount = this.sharedLibraryLoadersAfter != null ? this.sharedLibraryLoadersAfter.length : 0;
        Enumeration[] tmp = new Enumeration[sharedLibraryLoadersCount + sharedLibraryLoadersAfterCount + 1];
        for (i = 0; i < sharedLibraryLoadersCount; ++i) {
            try {
                tmp[i] = this.sharedLibraryLoaders[i].getResources(name);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        tmp[i++] = myResources;
        for (int j = 0; j < sharedLibraryLoadersAfterCount; ++j) {
            try {
                tmp[i] = this.sharedLibraryLoadersAfter[j].getResources(name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
        return new CompoundEnumeration(tmp);
    }

    @Override
    public String findLibrary(String name) {
        return this.pathList.findLibrary(name);
    }

    @Override
    @Deprecated
    protected synchronized Package getPackage(String name) {
        if (name != null && !name.isEmpty()) {
            Package pack = super.getPackage(name);
            if (pack == null) {
                pack = this.definePackage(name, "Unknown", "0.0", "Unknown", "Unknown", "0.0", "Unknown", null);
            }
            return pack;
        }
        return null;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage
    public String getLdLibraryPath() {
        StringBuilder result = new StringBuilder();
        for (File directory : this.pathList.getNativeLibraryDirectories()) {
            if (result.length() > 0) {
                result.append(':');
            }
            result.append(directory);
        }
        return result.toString();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.pathList + "]";
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void setReporter(Reporter newReporter) {
        reporter = newReporter;
    }

    public static Reporter getReporter() {
        return reporter;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static interface Reporter {
        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        public void report(Map<String, String> var1);
    }
}

