/*
 * Decompiled with CFR 0.152.
 */
package com.google.ux.material.libmonet.dynamiccolor;

import com.google.ux.material.libmonet.dynamiccolor.ColorSpec;
import com.google.ux.material.libmonet.dynamiccolor.DynamicColor;
import com.google.ux.material.libmonet.dynamiccolor.MaterialDynamicColors;
import com.google.ux.material.libmonet.dynamiccolor.Variant;
import com.google.ux.material.libmonet.hct.Hct;
import com.google.ux.material.libmonet.palettes.TonalPalette;
import com.google.ux.material.libmonet.utils.MathUtils;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Optional;

public class DynamicScheme {
    public static final ColorSpec.SpecVersion DEFAULT_SPEC_VERSION = ColorSpec.SpecVersion.SPEC_2025;
    public static final Platform DEFAULT_PLATFORM = Platform.PHONE;
    public final int sourceColorArgb;
    public final Hct sourceColorHct;
    public final Variant variant;
    public final boolean isDark;
    public final Platform platform;
    public final double contrastLevel;
    public final ColorSpec.SpecVersion specVersion;
    public final TonalPalette primaryPalette;
    public final TonalPalette secondaryPalette;
    public final TonalPalette tertiaryPalette;
    public final TonalPalette neutralPalette;
    public final TonalPalette neutralVariantPalette;
    public final TonalPalette errorPalette;

    public DynamicScheme(Hct sourceColorHct, Variant variant, boolean isDark, double contrastLevel, TonalPalette primaryPalette, TonalPalette secondaryPalette, TonalPalette tertiaryPalette, TonalPalette neutralPalette, TonalPalette neutralVariantPalette) {
        this(sourceColorHct, variant, isDark, contrastLevel, primaryPalette, secondaryPalette, tertiaryPalette, neutralPalette, neutralVariantPalette, Optional.empty());
    }

    public DynamicScheme(Hct sourceColorHct, Variant variant, boolean isDark, double contrastLevel, TonalPalette primaryPalette, TonalPalette secondaryPalette, TonalPalette tertiaryPalette, TonalPalette neutralPalette, TonalPalette neutralVariantPalette, Optional<TonalPalette> errorPalette) {
        this(sourceColorHct, variant, isDark, contrastLevel, Platform.PHONE, ColorSpec.SpecVersion.SPEC_2021, primaryPalette, secondaryPalette, tertiaryPalette, neutralPalette, neutralVariantPalette, errorPalette);
    }

    public DynamicScheme(Hct sourceColorHct, Variant variant, boolean isDark, double contrastLevel, Platform platform, ColorSpec.SpecVersion specVersion, TonalPalette primaryPalette, TonalPalette secondaryPalette, TonalPalette tertiaryPalette, TonalPalette neutralPalette, TonalPalette neutralVariantPalette, Optional<TonalPalette> errorPalette) {
        this.sourceColorArgb = sourceColorHct.toInt();
        this.sourceColorHct = sourceColorHct;
        this.variant = variant;
        this.isDark = isDark;
        this.contrastLevel = contrastLevel;
        this.platform = platform;
        this.specVersion = specVersion;
        this.primaryPalette = primaryPalette;
        this.secondaryPalette = secondaryPalette;
        this.tertiaryPalette = tertiaryPalette;
        this.neutralPalette = neutralPalette;
        this.neutralVariantPalette = neutralVariantPalette;
        this.errorPalette = errorPalette.orElse(TonalPalette.fromHueAndChroma(25.0, 84.0));
    }

    public static DynamicScheme from(DynamicScheme other, boolean isDark) {
        return new DynamicScheme(other.sourceColorHct, other.variant, isDark, other.contrastLevel, other.platform, other.specVersion, other.primaryPalette, other.secondaryPalette, other.tertiaryPalette, other.neutralPalette, other.neutralVariantPalette, Optional.of(other.errorPalette));
    }

    public static double getPiecewiseValue(Hct sourceColorHct, double[] hueBreakpoints, double[] hues) {
        int size = Math.min(hueBreakpoints.length - 1, hues.length);
        double sourceHue = sourceColorHct.getHue();
        for (int i = 0; i < size; ++i) {
            if (!(sourceHue >= hueBreakpoints[i]) || !(sourceHue < hueBreakpoints[i + 1])) continue;
            return MathUtils.sanitizeDegreesDouble(hues[i]);
        }
        return sourceHue;
    }

    public static double getRotatedHue(Hct sourceColorHct, double[] hueBreakpoints, double[] rotations) {
        double rotation = DynamicScheme.getPiecewiseValue(sourceColorHct, hueBreakpoints, rotations);
        if (Math.min(hueBreakpoints.length - 1, rotations.length) <= 0) {
            rotation = 0.0;
        }
        return MathUtils.sanitizeDegreesDouble(sourceColorHct.getHue() + rotation);
    }

    public Hct getHct(DynamicColor dynamicColor) {
        return dynamicColor.getHct(this);
    }

    public int getArgb(DynamicColor dynamicColor) {
        return dynamicColor.getArgb(this);
    }

    public String toString() {
        return String.format("Scheme: variant=%s, mode=%s, platform=%s, contrastLevel=%s, seed=%s, specVersion=%s", new Object[]{this.variant.name(), this.isDark ? "dark" : "light", this.platform.name().toLowerCase(Locale.ENGLISH), new DecimalFormat("0.0").format(this.contrastLevel), this.sourceColorHct, this.specVersion});
    }

    public int getPrimaryPaletteKeyColor() {
        return this.getArgb(new MaterialDynamicColors().primaryPaletteKeyColor());
    }

    public int getSecondaryPaletteKeyColor() {
        return this.getArgb(new MaterialDynamicColors().secondaryPaletteKeyColor());
    }

    public int getTertiaryPaletteKeyColor() {
        return this.getArgb(new MaterialDynamicColors().tertiaryPaletteKeyColor());
    }

    public int getNeutralPaletteKeyColor() {
        return this.getArgb(new MaterialDynamicColors().neutralPaletteKeyColor());
    }

    public int getNeutralVariantPaletteKeyColor() {
        return this.getArgb(new MaterialDynamicColors().neutralVariantPaletteKeyColor());
    }

    public int getBackground() {
        return this.getArgb(new MaterialDynamicColors().background());
    }

    public int getOnBackground() {
        return this.getArgb(new MaterialDynamicColors().onBackground());
    }

    public int getSurface() {
        return this.getArgb(new MaterialDynamicColors().surface());
    }

    public int getSurfaceDim() {
        return this.getArgb(new MaterialDynamicColors().surfaceDim());
    }

    public int getSurfaceBright() {
        return this.getArgb(new MaterialDynamicColors().surfaceBright());
    }

    public int getSurfaceContainerLowest() {
        return this.getArgb(new MaterialDynamicColors().surfaceContainerLowest());
    }

    public int getSurfaceContainerLow() {
        return this.getArgb(new MaterialDynamicColors().surfaceContainerLow());
    }

    public int getSurfaceContainer() {
        return this.getArgb(new MaterialDynamicColors().surfaceContainer());
    }

    public int getSurfaceContainerHigh() {
        return this.getArgb(new MaterialDynamicColors().surfaceContainerHigh());
    }

    public int getSurfaceContainerHighest() {
        return this.getArgb(new MaterialDynamicColors().surfaceContainerHighest());
    }

    public int getOnSurface() {
        return this.getArgb(new MaterialDynamicColors().onSurface());
    }

    public int getSurfaceVariant() {
        return this.getArgb(new MaterialDynamicColors().surfaceVariant());
    }

    public int getOnSurfaceVariant() {
        return this.getArgb(new MaterialDynamicColors().onSurfaceVariant());
    }

    public int getInverseSurface() {
        return this.getArgb(new MaterialDynamicColors().inverseSurface());
    }

    public int getInverseOnSurface() {
        return this.getArgb(new MaterialDynamicColors().inverseOnSurface());
    }

    public int getOutline() {
        return this.getArgb(new MaterialDynamicColors().outline());
    }

    public int getOutlineVariant() {
        return this.getArgb(new MaterialDynamicColors().outlineVariant());
    }

    public int getShadow() {
        return this.getArgb(new MaterialDynamicColors().shadow());
    }

    public int getScrim() {
        return this.getArgb(new MaterialDynamicColors().scrim());
    }

    public int getSurfaceTint() {
        return this.getArgb(new MaterialDynamicColors().surfaceTint());
    }

    public int getPrimary() {
        return this.getArgb(new MaterialDynamicColors().primary());
    }

    public int getOnPrimary() {
        return this.getArgb(new MaterialDynamicColors().onPrimary());
    }

    public int getPrimaryContainer() {
        return this.getArgb(new MaterialDynamicColors().primaryContainer());
    }

    public int getOnPrimaryContainer() {
        return this.getArgb(new MaterialDynamicColors().onPrimaryContainer());
    }

    public int getInversePrimary() {
        return this.getArgb(new MaterialDynamicColors().inversePrimary());
    }

    public int getSecondary() {
        return this.getArgb(new MaterialDynamicColors().secondary());
    }

    public int getOnSecondary() {
        return this.getArgb(new MaterialDynamicColors().onSecondary());
    }

    public int getSecondaryContainer() {
        return this.getArgb(new MaterialDynamicColors().secondaryContainer());
    }

    public int getOnSecondaryContainer() {
        return this.getArgb(new MaterialDynamicColors().onSecondaryContainer());
    }

    public int getTertiary() {
        return this.getArgb(new MaterialDynamicColors().tertiary());
    }

    public int getOnTertiary() {
        return this.getArgb(new MaterialDynamicColors().onTertiary());
    }

    public int getTertiaryContainer() {
        return this.getArgb(new MaterialDynamicColors().tertiaryContainer());
    }

    public int getOnTertiaryContainer() {
        return this.getArgb(new MaterialDynamicColors().onTertiaryContainer());
    }

    public int getError() {
        return this.getArgb(new MaterialDynamicColors().error());
    }

    public int getOnError() {
        return this.getArgb(new MaterialDynamicColors().onError());
    }

    public int getErrorContainer() {
        return this.getArgb(new MaterialDynamicColors().errorContainer());
    }

    public int getOnErrorContainer() {
        return this.getArgb(new MaterialDynamicColors().onErrorContainer());
    }

    public int getPrimaryFixed() {
        return this.getArgb(new MaterialDynamicColors().primaryFixed());
    }

    public int getPrimaryFixedDim() {
        return this.getArgb(new MaterialDynamicColors().primaryFixedDim());
    }

    public int getOnPrimaryFixed() {
        return this.getArgb(new MaterialDynamicColors().onPrimaryFixed());
    }

    public int getOnPrimaryFixedVariant() {
        return this.getArgb(new MaterialDynamicColors().onPrimaryFixedVariant());
    }

    public int getSecondaryFixed() {
        return this.getArgb(new MaterialDynamicColors().secondaryFixed());
    }

    public int getSecondaryFixedDim() {
        return this.getArgb(new MaterialDynamicColors().secondaryFixedDim());
    }

    public int getOnSecondaryFixed() {
        return this.getArgb(new MaterialDynamicColors().onSecondaryFixed());
    }

    public int getOnSecondaryFixedVariant() {
        return this.getArgb(new MaterialDynamicColors().onSecondaryFixedVariant());
    }

    public int getTertiaryFixed() {
        return this.getArgb(new MaterialDynamicColors().tertiaryFixed());
    }

    public int getTertiaryFixedDim() {
        return this.getArgb(new MaterialDynamicColors().tertiaryFixedDim());
    }

    public int getOnTertiaryFixed() {
        return this.getArgb(new MaterialDynamicColors().onTertiaryFixed());
    }

    public int getOnTertiaryFixedVariant() {
        return this.getArgb(new MaterialDynamicColors().onTertiaryFixedVariant());
    }

    public int getControlActivated() {
        return this.getArgb(new MaterialDynamicColors().controlActivated());
    }

    public int getControlNormal() {
        return this.getArgb(new MaterialDynamicColors().controlNormal());
    }

    public int getControlHighlight() {
        return this.getArgb(new MaterialDynamicColors().controlHighlight());
    }

    public int getTextPrimaryInverse() {
        return this.getArgb(new MaterialDynamicColors().textPrimaryInverse());
    }

    public int getTextSecondaryAndTertiaryInverse() {
        return this.getArgb(new MaterialDynamicColors().textSecondaryAndTertiaryInverse());
    }

    public int getTextPrimaryInverseDisableOnly() {
        return this.getArgb(new MaterialDynamicColors().textPrimaryInverseDisableOnly());
    }

    public int getTextSecondaryAndTertiaryInverseDisabled() {
        return this.getArgb(new MaterialDynamicColors().textSecondaryAndTertiaryInverseDisabled());
    }

    public int getTextHintInverse() {
        return this.getArgb(new MaterialDynamicColors().textHintInverse());
    }

    public static enum Platform {
        PHONE,
        WATCH;

    }
}

